/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.pessoa;

import com.touchcomp.basementor.constants.enums.validacao.EnumValidacaoTipo;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.LogPessoa;
import com.touchcomp.basementor.model.vo.OpcoesValidacao;
import com.touchcomp.basementor.model.vo.OpcoesValidacaoItem;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TelefonePessoa;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoPessoaImpl;
import com.touchcomp.basementorservice.helpers.impl.pessoa.HelperPessoa;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapResumoInfoPessoa;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.cliente.ServiceClienteImpl;
import com.touchcomp.basementorservice.service.impl.fornecedor.ServiceFornecedorImpl;
import com.touchcomp.basementorservice.service.impl.logpessoa.ServiceLogPessoaImpl;
import com.touchcomp.basementorservice.service.impl.opcoesvalidacao.ServiceOpcoesValidacaoImpl;
import com.touchcomp.basementorservice.service.impl.representante.ServiceRepresentanteImpl;
import com.touchcomp.basementorservice.service.interfaces.ServicePessoa;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.usuariobasico.web.DTOUsuarioBasicoSimple;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServicePessoaImpl
extends ServiceGenericEntityImpl<Pessoa, Long, DaoPessoaImpl>
implements ServicePessoa {
    HelperPessoa helperPessoa;
    ServiceLogPessoaImpl serviceLogPessoaImpl;
    ServiceRepresentanteImpl serviceRepresentanteImpl;
    ServiceFornecedorImpl serviceFornecedorImpl;
    ServiceClienteImpl serviceClienteImpl;
    ServiceOpcoesValidacaoImpl serviceOpcoesValidacao;

    @Autowired
    public ServicePessoaImpl(DaoPessoaImpl genericDao, HelperPessoa helperPessoa, ServiceLogPessoaImpl serviceLogPessoaImpl, ServiceRepresentanteImpl serviceRepresentanteImpl, ServiceFornecedorImpl serviceFornecedorImpl, ServiceClienteImpl serviceClienteImpl, ServiceOpcoesValidacaoImpl serviceOpcoesValidacao) {
        super(genericDao);
        this.helperPessoa = helperPessoa;
        this.serviceLogPessoaImpl = serviceLogPessoaImpl;
        this.serviceClienteImpl = serviceClienteImpl;
        this.serviceFornecedorImpl = serviceFornecedorImpl;
        this.serviceRepresentanteImpl = serviceRepresentanteImpl;
        this.serviceOpcoesValidacao = serviceOpcoesValidacao;
    }

    @Override
    public Pessoa getByCPFCNPJ(String cpfCnpj) {
        return ((DaoPessoaImpl)this.getGenericDao()).getByCPFCNPJ(cpfCnpj);
    }

    @Override
    public Pessoa getByCPFCNPJAtiva(String cpfCnpj) {
        return ((DaoPessoaImpl)this.getGenericDao()).getByCPFCNPJAtiva(cpfCnpj);
    }

    @Override
    public Pessoa getByCPFCNPJInativa(String cpfCnpj) {
        return ((DaoPessoaImpl)this.getGenericDao()).getByCPFCNPJInativa(cpfCnpj);
    }

    @Override
    public Pessoa get(String inscEst, String cpfCnpj) {
        return ((DaoPessoaImpl)this.getGenericDao()).get(inscEst, cpfCnpj);
    }

    @Override
    public GenericMapValues<GenMapResumoInfoPessoa> getEstatisticasFinanceiras(Long idPessoa) {
        return ((DaoPessoaImpl)this.getDao()).getEstatisticasFinanceiras(idPessoa);
    }

    @Override
    public List<Pessoa> getListCPFCNPJAtiva(String cpfCnpj) {
        return ((DaoPessoaImpl)this.getGenericDao()).getListCPFCNPJAtiva(cpfCnpj);
    }

    @Override
    public Pessoa saveOrUpdateOnly(Pessoa entity) {
        if (TMethods.isWithData((Number)entity.getIdentificador())) {
            Pessoa old = (Pessoa)this.get(entity.getIdentificador());
            List<LogPessoa> logs = this.helperPessoa.avaliaMudancasPessoa(entity, old);
            this.serviceLogPessoaImpl.saveOrUpdate(logs);
            this.verificarCadastrosVincAtivos(entity);
        }
        return super.saveOrUpdateOnly(entity);
    }

    private void verificarCadastrosVincAtivos(Pessoa vo) {
        if (TMethods.isAffirmative((Number)vo.getAtivo())) {
            return;
        }
        List<Representante> rep = this.serviceRepresentanteImpl.get(vo, (short)1);
        List<Cliente> cli = this.serviceClienteImpl.get(vo, (short)1);
        List<Fornecedor> forn = this.serviceFornecedorImpl.get(vo, (short)1);
        if (!rep.isEmpty()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0047.003", new Object[]{vo}));
        }
        if (!cli.isEmpty()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0047.001", new Object[]{vo}));
        }
        if (!forn.isEmpty()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0047.002", new Object[]{vo}));
        }
    }

    public Pessoa getByInscricaoEstadualUf(String inscEst, String uf) {
        return ((DaoPessoaImpl)this.getGenericDao()).getByInscricaoEstadualUf(inscEst, uf);
    }

    public Pessoa findPessoaToVincRepresentante(Long idPessoa) throws ExceptionObjNotFound, ExceptionInvalidData {
        Pessoa vo = (Pessoa)this.getOrThrow(idPessoa);
        if (this.isNotNull(this.serviceRepresentanteImpl.findByIdPessoa(idPessoa)).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0072.003", new Object[0]);
        }
        return this.helperPessoa.validarPessoa(vo);
    }

    @Override
    public Pessoa beforeSave(Pessoa vo) {
        for (EmailPessoa e : vo.getComplemento().getEmails()) {
            e.setComplemento(vo.getComplemento());
        }
        for (TelefonePessoa t : vo.getComplemento().getOutrosTelefones()) {
            t.setComplemento(vo.getComplemento());
        }
        if (vo.getComplemento() != null) {
            vo.getComplemento().setCnpj(this.helperPessoa.getCnpjCpfComZeros(vo.getComplemento().getCnpj()));
            vo.getComplemento().setPessoaEstrangeira(Short.valueOf(this.helperPessoa.build(vo).isEstrangeira().getValue()));
        }
        return vo;
    }

    public Boolean avisarUsuarioCpfDuplicado(String cpfCnpj) {
        Pessoa aux;
        if (!this.isStrWithData(cpfCnpj)) {
            return false;
        }
        cpfCnpj = ToolString.refina((String)cpfCnpj);
        OpcoesValidacao opcoesValidacao = (OpcoesValidacao)this.serviceOpcoesValidacao.getFirst();
        OpcoesValidacaoItem validarCpfCnpj = this.serviceOpcoesValidacao.getItem(opcoesValidacao, "V.ERP.0047.001");
        if (this.isNotNull(validarCpfCnpj).booleanValue() && this.isEquals(EnumValidacaoTipo.get((Object)validarCpfCnpj.getTipoValidacao()), EnumValidacaoTipo.APENAS_AVISAR) && this.isNotNull(aux = ((DaoPessoaImpl)this.getGenericDao()).getByCPFCNPJ(cpfCnpj)).booleanValue()) {
            return true;
        }
        return false;
    }

    public Pessoa getByCnpjInscricaoEstadualAtiva(String cnpjCpf, String ie) {
        return ((DaoPessoaImpl)this.getDao()).getByCnpjInscricaoEstadualAtiva(cnpjCpf, ie);
    }

    public List<String> getCnpjPessoasAtivos() {
        return ((DaoPessoaImpl)this.getDao()).getCnpjPessoasAtivos();
    }

    public HashMap preencherCartiraComCpf(Long idPessoa) throws ExceptionObjNotFound {
        Pessoa pessoa = (Pessoa)this.getOrThrow(idPessoa);
        String cpf = pessoa.getComplemento().getCnpj();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("carteiraProfissional", cpf.substring(0, 7));
        map.put("serieCarteiraProfissional", cpf.substring(cpf.length() - 4));
        return map;
    }

    public Pessoa saveOrUpdate(DTOUsuarioBasicoSimple.DTOPessoaRes pRes, Pessoa pessoa) {
        EmailPessoa e;
        Optional<EmailPessoa> found;
        Complemento c = pessoa.getComplemento();
        c.setEmailPrincipal(pRes.getComplemento().getEmailPrincipal());
        c.setSite(pRes.getComplemento().getSite());
        for (DTOUsuarioBasicoSimple.DTOEmailRes em : pRes.getComplemento().getEmails()) {
            found = c.getEmails().stream().filter(i -> this.isEquals(i.getIdentificador(), em.getIdentificador())).findFirst();
            if (found.isPresent()) {
                e = found.get();
            } else {
                e = new EmailPessoa();
                c.getEmails().add(e);
            }
            e.setAtivo(em.getAtivo());
            e.setDescricao(em.getDescricao());
            e.setEmail(em.getEmail());
            e.setEnviarDadosCotacao(em.getEnviarDadosCotacao());
            e.setEnviarDadosCte(em.getEnviarDadosCte());
            e.setEnviarDadosFinanceiro(em.getEnviarDadosFinanceiro());
            e.setEnviarDadosMdfe(em.getEnviarDadosMdfe());
            e.setEnviarDadosNfe(em.getEnviarDadosNfe());
            e.setEnviarDadosRelacionamento(em.getEnviarDadosRelacionamento());
            e.setComplemento(c);
        }
        for (DTOUsuarioBasicoSimple.DTOEmailRes em : pRes.getComplemento().getOutrosTelefones()) {
            found = c.getOutrosTelefones().stream().filter(arg_0 -> this.lambda$saveOrUpdate$1((DTOUsuarioBasicoSimple.DTOTelefoneRes)em, arg_0)).findFirst();
            if (found.isPresent()) {
                e = (TelefonePessoa)found.get();
            } else {
                e = new TelefonePessoa();
                c.getOutrosTelefones().add(e);
            }
            e.setDescricao(em.getDescricao());
            e.setTelefone(em.getTelefone());
            e.setComplemento(c);
        }
        return this.saveOrUpdate(pessoa);
    }

    private /* synthetic */ boolean lambda$saveOrUpdate$1(DTOUsuarioBasicoSimple.DTOTelefoneRes em, TelefonePessoa i) {
        return this.isEquals(i.getIdentificador(), em.getIdentificador());
    }
}

