/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.planejamentomateriaisprodlin;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoPlanejamentoMateriaisLin;
import com.touchcomp.basementor.model.vo.ItemMaterialPlanejLin;
import com.touchcomp.basementor.model.vo.ItemPlanejamentoProdLinhaProd;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.PlanejProdLinProdPrevConsProd;
import com.touchcomp.basementor.model.vo.PlanejamentoMateriaisProdLin;
import com.touchcomp.basementor.model.vo.PlanejamentoProdLinhaProd;
import com.touchcomp.basementor.model.vo.TransfEstoquePCPLin;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.materiaisplanejamentoproducao.CompMateriaisPlanejamentoProducao;
import com.touchcomp.basementorservice.dao.impl.DaoPlanejamentoMateriaisProdLinImpl;
import com.touchcomp.basementorservice.helpers.impl.planejamentomateriaisprodlin.HelperPlanejamentoMateriaisProdLin;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.opcoescomprasuprimentos.ServiceOpcoesCompraSuprimentosImpl;
import com.touchcomp.basementorservice.service.impl.planejamentoprodlinhaprod.ServicePlanejamentoProdLinhaProdImpl;
import com.touchcomp.basementorservice.service.impl.transfestoquepcplin.SCompTransfCentroEstoquePCPLin;
import com.touchcomp.basementorservice.service.impl.transfestoquepcplin.ServiceTransfEstoquePCPLinImpl;
import com.touchcomp.touchvomodel.vo.planejamentomateriaisprodlin.web.DTOPlanejamentoMateriaisProdLin;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServicePlanejamentoMateriaisProdLinImpl
extends ServiceGenericEntityImpl<PlanejamentoMateriaisProdLin, Long, DaoPlanejamentoMateriaisProdLinImpl> {
    @Autowired
    private CompMateriaisPlanejamentoProducao comp;
    @Autowired
    private HelperPlanejamentoMateriaisProdLin helper;
    @Autowired
    private SCompTransfCentroEstoquePCPLin compTransfCentroEstoquePCPLin;
    @Autowired
    private ServicePlanejamentoProdLinhaProdImpl servicePlanejamentoProdLinhaProd;
    @Autowired
    private ServiceOpcoesCompraSuprimentosImpl serviceOpcoesCompraSup;
    @Autowired
    private ServiceTransfEstoquePCPLinImpl serviceTransfEstoquePCPLin;

    @Autowired
    public ServicePlanejamentoMateriaisProdLinImpl(DaoPlanejamentoMateriaisProdLinImpl dao) {
        super(dao);
    }

    @Override
    public PlanejamentoMateriaisProdLin beforeSaveEntity(PlanejamentoMateriaisProdLin vo) {
        try {
            this.helper.build(vo).gerarNecessidadeCompraPlanejamento(this.serviceOpcoesCompraSup.get(vo.getEmpresa()));
            this.compTransfCentroEstoquePCPLin.gerarTransferencias(vo);
            if (ServicePlanejamentoMateriaisProdLinImpl.isWithData(vo.getPrevisaoConsProdutos())) {
                for (PlanejProdLinProdPrevConsProd item : vo.getPrevisaoConsProdutos()) {
                    item.setPlanejamentoMatProdLin(vo);
                    if (!ServicePlanejamentoMateriaisProdLinImpl.isWithData(item.getItemPlanejProdLinProdPrevConsProd())) continue;
                    item.getItemPlanejProdLinProdPrevConsProd().forEach(i -> i.setPlanejProdLinProdPrevConsProd(item));
                }
            }
            if (ServicePlanejamentoMateriaisProdLinImpl.isWithData(vo.getItensPlanProdLinha())) {
                vo.getItensPlanProdLinha().forEach(i -> i.setPlanejamentoMatProdLin(vo));
            }
            if (ServicePlanejamentoMateriaisProdLinImpl.isWithData(vo.getGruposPlanejMat())) {
                for (GrupoPlanejamentoMateriaisLin grupo : vo.getGruposPlanejMat()) {
                    grupo.setPlanejamentoMatProdLin(vo);
                    if (!ServicePlanejamentoMateriaisProdLinImpl.isWithData(grupo.getItensMateriaisPlanejLin())) continue;
                    for (ItemMaterialPlanejLin itemMat : grupo.getItensMateriaisPlanejLin()) {
                        itemMat.setGrupoPlanejamentoMateriaisLin(grupo);
                        if (!this.isNotNull(itemMat.getPrevisaoConsProduto()).booleanValue()) continue;
                        itemMat.getPrevisaoConsProduto().getItemPlanejProdLinProdPrevConsProd().forEach(i -> i.setPlanejProdLinProdPrevConsProd(itemMat.getPrevisaoConsProduto()));
                    }
                }
            }
            return vo;
        }
        catch (ExceptionInvalidData ex) {
            throw new ExceptionRuntimeBase((ExceptionBase)((Object)ex));
        }
    }

    public DTOPlanejamentoMateriaisProdLin processar(DTOPlanejamentoMateriaisProdLin input, Empresa empresa, OpcoesPCP opcoesPCP) throws ExceptionInvalidData {
        PlanejamentoMateriaisProdLin vo = (PlanejamentoMateriaisProdLin)this.buildToEntity(input);
        if (this.isNull(vo.getDataConsulta()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.2016.001", new Object[0]);
        }
        if (ServicePlanejamentoMateriaisProdLinImpl.isWithData(vo.getItensPlanProdLinha())) {
            List<PlanejProdLinProdPrevConsProd> todosMateriais = new LinkedList<PlanejProdLinProdPrevConsProd>();
            for (ItemPlanejamentoProdLinhaProd item : vo.getItensPlanProdLinha()) {
                if (((DaoPlanejamentoMateriaisProdLinImpl)this.getGenericDao()).verificaPlanejProducaoVincPlanejMateriais(item.getPlanejProdLinha()).booleanValue()) continue;
                List<PlanejProdLinProdPrevConsProd> materiais = this.comp.calcularMaterialNecessarioSubOsAbertas(item.getPlanejProdLinha(), vo.getDataConsulta(), empresa);
                todosMateriais.addAll(materiais);
            }
            todosMateriais = this.comp.agruparMateriais(todosMateriais, empresa, opcoesPCP, vo.getDataConsulta());
            this.comp.separarGruposMateriaisCompraReserva(vo, todosMateriais);
        }
        return this.buildToDTO(vo, DTOPlanejamentoMateriaisProdLin.class);
    }

    public WebDTOResult<List<DTOPlanejamentoMateriaisProdLin.DTOItemPlanejamentoProdLinhaProd>> getPlanejamentosProducao(Long[] identificadores) {
        WebDTOResult webResult = new WebDTOResult();
        LinkedList<ItemPlanejamentoProdLinhaProd> ret = new LinkedList<ItemPlanejamentoProdLinhaProd>();
        List planejamentos = this.servicePlanejamentoProdLinhaProd.gets(identificadores);
        for (PlanejamentoProdLinhaProd p : planejamentos) {
            if (!this.isAffimative(p.getTravarProducao())) {
                webResult.addErroMessage("E.ERP.2016.005", MessagesBaseMentor.getErrorMsg((String)"E.ERP.2016.005", (Object[])new Object[]{String.valueOf(p)}));
                continue;
            }
            if (this.isAffimative(p.getSimulacao())) {
                webResult.addErroMessage("E.ERP.2016.007", MessagesBaseMentor.getErrorMsg((String)"E.ERP.2016.007", (Object[])new Object[]{String.valueOf(p)}));
                continue;
            }
            if (((DaoPlanejamentoMateriaisProdLinImpl)this.getGenericDao()).verificaPlanejProducaoVincPlanejMateriais(p).booleanValue()) {
                webResult.addErroMessage("E.ERP.2016.006", MessagesBaseMentor.getErrorMsg((String)"E.ERP.2016.006", (Object[])new Object[]{String.valueOf(p)}));
                continue;
            }
            ItemPlanejamentoProdLinhaProd vo = new ItemPlanejamentoProdLinhaProd();
            vo.setPlanejProdLinha(p);
            ret.add(vo);
        }
        webResult.setResult(this.buildToDTOGeneric(ret, DTOPlanejamentoMateriaisProdLin.DTOItemPlanejamentoProdLinhaProd.class));
        return webResult;
    }

    public boolean verificaPlanejProducaoVincPlanejMateriais(PlanejamentoProdLinhaProd planejLinhaProd) {
        return ((DaoPlanejamentoMateriaisProdLinImpl)this.getDao()).verificaPlanejProducaoVincPlanejMateriais(planejLinhaProd);
    }

    public String getObservacoesTransferencias(Long identificador) throws ExceptionObjNotFound {
        PlanejamentoMateriaisProdLin vo = (PlanejamentoMateriaisProdLin)this.getOrThrow(identificador);
        if (!this.isAffimative(vo.getLiberarReserva())) {
            return null;
        }
        List<TransfEstoquePCPLin> transferencias = this.serviceTransfEstoquePCPLin.findTransferenciasPlanejamento(vo);
        if (ServicePlanejamentoMateriaisProdLinImpl.isWithData(transferencias)) {
            StringBuilder sb = new StringBuilder();
            for (TransfEstoquePCPLin t : transferencias) {
                sb.append("Transfer\u00eancia Id.: ").append(t.getIdentificador()).append(" - ");
                if (this.isStrWithData(t.getDescricao())) {
                    sb.append(t.getDescricao()).append(" - ");
                }
                if (!this.isStrWithData(t.getObservacaoSistema())) continue;
                sb.append(t.getObservacaoSistema());
            }
            return sb.toString();
        }
        return null;
    }
}

