/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.planejamentoorcamentario;

import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.IntervaloControleGer;
import com.touchcomp.basementor.model.vo.IntervaloControleGerPer;
import com.touchcomp.basementor.model.vo.PacoteOrcamentario;
import com.touchcomp.basementor.model.vo.PacoteOrcamentarioPCGerCC;
import com.touchcomp.basementor.model.vo.PlanejamentoOrcamentario;
import com.touchcomp.basementor.model.vo.PlanejamentoOrcamentarioItem;
import com.touchcomp.basementor.model.vo.PlanejamentoOrcamentarioItemPer;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementorservice.dao.impl.DaoPlanejamentoOrcamentarioImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.intervalocontroleger.ServiceIntervaloControleGerImpl;
import com.touchcomp.basementorservice.service.impl.pacoteorcamentario.ServicePacoteOrcamentarioImpl;
import com.touchcomp.touchvomodel.vo.planejamentoorcamentario.DTOPlanejamentoOrcamentario;
import java.util.Date;
import java.util.LinkedList;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class ServicePlanejamentoOrcamentarioImpl
extends ServiceGenericEntityImpl<PlanejamentoOrcamentario, Long, DaoPlanejamentoOrcamentarioImpl> {
    private final ServicePacoteOrcamentarioImpl servicePacoteOrcamentario;
    private final ServiceIntervaloControleGerImpl serviceIntervaloControlGerencial;

    public ServicePlanejamentoOrcamentarioImpl(DaoPlanejamentoOrcamentarioImpl genericDao, ServicePacoteOrcamentarioImpl servicePacoteOrcamentario, ServiceIntervaloControleGerImpl serviceIntervaloControlGerencial) {
        super(genericDao);
        this.serviceIntervaloControlGerencial = serviceIntervaloControlGerencial;
        this.servicePacoteOrcamentario = servicePacoteOrcamentario;
    }

    public DTOPlanejamentoOrcamentario buildIntervalos(DTOPlanejamentoOrcamentario dto) {
        return this.buildIntervalos(dto, null);
    }

    public DTOPlanejamentoOrcamentario buildIntervalos(DTOPlanejamentoOrcamentario dto, Long idPlanejamento) {
        PacoteOrcamentario pacote = (PacoteOrcamentario)this.servicePacoteOrcamentario.get(dto.getPacoteOrcamentarioIdentificador());
        IntervaloControleGer intervalo = (IntervaloControleGer)this.serviceIntervaloControlGerencial.get(dto.getIntervalorControleGerIdentificador());
        PlanejamentoOrcamentario planejamento = (PlanejamentoOrcamentario)this.get(idPlanejamento);
        this.checkAndThrownNotExists((Object)pacote, this.getMessage(PacoteOrcamentario.class, new Object[0]));
        this.checkAndThrownNotExists((Object)intervalo, this.getMessage(IntervaloControleGer.class, new Object[0]));
        this.checkAndThrownInactive((Number)pacote.getAtivo(), this.getMessage(PacoteOrcamentario.class, new Object[0]));
        LinkedList ret = new LinkedList();
        PlanejamentoOrcamentario chegando = (PlanejamentoOrcamentario)this.buildToEntity(dto);
        pacote.getPlanosConta().forEach(pc -> {
            if (!pc.getCentrosCusto().isEmpty()) {
                for (PacoteOrcamentarioPCGerCC cc : pc.getCentrosCusto()) {
                    this.createItem(pc.getPlanoContaGerencial(), cc.getCentroCusto(), chegando, intervalo, ret);
                }
            } else {
                this.createItem(pc.getPlanoContaGerencial(), null, chegando, intervalo, ret);
            }
        });
        chegando.setItens(ret);
        return this.buildToDTOGeneric(chegando, DTOPlanejamentoOrcamentario.class);
    }

    private void createItem(PlanoContaGerencial planoContaGerencial, CentroCusto centroCusto, PlanejamentoOrcamentario chegando, IntervaloControleGer intervalo, LinkedList<PlanejamentoOrcamentarioItem> ret) {
        Optional<PlanejamentoOrcamentarioItem> f = chegando.getItens().stream().filter(i -> this.isEquals(i.getPlanoContaGerencial(), planoContaGerencial) && this.isEquals(i.getCentroCusto(), centroCusto)).findFirst();
        if (f.isPresent()) {
            ret.add(f.get());
        } else {
            PlanejamentoOrcamentarioItem plan = new PlanejamentoOrcamentarioItem();
            plan.setCentroCusto(centroCusto);
            plan.setPlanoContaGerencial(planoContaGerencial);
            for (IntervaloControleGerPer inter : intervalo.getIntervalos()) {
                PlanejamentoOrcamentarioItemPer per = this.getPeriodo(inter, plan.getPlanoContaGerencial(), plan.getCentroCusto(), chegando);
                per.setIntervaloControleGerPer(inter);
                per.setPlanejamentoGerencialItem(plan);
                plan.getPeriodos().add(per);
            }
            ret.add(plan);
        }
    }

    public Double getValorOrcado(IntervaloControleGerPer intervaloControleGerPer, PlanoContaGerencial pc, CentroCusto cc) {
        return ((DaoPlanejamentoOrcamentarioImpl)this.getDao()).getValorOrcado(intervaloControleGerPer, pc, cc);
    }

    public Double getValorOrcado(IntervaloControleGerPer intervaloControleGerPer, PlanoContaGerencial pc) {
        return ((DaoPlanejamentoOrcamentarioImpl)this.getDao()).getValorOrcado(intervaloControleGerPer, pc);
    }

    @Override
    public PlanejamentoOrcamentario beforeSave(PlanejamentoOrcamentario aux) {
        aux.setDataUltModificacao(new Date());
        for (PlanejamentoOrcamentarioItem item : aux.getItens()) {
            item.setPlanejamentoOrcamentario(aux);
            for (PlanejamentoOrcamentarioItemPer periodo : item.getPeriodos()) {
                periodo.setPlanejamentoGerencialItem(item);
            }
        }
        return aux;
    }

    public Long validarInconsistenciasAltIntervalo(IntervaloControleGer intervaloControleGer) {
        return ((DaoPlanejamentoOrcamentarioImpl)this.getDao()).validarInconsistenciasAltIntervalo(intervaloControleGer);
    }

    public Long validarInconsistenciasAltPacote(IntervaloControleGer intervaloControleGer) {
        return ((DaoPlanejamentoOrcamentarioImpl)this.getDao()).validarInconsistenciasAltPacote(intervaloControleGer);
    }

    private PlanejamentoOrcamentarioItemPer getPeriodo(IntervaloControleGerPer inter, PlanoContaGerencial planoContaGerencial, CentroCusto centroCusto, PlanejamentoOrcamentario planejamento) {
        if (planejamento == null) {
            return new PlanejamentoOrcamentarioItemPer();
        }
        Optional<PlanejamentoOrcamentarioItem> foundItem = planejamento.getItens().stream().filter(i -> this.isEquals(i.getPlanoContaGerencial(), planoContaGerencial) && this.isEquals(i.getCentroCusto(), centroCusto)).findFirst();
        if (!foundItem.isPresent()) {
            return new PlanejamentoOrcamentarioItemPer();
        }
        Optional<PlanejamentoOrcamentarioItemPer> foundPer = foundItem.get().getPeriodos().stream().filter(i -> this.isEquals(i.getIntervaloControleGerPer(), inter)).findFirst();
        if (foundPer.isPresent()) {
            return foundPer.get();
        }
        return new PlanejamentoOrcamentarioItemPer();
    }

    public PlanejamentoOrcamentario getByPacoteOrcamentario(Long idPacoteOrcamentario, Long intervalo) {
        return ((DaoPlanejamentoOrcamentarioImpl)this.getDao()).getByPacoteOrcamentario(idPacoteOrcamentario, intervalo);
    }
}

