/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.planoconta;

import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.GeracaoContaPessoa;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.planoconta.CompPlanoConta;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCompPlanoConta
extends ServiceGenericImpl {
    @Autowired
    private CompPlanoConta compPlanoConta;

    public PlanoConta getPlanoConta(Cliente cliente, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        PlanoConta pc;
        if (TMethods.isNull((Object)cliente).booleanValue() || TMethods.isNull((Object)cliente.getPessoa()).booleanValue()) {
            return null;
        }
        if (TMethods.isNotNull((Object)cliente.getPessoa().getContasPessoa()).booleanValue() && TMethods.isNotNull((Object)(pc = cliente.getPessoa().getContasPessoa().getPlanoContaAtivo())).booleanValue()) {
            return pc;
        }
        if (this.isAffimative(opcoes.getUsarContabilidade())) {
            GeracaoContaPessoa contas = this.compPlanoConta.gerarPlanoContaCliente(cliente, opcoes);
            cliente.getPessoa().setContasPessoa(contas);
            if (TMethods.isNotNull((Object)contas).booleanValue()) {
                return contas.getPlanoContaAtivo();
            }
        }
        return null;
    }

    public PlanoConta getPlanoContaAntecip(Cliente cliente, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        PlanoConta pc;
        if (TMethods.isNull((Object)cliente).booleanValue() || TMethods.isNull((Object)cliente.getPessoa()).booleanValue()) {
            return null;
        }
        if (TMethods.isNotNull((Object)cliente.getPessoa().getContasPessoa()).booleanValue() && TMethods.isNotNull((Object)(pc = cliente.getPessoa().getContasPessoa().getPlanoContaAntecAtivo())).booleanValue()) {
            return pc;
        }
        if (this.isAffimative(opcoes.getUsarContabilidade())) {
            GeracaoContaPessoa contas = this.compPlanoConta.gerarPlanoContaClienteAntecip(cliente, opcoes);
            cliente.getPessoa().setContasPessoa(contas);
            if (TMethods.isNotNull((Object)contas).booleanValue()) {
                return contas.getPlanoContaAntecAtivo();
            }
        }
        return null;
    }

    public PlanoConta getPlanoConta(Cliente cliente) {
        if (TMethods.isNull((Object)cliente).booleanValue() || TMethods.isNull((Object)cliente.getPessoa()).booleanValue() || TMethods.isNull((Object)cliente.getPessoa().getContasPessoa()).booleanValue()) {
            return null;
        }
        return cliente.getPessoa().getContasPessoa().getPlanoContaAtivo();
    }

    public PlanoConta getPlanoContaAntecAtivo(Cliente cliente) {
        if (TMethods.isNull((Object)cliente).booleanValue() || TMethods.isNull((Object)cliente.getPessoa()).booleanValue() || TMethods.isNull((Object)cliente.getPessoa().getContasPessoa()).booleanValue()) {
            return null;
        }
        return cliente.getPessoa().getContasPessoa().getPlanoContaAntecAtivo();
    }

    public PlanoConta getPlanoConta(Fornecedor fornecedor, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        PlanoConta pc;
        if (TMethods.isNull((Object)fornecedor).booleanValue() || TMethods.isNull((Object)fornecedor.getPessoa()).booleanValue()) {
            return null;
        }
        if (TMethods.isNotNull((Object)fornecedor.getPessoa().getContasPessoa()).booleanValue() && TMethods.isNotNull((Object)(pc = fornecedor.getPessoa().getContasPessoa().getPlanoContaPassivo())).booleanValue()) {
            return pc;
        }
        if (this.isAffimative(opcoes.getUsarContabilidade())) {
            GeracaoContaPessoa contas = this.compPlanoConta.gerarPlanoContaFornecedor(fornecedor, opcoes);
            fornecedor.getPessoa().setContasPessoa(contas);
            if (TMethods.isNotNull((Object)contas).booleanValue()) {
                return contas.getPlanoContaPassivo();
            }
        }
        return null;
    }

    public PlanoConta getPlanoContaAntecip(Fornecedor fornecedor, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        PlanoConta pc;
        if (TMethods.isNull((Object)fornecedor).booleanValue() || TMethods.isNull((Object)fornecedor.getPessoa()).booleanValue()) {
            return null;
        }
        if (TMethods.isNotNull((Object)fornecedor.getPessoa().getContasPessoa()).booleanValue() && TMethods.isNotNull((Object)(pc = fornecedor.getPessoa().getContasPessoa().getPlanoContaAntecPassivo())).booleanValue()) {
            return pc;
        }
        if (this.isAffimative(opcoes.getUsarContabilidade())) {
            GeracaoContaPessoa contas = this.compPlanoConta.gerarPlanoContaFornecedorAntecip(fornecedor, opcoes);
            fornecedor.getPessoa().setContasPessoa(contas);
            if (TMethods.isNotNull((Object)contas).booleanValue()) {
                return contas.getPlanoContaAntecPassivo();
            }
        }
        return null;
    }

    public PlanoConta getPlanoConta(Fornecedor fornecedor) {
        if (TMethods.isNull((Object)fornecedor).booleanValue() || TMethods.isNull((Object)fornecedor.getPessoa()).booleanValue() || TMethods.isNull((Object)fornecedor.getPessoa().getContasPessoa()).booleanValue()) {
            return null;
        }
        return fornecedor.getPessoa().getContasPessoa().getPlanoContaPassivo();
    }

    public PlanoConta getPlanoContaAntecAtivo(Fornecedor fornecedor) {
        if (TMethods.isNull((Object)fornecedor).booleanValue() || TMethods.isNull((Object)fornecedor.getPessoa()).booleanValue() || TMethods.isNull((Object)fornecedor.getPessoa().getContasPessoa()).booleanValue()) {
            return null;
        }
        return fornecedor.getPessoa().getContasPessoa().getPlanoContaAntecPassivo();
    }

    public PlanoConta getPlanoConta(Representante representante, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        PlanoConta pc;
        if (TMethods.isNull((Object)representante).booleanValue() || TMethods.isNull((Object)representante.getPessoa()).booleanValue()) {
            return null;
        }
        if (TMethods.isNotNull((Object)representante.getPessoa().getContasPessoa()).booleanValue() && TMethods.isNotNull((Object)(pc = representante.getPessoa().getContasPessoa().getPlanoContaPassivo())).booleanValue()) {
            return pc;
        }
        if (this.isAffimative(opcoes.getUsarContabilidade())) {
            GeracaoContaPessoa contas = this.compPlanoConta.gerarPlanoContaRepresentante(representante, opcoes);
            representante.getPessoa().setContasPessoa(contas);
            if (TMethods.isNotNull((Object)contas).booleanValue()) {
                return contas.getPlanoContaPassivo();
            }
        }
        return null;
    }

    public PlanoConta getPlanoConta(Representante representante) {
        if (TMethods.isNull((Object)representante).booleanValue() || TMethods.isNull((Object)representante.getPessoa()).booleanValue() || TMethods.isNull((Object)representante.getPessoa().getContasPessoa()).booleanValue()) {
            return null;
        }
        return representante.getPessoa().getContasPessoa().getPlanoContaPassivo();
    }
}

