/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.planoconta;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.DeParaNaturezaOpPC;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaContabilSped;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDadosRuntime;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoPlanoContaImpl;
import com.touchcomp.basementorservice.helpers.impl.planoconta.HelperPlanoConta;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.deparanaturezaoppc.ServiceDeParaNaturezaOpPC;
import com.touchcomp.basementorservice.service.impl.planoconta.UtilGeraPlanoConta;
import com.touchcomp.basementorservice.service.interfaces.ServicePlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.planoconta.DTOPlanoContaRes;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServicePlanoContaImpl
extends ServiceGenericEntityImpl<PlanoConta, Long, DaoPlanoContaImpl>
implements ServicePlanoConta {
    @Autowired
    private ServiceDeParaNaturezaOpPC serviceNaturezaOperacaPCImpl;
    @Autowired
    HelperPlanoConta helperPlanoConta;

    @Autowired
    public ServicePlanoContaImpl(DaoPlanoContaImpl genericDao) {
        super(genericDao);
    }

    @Override
    public PlanoConta beforeSaveEntity(PlanoConta vo) {
        if (vo.getPlanoContaContabilSped() != null) {
            vo.getPlanoContaContabilSped().forEach(i -> i.setPlanoConta(vo));
        }
        vo.setCodigo(ToolString.completaZeros((String)vo.getCodigo(), (int)10));
        if (this.isEquals(vo.getMarca(), EnumConstSinteticoAnalitico.SINTETICO.getValueInt())) {
            vo.setReduzida("00000");
            vo.setSeq("00000");
        }
        if (!TMethods.isStrWithData((String)vo.getReduzida())) {
            String reduzida = this.findNextReduzida(vo.getCodigo());
            vo.setReduzida(reduzida);
        }
        if (!TMethods.isStrWithData((String)vo.getSeq())) {
            String sequencia = this.findNextSequencial(vo.getCodigo());
            vo.setSeq(sequencia);
        }
        return vo;
    }

    @Override
    public PlanoConta findByCodigo(String codigo) {
        System.out.println("CODIGO:" + codigo);
        return ((DaoPlanoContaImpl)this.getGenericDao()).findByCodigo(codigo);
    }

    public DTOPlanoContaRes findByCodigoDTO(String codigo) {
        PlanoConta vo = this.findByCodigo(codigo);
        if (vo == null) {
            return null;
        }
        return this.buildToDTO(vo, DTOPlanoContaRes.class);
    }

    @Override
    public PlanoConta getNewPlanoConta(PlanoConta planoConta, String nome, String cnpj, OpcoesContabeis opcoesContabeis) throws ExceptionObjectNotFound {
        DaoPlanoContaImpl daoPlanoConta = (DaoPlanoContaImpl)ConfApplicationContext.getBean(DaoPlanoContaImpl.class);
        return new UtilGeraPlanoConta(daoPlanoConta.getSession()).gerarNovoPlanoConta(planoConta, cnpj, nome, opcoesContabeis);
    }

    public PlanoConta getNewPlanoConta(PlanoConta planoContaSintetico, String descricao, OpcoesContabeis opcoesContabeis) {
        if (!((HelperPlanoConta)Context.get(HelperPlanoConta.class)).isSintetica(planoContaSintetico)) {
            throw new ExceptionValidacaoDadosRuntime(new ExcepCodeDetail("E.ERP.0160.001", new Object[]{planoContaSintetico}));
        }
        if (!planoContaSintetico.getCodigo().endsWith("00000")) {
            throw new ExceptionValidacaoDadosRuntime(new ExcepCodeDetail("E.ERP.0160.001", new Object[]{planoContaSintetico}));
        }
        String codigo = ((DaoPlanoContaImpl)this.getGenericDao()).getNextCodigoConta(planoContaSintetico.getCodigo());
        String reduzida = ((DaoPlanoContaImpl)this.getGenericDao()).findNextReduzida(codigo);
        String sequencial = ((DaoPlanoContaImpl)this.getGenericDao()).findNextSequencial(codigo);
        PlanoConta pc = new PlanoConta();
        pc.setMarca(Integer.valueOf(EnumConstSinteticoAnalitico.ANALITICO.getValueInt()));
        pc.setReduzida(reduzida);
        pc.setSeq(sequencial);
        pc.setCodigo(codigo);
        pc.setDescricao(descricao);
        pc.setEmpresa(opcoesContabeis.getEmpresa());
        pc.setDataCadastro(new Date());
        DeParaNaturezaOpPC d = this.serviceNaturezaOperacaPCImpl.getDeParaNaturezaOpPC(codigo);
        if (d == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0160.002", new String[]{codigo}));
        }
        pc.setNaturezaOperacaoPC(d.getNaturezaOperacaoPC());
        PlanoContaContabilSped ps = new PlanoContaContabilSped();
        ps.setPlanoConta(pc);
        ps.setPlanoContaSped(d.getPlanoContaSped());
        pc.getPlanoContaContabilSped().add(ps);
        return pc;
    }

    @Override
    public List<PlanoConta> findContasAnaliticaResultado() {
        return ((DaoPlanoContaImpl)this.getDao()).findContasAnaliticaResultado();
    }

    public PlanoConta getGrupoPlanoContaByCodigo(String codigo) {
        String grupoConta = ToolString.subString((String)codigo, (int)5);
        grupoConta = ToolString.completaZeros((String)grupoConta, (int)10);
        PlanoConta grupo = this.findByCodigo(grupoConta);
        return grupo;
    }

    public DTOPlanoContaRes getGrupoPlanoContaByCodigoDTO(String codigo) {
        PlanoConta pc = this.getGrupoPlanoContaByCodigo(codigo);
        if (pc == null) {
            return null;
        }
        return this.buildToDTO(pc, DTOPlanoContaRes.class);
    }

    public String findNextSequencial(String grupo) {
        String sequencia = ((DaoPlanoContaImpl)this.getGenericDao()).findNextSequencial(grupo);
        if (sequencia == null) {
            sequencia = TString.completaZerosEsquerda((String)"", (int)10);
        }
        String strReduz = sequencia.substring(5, 10);
        Long lastSeq = Long.valueOf(strReduz);
        if ((lastSeq = Long.valueOf(lastSeq + 1L)) >= 99999L) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0160.006"));
        }
        return ToolString.completaZeros((String)String.valueOf(lastSeq), (int)5, (boolean)true);
    }

    public String findNextReduzida(String grupo) {
        grupo = ToolString.subString((String)grupo, (int)5);
        String reduzida = ((DaoPlanoContaImpl)this.getGenericDao()).findNextReduzida(grupo);
        if (!TMethods.isStrWithData((String)reduzida)) {
            reduzida = "0";
        }
        Long lastSeq = Long.valueOf(reduzida);
        lastSeq = lastSeq + 1L;
        return ToolString.completaZeros((String)String.valueOf(lastSeq), (int)5, (boolean)true);
    }

    public List<PlanoConta> findContasSinteticasNivel1() {
        return ((DaoPlanoContaImpl)this.getGenericDao()).findContasSinteticasNivel1();
    }

    public List<PlanoConta> findContasSinteticasNivel2(String codigo) {
        return ((DaoPlanoContaImpl)this.getGenericDao()).findContasSinteticasNivel2(ToolString.subString((String)codigo, (int)1));
    }

    public List<PlanoConta> findContasSinteticasNivel3(String codigo) {
        return ((DaoPlanoContaImpl)this.getGenericDao()).findContasSinteticasNivel3(ToolString.subString((String)codigo, (int)2));
    }

    public List<PlanoConta> findContasSinteticasNivel4(String codigo) {
        return ((DaoPlanoContaImpl)this.getGenericDao()).findContasSinteticasNivel4(ToolString.subString((String)codigo, (int)3));
    }

    public List<PlanoConta> findContasSinteticasNivel5(String codigo) {
        return ((DaoPlanoContaImpl)this.getGenericDao()).findContasSinteticasNivel5(ToolString.subString((String)codigo, (int)4));
    }

    public List<DTOPlanoContaRes> findContasAnaliticasGrupoDTO(String codigo) {
        return this.buildToDTO(((DaoPlanoContaImpl)this.getGenericDao()).findContasAnaliticasGrupo(this.helperPlanoConta.getGrupoCodigo(codigo)), DTOPlanoContaRes.class);
    }

    public boolean verificarSintetica(String grupo) {
        if (grupo == null) {
            return false;
        }
        char[] grupoArray = grupo.toCharArray();
        Object teste = "";
        teste = (String)teste + grupoArray[0];
        if (grupoArray[0] == '0') {
            return false;
        }
        if (grupoArray[1] == '0' && grupoArray[2] == '0' && grupoArray[3] == '0' && grupoArray[4] == '0') {
            return true;
        }
        if (grupoArray[2] == '0' && grupoArray[1] != '0' && grupoArray[3] == '0' && grupoArray[4] == '0') {
            return this.findByCodigo(ToolString.completaZeros((String)teste, (int)5)) == null;
        }
        teste = (String)teste + grupoArray[1];
        if (grupoArray[3] == '0' && grupoArray[4] == '0' && grupoArray[1] != '0') {
            return this.findByCodigo(ToolString.completaZeros((String)teste, (int)5)) == null;
        }
        teste = (String)teste + grupoArray[2];
        if (grupoArray[1] != '0' && grupoArray[2] != '0') {
            return this.findByCodigo(ToolString.completaZeros((String)teste, (int)5)) == null;
        }
        return false;
    }

    public Boolean verificarAnalitica(String grupo) {
        char[] grupoArray = grupo.toCharArray();
        if (grupoArray.length < 5) {
            return false;
        }
        if (grupoArray[0] == '0') {
            return false;
        }
        if (grupoArray[1] == '0') {
            return false;
        }
        if (grupoArray[2] == '0') {
            return false;
        }
        if (grupoArray[3] == '0' && grupoArray[4] == '0') {
            return false;
        }
        return true;
    }

    public List<PlanoConta> findContasReduzidas(String reduzida) {
        return ((DaoPlanoContaImpl)this.getGenericDao()).findContasReduzidas(reduzida);
    }
}

