/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.planoconta;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.DeParaNaturezaOpPC;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaContabilSped;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoNaturezaOperacaPCImpl;
import com.touchcomp.basementorservice.dao.impl.DaoPlanoContaImpl;
import com.touchcomp.basementorservice.helpers.impl.planoconta.HelperPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

class UtilGeraPlanoConta {
    private DaoPlanoContaImpl daoPlanoConta = (DaoPlanoContaImpl)ConfApplicationContext.getBean(DaoPlanoContaImpl.class);
    private DaoNaturezaOperacaPCImpl daoNaturezaOperacaoPC = (DaoNaturezaOperacaPCImpl)ConfApplicationContext.getBean(DaoNaturezaOperacaPCImpl.class);
    private Session session;

    public UtilGeraPlanoConta(Session session) {
        this.session = session;
    }

    public PlanoConta gerarNovoPlanoConta(PlanoConta planoConta, String cnpj, String descricaoConta, OpcoesContabeis opcoesContabeis) throws ExceptionObjectNotFound {
        PlanoConta pc;
        if (cnpj == null) {
            return null;
        }
        if (((HelperPlanoConta)Context.get(HelperPlanoConta.class)).isAnalitica(planoConta)) {
            return planoConta;
        }
        if (cnpj.length() > 8) {
            cnpj = cnpj.substring(0, 8);
        }
        if ((pc = this.getPlanoContaClientes(planoConta.getCodigo(), cnpj, opcoesContabeis)) == null) {
            pc = this.gerarPlanoConta(planoConta.getCodigo(), descricaoConta, opcoesContabeis);
        }
        return pc;
    }

    private PlanoConta gerarPlanoConta(String codigoPlanoConta, String descricaoConta, OpcoesContabeis opcoesContabeis) throws ExceptionObjectNotFound {
        String codigo = this.daoPlanoConta.getNextCodigoConta(codigoPlanoConta);
        PlanoConta planoConta = new PlanoConta();
        String reduzida = this.daoPlanoConta.findNextReduzida(codigoPlanoConta);
        String sequencial = this.daoPlanoConta.findNextSequencial(codigoPlanoConta);
        planoConta.setMarca(Integer.valueOf(EnumConstSinteticoAnalitico.ANALITICO.getValueInt()));
        planoConta.setReduzida(reduzida);
        planoConta.setSeq(sequencial);
        planoConta.setCodigo(codigo.toString());
        planoConta.setDescricao(descricaoConta);
        planoConta.setEmpresa(opcoesContabeis.getEmpresa());
        planoConta.setDataCadastro(new Date());
        codigoPlanoConta = codigoPlanoConta.substring(0, 5);
        DeParaNaturezaOpPC d = this.getNaturezaOperacaoPC(codigoPlanoConta);
        if (d != null) {
            planoConta.setNaturezaOperacaoPC(d.getNaturezaOperacaoPC());
            PlanoContaContabilSped ps = new PlanoContaContabilSped();
            ps.setPlanoConta(planoConta);
            ps.setPlanoContaSped(d.getPlanoContaSped());
            planoConta.getPlanoContaContabilSped().add(ps);
        }
        return planoConta;
    }

    private PlanoConta findPlanoContaExistenteCliente(String cnpj) {
        cnpj = (String)cnpj + "%";
        String hql = "select gcc.planoContaAtivo from GeracaoContaPessoa gcc inner join Pessoa pes on pes = gcc.pessoa inner join Cliente cli on cli.pessoa = pes where pes.complemento.cnpj like :cnpj";
        Query q = this.session.createQuery(hql);
        q.setText("cnpj", (String)cnpj);
        q.setMaxResults(1);
        return (PlanoConta)q.uniqueResult();
    }

    private PlanoConta findPlanoContaExistenteFornecedor(String cnpj) {
        cnpj = (String)cnpj + "%";
        String hql = "select gcc.planoContaPassivo from GeracaoContaPessoa gcc inner join Pessoa pes on pes = gcc.pessoa inner join Fornecedor fo on fo.pessoa = pes where pes.complemento.cnpj like :cnpj";
        Query q = this.session.createQuery(hql);
        q.setText("cnpj", (String)cnpj);
        q.setMaxResults(1);
        return (PlanoConta)q.uniqueResult();
    }

    private PlanoConta findPlanoContaExistenteInstFinanceira(String cnpj) {
        cnpj = (String)cnpj + "%";
        String hql = "select if.planoConta  from ContaValores if where if.agenciaValor.pessoa.complemento.cnpj like :cnpj ";
        Query q = this.session.createQuery(hql);
        q.setText("cnpj", (String)cnpj);
        q.setMaxResults(1);
        return (PlanoConta)q.uniqueResult();
    }

    public PlanoConta findPlanoContaExistenteRepresentante(String cnpj) {
        cnpj = (String)cnpj + "%";
        String hql = "select gcc.planoContaPassivo from GeracaoContaPessoa gcc inner join Pessoa pes on pes = gcc.pessoa inner join Representante rep on rep.pessoa = pes where pes.complemento.cnpj like :cnpj";
        Query q = this.session.createQuery(hql);
        q.setText("cnpj", (String)cnpj);
        q.setMaxResults(1);
        return (PlanoConta)q.uniqueResult();
    }

    public PlanoConta findPlanoContaExistenteTransportador(String cnpj) {
        cnpj = (String)cnpj + "%";
        String hql = "select t.planoConta  from Transportador t where t.pessoa.complemento.cnpj like :cnpj ";
        Query q = this.session.createQuery(hql);
        q.setText("cnpj", (String)cnpj);
        q.setMaxResults(1);
        return (PlanoConta)q.uniqueResult();
    }

    public PlanoConta findPlanoContaExistenteAdiantamentoFornecedor(String cnpj, String contaSintetica) {
        String q = "SELECT PC.ID_PLANO_CONTA  FROM FORNECEDOR      F  JOIN PESSOA       P ON P.ID_PESSOA       = F.ID_PESSOA  JOIN GERACAO_CONTA_PESSOA       gcp ON P.ID_PESSOA       = gcp.ID_PESSOA  JOIN PLANO_CONTA PC ON gcp.ID_PC_ANTEC_PASSIVO = PC.ID_PLANO_CONTA  JOIN COMPLEMENTO CO ON CO.ID_COMPLEMENTO = P.ID_COMPLEMENTO  WHERE       RPAD(SUBSTRING (PC.CODIGO FROM 1 FOR 5), 10, '0') = :CONTA_SINTETICA  AND CO.CNPJ LIKE :CNPJ_FORNECEDOR";
        NativeQuery query = this.session.createSQLQuery(q);
        query.setString("CNPJ_FORNECEDOR", cnpj + "%");
        query.setString("CONTA_SINTETICA", contaSintetica);
        query.setMaxResults(1);
        Number idPlanoConta = (Number)query.uniqueResult();
        if (idPlanoConta != null) {
            PlanoConta planoConta = (PlanoConta)this.daoPlanoConta.get(idPlanoConta.longValue());
            return planoConta;
        }
        return null;
    }

    public PlanoConta findPlanoContaExistenteAdiantamentoCliente(String cnpj, String contaSintetica) {
        String q = "SELECT PC.ID_PLANO_CONTA  FROM CLIENTE      C  JOIN PESSOA       P ON P.ID_PESSOA       = C.ID_PESSOA  JOIN GERACAO_CONTA_PESSOA       gcp ON P.ID_PESSOA       = gcp.ID_PESSOA  JOIN PLANO_CONTA PC ON gcp.ID_PC_ANTEC_ATIVO = PC.ID_PLANO_CONTA  JOIN COMPLEMENTO CO ON CO.ID_COMPLEMENTO = P.ID_COMPLEMENTO  WHERE       RPAD(SUBSTRING (PC.CODIGO FROM 1 FOR 5), 10, '0') = :CONTA_SINTETICA  AND CO.CNPJ LIKE :CNPJ_CLIENTE";
        NativeQuery query = this.session.createSQLQuery(q);
        query.setString("CNPJ_CLIENTE", cnpj + "%");
        query.setString("CONTA_SINTETICA", contaSintetica);
        query.setMaxResults(1);
        Number idPlanoConta = (Number)query.uniqueResult();
        if (idPlanoConta != null) {
            PlanoConta planoConta = (PlanoConta)this.daoPlanoConta.get(idPlanoConta.longValue());
            return planoConta;
        }
        return null;
    }

    private PlanoConta getPlanoContaClientes(String aux, String cnpj, OpcoesContabeis opcoesContabeis) {
        PlanoConta planoConta = null;
        if (planoConta == null && (planoConta = this.findPlanoContaExistenteCliente(cnpj)) != null && opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaCliente() != null && aux.equals(opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaCliente().getCodigo())) {
            return planoConta;
        }
        planoConta = null;
        if (planoConta == null && (planoConta = this.findPlanoContaExistenteFornecedor(cnpj)) != null && opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaFornecedor() != null && aux.equals(opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaFornecedor().getCodigo())) {
            return planoConta;
        }
        planoConta = null;
        if (planoConta == null && (planoConta = this.findPlanoContaExistenteInstFinanceira(cnpj)) != null && opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaInstFinanceira() != null && aux.equals(opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaInstFinanceira().getCodigo())) {
            return planoConta;
        }
        planoConta = null;
        if (planoConta == null && (planoConta = this.findPlanoContaExistenteRepresentante(cnpj)) != null && opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaRepresentante() != null && aux.equals(opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaRepresentante().getCodigo())) {
            return planoConta;
        }
        planoConta = null;
        if (planoConta == null && (planoConta = this.findPlanoContaExistenteTransportador(cnpj)) != null && opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaTransportador() != null && aux.equals(opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaTransportador().getCodigo())) {
            return planoConta;
        }
        planoConta = null;
        if (planoConta == null && (planoConta = this.findPlanoContaExistenteAdiantamentoFornecedor(cnpj, aux)) != null && opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoAntecipFornecedor() != null && aux.equals(opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoAntecipFornecedor().getCodigo())) {
            return planoConta;
        }
        planoConta = null;
        if (planoConta == null && (planoConta = this.findPlanoContaExistenteAdiantamentoCliente(cnpj, aux)) != null && opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoAntecipCliente() != null && aux.equals(opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoAntecipCliente().getCodigo())) {
            return planoConta;
        }
        return planoConta;
    }

    private DeParaNaturezaOpPC getNaturezaOperacaoPC(String codigoPlanoConta) {
        StringBuilder sb = new StringBuilder(codigoPlanoConta);
        for (int i = 0; i < sb.length(); ++i) {
            String aux = sb.substring(0, sb.length() - i);
            List<DeParaNaturezaOpPC> naturezas = this.daoNaturezaOperacaoPC.findNaturezaOperacaoPC(aux);
            if (!ToolMethods.isWithData(naturezas)) continue;
            if (naturezas.size() == 1) {
                return naturezas.getFirst();
            }
            return null;
        }
        return null;
    }
}

