/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.planocontagerencial;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementorexceptions.exceptions.impl.database.ExceptionDatabase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.dao.impl.DaoPlanoContaGerencialImpl;
import com.touchcomp.basementorservice.helpers.impl.planoconta.HelperPlanoContaGerencial;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.interfaces.ServicePlanoContaGerencial;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.planocontagerencial.web.DTOPlanoContaGerencial;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServicePlanoContaGerencialImpl
extends ServiceGenericEntityImpl<PlanoContaGerencial, Long, DaoPlanoContaGerencialImpl>
implements ServicePlanoContaGerencial {
    @Autowired
    public ServicePlanoContaGerencialImpl(DaoPlanoContaGerencialImpl genericDao) {
        super(genericDao);
    }

    @Override
    public PlanoContaGerencial findByCodigo(String codigo) {
        return ((DaoPlanoContaGerencialImpl)this.getGenericDao()).findByCodigo(codigo);
    }

    @Override
    public PlanoContaGerencial findByGrupo(String grupo) throws ExceptionDatabase {
        if (!TMethods.isStrWithData((String)grupo) || grupo.length() < 1) {
            return null;
        }
        grupo = ToolString.onlyNumbers((String)grupo);
        grupo = ToolString.completaZeros((String)grupo, (int)15);
        List<PlanoContaGerencial> list = ((DaoPlanoContaGerencialImpl)this.getGenericDao()).findByGrupo(grupo);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DTOPlanoContaGerencial getContaGerencial(DTOPlanoContaGerencial dto) throws ExceptionInvalidData, ExceptionValidacaoDados {
        HelperPlanoContaGerencial helper = (HelperPlanoContaGerencial)ConfApplicationContext.getBean(HelperPlanoContaGerencial.class);
        String grupo = helper.clearCodigoConta(dto.getCodigoGrupo());
        if (TMethods.isEquals((Object)dto.getMarca(), (Object)EnumConstSinteticoAnalitico.ANALITICO.getValueInt())) {
            if (!helper.validContaAnalitica(grupo) || this.findByGrupo(grupo) == null) {
                throw new ExceptionValidacaoDados("E.ERP.0164.003", new Object[0]);
            }
            String gerencial = this.findNextGerencialAnalitica(grupo);
            String aux = gerencial.substring(10, 15);
            if (Long.parseLong(aux) < 99999L) {
                dto.setCodigoConta(gerencial);
                dto.setCodigo(gerencial);
                PlanoContaGerencial voGrupo = this.findByGrupo(grupo);
                if (voGrupo != null) {
                    dto.setDescricaoGrupo(voGrupo.getDescricao());
                }
                return dto;
            }
            throw new ExceptionValidacaoDados("E.ERP.0164.004", new Object[0]);
        }
        if (TMethods.isEquals((Object)dto.getMarca(), (Object)EnumConstSinteticoAnalitico.SINTETICO.getValueInt())) {
            if (this.findByGrupo(grupo) != null) {
                throw new ExceptionValidacaoDados("E.ERP.0164.002", new Object[0]);
            }
            if (!helper.validContaSintetica(grupo, dto)) {
                throw new ExceptionValidacaoDados("E.ERP.0164.005", new Object[0]);
            }
            if (TMethods.isStrWithData((String)grupo)) {
                dto.setCodigoConta(helper.getContaGerencialSintetica(grupo));
                dto.setCodigo(dto.getCodigoConta());
                return dto;
            }
            throw new ExceptionValidacaoDados("E.ERP.0164.006", new Object[0]);
        }
        throw new ExceptionInvalidData("E.ERP.0164.007", new Object[0]);
    }

    @Override
    public String findNextGerencialAnalitica(String grupo) {
        Object lastCode = ((DaoPlanoContaGerencialImpl)this.getGenericDao()).findNextGerencialAnalitica(grupo);
        if (lastCode == null) {
            return "00001";
        }
        Long lLastCode = Long.valueOf(((String)lastCode).trim());
        lastCode = String.valueOf(lLastCode = Long.valueOf(lLastCode + 1L));
        if (((String)lastCode).length() == 14) {
            lastCode = "0" + (String)lastCode;
        }
        return lastCode;
    }

    public void beforeGet(DTOPlanoContaGerencial dto) {
        String grupo = dto.getCodigo().substring(0, 10);
        PlanoContaGerencial voGrupo = this.findByGrupo(grupo);
        if (voGrupo != null) {
            dto.setDescricaoGrupo(voGrupo.getDescricao());
        }
    }

    public void deleteAll() {
        ((DaoPlanoContaGerencialImpl)this.getDao()).deleteAll();
    }
}

