/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.planocontaimpostofolha;

import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.ItemParamFolhaImpostoTipoFolha;
import com.touchcomp.basementor.model.vo.ItemParamImpostoFolhaCentroCusto;
import com.touchcomp.basementor.model.vo.PlanoContaImpostoFolha;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoPlanoContaImpostoFolhaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.centrocusto.ServiceCentroCustoImpl;
import com.touchcomp.basementorservice.service.impl.tipocalculo.ServiceTipoCalculoImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServicePlanoContaImpostoFolhaImpl
extends ServiceGenericEntityImpl<PlanoContaImpostoFolha, Long, DaoPlanoContaImpostoFolhaImpl> {
    ServiceCentroCustoImpl serviceCentroCusto;
    ServiceTipoCalculoImpl serviceTipoCalculo;

    @Autowired
    public ServicePlanoContaImpostoFolhaImpl(DaoPlanoContaImpostoFolhaImpl dao, ServiceCentroCustoImpl serviceCentroCusto, ServiceTipoCalculoImpl serviceTipoCalculo) {
        super(dao);
        this.serviceCentroCusto = serviceCentroCusto;
        this.serviceTipoCalculo = serviceTipoCalculo;
    }

    public ItemParamImpostoFolhaCentroCusto newItemCentroCusto(Long id) {
        CentroCusto e = (CentroCusto)this.serviceCentroCusto.get(id);
        if (this.isNull(e).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0058.003", new Object[]{id}));
        }
        ItemParamImpostoFolhaCentroCusto i = new ItemParamImpostoFolhaCentroCusto(e);
        return i;
    }

    public ItemParamFolhaImpostoTipoFolha newItemTipoFolha(Long id) {
        TipoCalculo e = (TipoCalculo)this.serviceTipoCalculo.get(id);
        if (this.isNull(e).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0058.003", new Object[]{id}));
        }
        ItemParamFolhaImpostoTipoFolha i = new ItemParamFolhaImpostoTipoFolha();
        i.setTipoFolha(e);
        return i;
    }

    public List<ItemParamImpostoFolhaCentroCusto> getCentroCustosColaborador() {
        ArrayList<ItemParamImpostoFolhaCentroCusto> list = new ArrayList<ItemParamImpostoFolhaCentroCusto>();
        List<CentroCusto> centroCustoList = this.serviceCentroCusto.findCentroCustoColaborador();
        centroCustoList.forEach(c -> list.add(new ItemParamImpostoFolhaCentroCusto(c)));
        return list;
    }

    public List<PlanoContaImpostoFolha> findPlanoContaImpostoIrrf(CentroCusto centroCusto, TipoCalculo tipoCalculo) {
        return ((DaoPlanoContaImpostoFolhaImpl)this.getGenericDao()).getPlanoContaImpostoIrrf(centroCusto, tipoCalculo);
    }

    public List<PlanoContaImpostoFolha> getPlanoContaImpostoProvisao(CentroCusto centroCusto) {
        return ((DaoPlanoContaImpostoFolhaImpl)this.getGenericDao()).getPlanoContaImpostoProvisao(centroCusto);
    }

    public List<PlanoContaImpostoFolha> getPlanoContaContabilInssEmpresa(CentroCusto centroCusto, TipoCalculo tipoCalculo) {
        return ((DaoPlanoContaImpostoFolhaImpl)this.getGenericDao()).getPlanoContaContabilInssEmpresa(centroCusto, tipoCalculo);
    }

    public List<PlanoContaImpostoFolha> getPlanoContaImpostoPorCentroCusto(CentroCusto centroCusto, TipoCalculo tipoCalculo) {
        return ((DaoPlanoContaImpostoFolhaImpl)this.getGenericDao()).getPlanoContaImpostoPorCentroCusto(centroCusto, tipoCalculo);
    }

    @Override
    public PlanoContaImpostoFolha beforeSave(PlanoContaImpostoFolha aux) {
        aux.getItensCentroCusto().forEach(cc -> cc.setPlanoImpostoFolha(aux));
        aux.getItensTipoFolha().forEach(tp -> tp.setPlanoImposto(aux));
        return aux;
    }
}

