/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.planomanutencaoativo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.model.vo.AtivoDataUltimaManutencao;
import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.OpcoesManutencEquip;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.PreProcedimento;
import com.touchcomp.basementor.model.vo.PreProdutoPrevManutencao;
import com.touchcomp.basementor.model.vo.PreServicoProcedimento;
import com.touchcomp.basementor.model.vo.SetorExecutanteServicos;
import com.touchcomp.basementorservice.dao.impl.DaoPlanoManutencaoAtivoImpl;
import com.touchcomp.basementorservice.helpers.impl.coleta.HelperColeta;
import com.touchcomp.basementorservice.helpers.impl.ordemservico.HelperCronogramaOrdemServico;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.diagnosticoosativo.ServiceDiagnosticoOSAtivoImpl;
import com.touchcomp.basementorservice.service.impl.fechamentoordemservico.ServiceFechamentoOrdemServicoImpl;
import com.touchcomp.basementorservice.service.impl.ordemservico.ServiceOrdemServicoImpl;
import com.touchcomp.basementorservice.service.impl.planomanutencaoativo.AuxGeraOSPlanoManutencao;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServicePlanoManutencaoAtivoImpl
extends ServiceGenericEntityImpl<PlanoManutencaoAtivo, Long, DaoPlanoManutencaoAtivoImpl> {
    private final HelperColeta helperColeta;
    private final ServiceOrdemServicoImpl serviceOrdemServico;
    private final ServiceFechamentoOrdemServicoImpl serviceFechamentoOrdemServico;
    private final ServiceDiagnosticoOSAtivoImpl serviceDiagnosticoOSAtivoImpl;
    private final HelperCronogramaOrdemServico helperCronogramaOrdemServico;

    public ServicePlanoManutencaoAtivoImpl(HelperColeta helperColeta, ServiceOrdemServicoImpl serviceOrdemServico, ServiceFechamentoOrdemServicoImpl serviceFechamentoOrdemServico, ServiceDiagnosticoOSAtivoImpl serviceDiagnosticoOSAtivoImpl, HelperCronogramaOrdemServico helperCronogramaOrdemServico, DaoPlanoManutencaoAtivoImpl genericDao) {
        super(genericDao);
        this.helperColeta = helperColeta;
        this.serviceOrdemServico = serviceOrdemServico;
        this.serviceFechamentoOrdemServico = serviceFechamentoOrdemServico;
        this.serviceDiagnosticoOSAtivoImpl = serviceDiagnosticoOSAtivoImpl;
        this.helperCronogramaOrdemServico = helperCronogramaOrdemServico;
    }

    @Override
    public PlanoManutencaoAtivo beforeSave(PlanoManutencaoAtivo vo) {
        for (AtivoDataUltimaManutencao a : vo.getAtivos()) {
            a.setPlanoManutencaoAtivo(vo);
        }
        for (SetorExecutanteServicos s : vo.getSetorExecutantesServicos()) {
            s.setPlanoManutencaoAtivo(vo);
            for (PreServicoProcedimento p : s.getPreServicoProcedimentos()) {
                p.setSetorExecutanteServicos(s);
                for (PreProcedimento pp : p.getPreProcedimento()) {
                    pp.setPreServicoProcedimento(p);
                    for (PreProdutoPrevManutencao preMan : pp.getPreProdutosPrevisaoManutencao()) {
                        preMan.setPreProcedimento(pp);
                    }
                }
            }
        }
        return vo;
    }

    public Timestamp getUltimaDataManutencao(PlanoManutencaoAtivo planoManutencaoAtivo, Equipamento ativo, Short opcaoPesquisa, Empresa empresa) {
        return ((DaoPlanoManutencaoAtivoImpl)this.getGenericDao()).getUltimaDataManutencao(planoManutencaoAtivo, ativo, empresa, opcaoPesquisa);
    }

    public List<PlanoManutencaoAtivo> getPlanosVinculadosColeta(List<Coleta> coletas) {
        ArrayList<PlanoManutencaoAtivo> planos = new ArrayList<PlanoManutencaoAtivo>();
        for (Coleta coleta : coletas) {
            planos.addAll(((DaoPlanoManutencaoAtivoImpl)this.getDao()).findPlanoManutencaoAcumulativo(coleta.getAtivo(), coleta.getTipoPontoControle()));
        }
        return planos;
    }

    public void savePlanosManutencaoAtivos(WebDTOResult result, List<Coleta> coletas, Empresa empresa, OpcoesManutencEquip opcoesManutencEquip) {
        Object msgLimite = "";
        Object msgLimiteAlerta = "";
        Object msg = "";
        ArrayList<PlanoManutencaoAtivo> planosLimitesExcedidos = new ArrayList<PlanoManutencaoAtivo>();
        ArrayList<PlanoManutencaoAtivo> planosReturn = new ArrayList<PlanoManutencaoAtivo>();
        List<PlanoManutencaoAtivo> planos = this.getPlanosVinculadosColeta(coletas);
        for (PlanoManutencaoAtivo plano : planos) {
            planosReturn.add(plano);
            for (AtivoDataUltimaManutencao ativo : plano.getAtivos()) {
                for (Coleta coleta : coletas) {
                    if (coleta.getAtivo() == null || !coleta.getAtivo().equals((Object)ativo.getAtivo())) continue;
                    ativo.setValorUltimaManutencao(coleta.getValorColeta());
                    if (coleta.getColetaAnterior() != null) {
                        ativo.setValorAcumulado(Integer.valueOf(coleta.getValorColeta() - coleta.getColetaAnterior().getValorColeta() + ativo.getValorAcumulado()));
                    }
                    if (ativo.getValorAcumulado() >= plano.getLimite()) {
                        msgLimite = (String)msgLimite + plano.getIdentificador() + "-" + plano.getDescricao() + " :" + String.valueOf(coleta.getAtivo()) + "-" + coleta.getAtivo().getNome() + "/" + coleta.getTipoPontoControle().getIdentificador() + "-" + coleta.getTipoPontoControle().getDescricao() + " \n ";
                        if (planosLimitesExcedidos.contains(plano)) continue;
                        planosLimitesExcedidos.add(plano);
                        continue;
                    }
                    if (ativo.getValorAcumulado() < plano.getLimiteAlerta()) continue;
                    msgLimiteAlerta = (String)msgLimiteAlerta + plano.getIdentificador() + "-" + plano.getDescricao() + " :" + String.valueOf(coleta.getAtivo()) + "-" + coleta.getAtivo().getNome() + "/" + coleta.getTipoPontoControle().getIdentificador() + "-" + coleta.getTipoPontoControle().getDescricao() + "\n";
                }
            }
        }
        if (!((String)msgLimite).equals("")) {
            msg = (String)msg + "ATEN\u00c7\u00c3O! Algumas coletas ultrapassaram o limite de Planos de Manuten\u00e7\u00e3o:\n" + (String)msgLimite;
            if (!planosLimitesExcedidos.isEmpty() && ToolMethods.isAffirmative((Number)opcoesManutencEquip.getGerarOsPlanoPelaColeta())) {
                List<OrdemServico> osGeradas = this.geraOsPlanoManutencao(planosLimitesExcedidos, coletas, empresa, opcoesManutencEquip);
                if (!osGeradas.isEmpty()) {
                    this.helperColeta.atualizaValorAcumulado(osGeradas, planosReturn, coletas);
                    msg = (String)msg + "As Ordens de Servi\u00e7o com c\u00f3digo abaixo, foram geradas para suprir os planos excedidos: \n ";
                    for (OrdemServico ordemServico : osGeradas) {
                        msg = (String)msg + ordemServico.getCodigo() + " \n ";
                    }
                } else {
                    msg = (String)msg + "\n Nenhuma Ordem de Servi\u00e7o foi gerada para os Planos excedidos!";
                }
            }
        }
        if (!((String)msgLimiteAlerta).equals("")) {
            msg = (String)msg + "ALERTA! Algumas coletas ultrapassaram o limite de alerta de Planos de Manuten\u00e7\u00e3o: \n " + (String)msgLimiteAlerta;
        }
        if (!((String)msgLimiteAlerta).equals("")) {
            result.addMessage("", (String)msg);
            result.setStatus(EnumConstantsMentorStatus.ATENCAO);
        }
        if (planos.isEmpty()) {
            result.addMessage("", "O(s) Ativo(s) informado(s) n\u00e3o possue(m) nenhum Plano de Manuten\u00e7\u00e3o!");
            result.setStatus(EnumConstantsMentorStatus.ATENCAO);
        } else {
            this.saveOrUpdate(planos);
        }
    }

    private List<OrdemServico> geraOsPlanoManutencao(List<PlanoManutencaoAtivo> planosLimitesExcedidos, List<Coleta> coletas, Empresa empresa, OpcoesManutencEquip opcoesManutencEquip) {
        return new AuxGeraOSPlanoManutencao(this.serviceOrdemServico, this.serviceFechamentoOrdemServico, this.serviceDiagnosticoOSAtivoImpl, this.helperCronogramaOrdemServico).geraOsPlanoManutencao(planosLimitesExcedidos, coletas, empresa, opcoesManutencEquip);
    }
}

