/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.portalcotacaocompra;

import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.condicoespagamento.ServiceCondicoesPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.cotacaocompra.ServiceFornecedorItemCotacaoCompraImpl;
import com.touchcomp.basementorservice.service.impl.tipofrete.ServiceTipoFreteImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.portalcotacaocompra.DTOPortalCotacaoCompra;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Deprecated
@Service
public class ServicePortalCotacaoCompra
extends ServiceGenericImpl {
    @Autowired
    ServiceFornecedorItemCotacaoCompraImpl serviceFornecedorCotacao;
    @Autowired
    ServiceTipoFreteImpl serviceTipoFrete;
    @Autowired
    ServiceCondicoesPagamentoImpl serviceCondicoesPagamento;

    public DTOPortalCotacaoCompra getCotacaoPortal(Fornecedor fornecedor, OpcoesCompraSuprimentos opcoesCompraSup, Empresa empresa) {
        List<FornecedorItemCotacaoCompra> fornecedoresItens = this.serviceFornecedorCotacao.getFornecedoresCotacaoCompra(fornecedor, opcoesCompraSup.getSituacaoCotacaoLibPortalForn(), opcoesCompraSup.getSituacaoCotacaoAvisoForn(), empresa);
        DTOPortalCotacaoCompra d = new DTOPortalCotacaoCompra();
        d.setIdFornecedor(fornecedor.getIdentificador());
        d.setNomeFornecedor(fornecedor.getPessoa().getNome());
        fornecedoresItens.forEach(fornItem -> {
            DTOPortalCotacaoCompra.DTOCotacao cotacao;
            CotacaoCompra cotacaoCompra = fornItem.getItemCotacaoCompra().getCotacaoCompra();
            ItemCotacaoCompra itemCotacaoCompra = fornItem.getItemCotacaoCompra();
            Produto produto = itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto();
            Optional<DTOPortalCotacaoCompra.DTOCotacao> found = d.getCotacoes().stream().filter(cot -> Objects.equals(cot.getIdentificador(), cotacaoCompra.getIdentificador())).findFirst();
            DTOPortalCotacaoCompra.DTOItemCotacao item = new DTOPortalCotacaoCompra.DTOItemCotacao();
            item.setCodAuxProduto(produto.getCodigoAuxiliar());
            item.setIdProduto(produto.getIdentificador());
            item.setIdentificador(fornItem.getIdentificador());
            item.setNaturezaOperacaoDescricao(itemCotacaoCompra.getNaturezaOperacao().getDescricao());
            item.setObservacaoFornecedor(fornItem.getObservacao());
            item.setPercentualFrete(fornItem.getPercentualFrete());
            item.setPrazoEntrega(fornItem.getPrazoEntrega());
            item.setProduto(produto.getNome());
            item.setQuantidade(itemCotacaoCompra.getQuantidade());
            if (fornItem.getTipoFrete() != null) {
                item.setTipoFrete(fornItem.getTipoFrete().getIdentificador());
            }
            item.setUnidadeMedidaSigla(produto.getUnidadeMedida().getSigla());
            item.setValorFrete(fornItem.getValorFrete());
            if (fornItem.getFornecedorItemCotacaoCompraLivroFiscal() != null) {
                item.setValorTotal(fornItem.getFornecedorItemCotacaoCompraLivroFiscal().getValorTotal());
            }
            if (fornItem.getCondicoesPagamento() != null) {
                item.setCondicoesPagamento(fornItem.getCondicoesPagamento().getNome());
                item.setCondicoesPagamentoIdentificador(fornItem.getCondicoesPagamento().getIdentificador());
                item.setCondicoesPagamentoVariavelFixa(fornItem.getCondicoesPagamento().getMutanteFixa());
                if (ToolMethods.isEquals((Object)fornItem.getCondicoesPagamento().getMutanteFixa(), (Object)1)) {
                    item.setCondicoesPagamentoParcelas(fornItem.getCondicoesPagamento().getParcelasMutante());
                }
            }
            item.setCondicoesPagamentoParcelas(fornItem.getCondicaoPagamentoMutante());
            item.setValorUnitario(fornItem.getValorUnitario());
            if (!found.isPresent()) {
                cotacao = new DTOPortalCotacaoCompra.DTOCotacao();
                cotacao.setDataCotacaoCompra(cotacaoCompra.getDataCotacaoCompra());
                cotacao.setDataFinalizacaoProcesso(cotacaoCompra.getDataFinalizacao());
                cotacao.setDataPrevFinalizacao(cotacaoCompra.getDataPrevFinalizacao());
                cotacao.setIdentificador(cotacaoCompra.getIdentificador());
                cotacao.setObservacao(cotacaoCompra.getObservacao());
                cotacao.setSituacaoCotacao(cotacaoCompra.getSituacaoCotacaoCompra().getDescricao());
                cotacao.setIdEmpresa(cotacaoCompra.getEmpresa().getIdentificador());
                cotacao.setCondicoesPagamento(item.getCondicoesPagamento());
                cotacao.setCondicoesPagamentoParcelas(item.getCondicoesPagamentoParcelas());
                cotacao.setCondicoesPagamentoIdentificador(item.getCondicoesPagamentoIdentificador());
                cotacao.setCondicoesPagamentoVariavel(item.getCondicoesPagamentoVariavel());
                cotacao.setCondicoesPagamentoVariavelFixa(item.getCondicoesPagamentoVariavelFixa());
                d.getCotacoes().add(cotacao);
            } else {
                cotacao = found.get();
            }
            cotacao.getItens().add(item);
        });
        return d;
    }

    public void salvarDadosCotacaoPortal(DTOPortalCotacaoCompra portalCotacoes) {
        HashMap<Long, CondicoesPagamento> condicoes = new HashMap<Long, CondicoesPagamento>();
        for (DTOPortalCotacaoCompra.DTOCotacao cotacao : portalCotacoes.getCotacoes()) {
            for (DTOPortalCotacaoCompra.DTOItemCotacao item : cotacao.getItens()) {
                FornecedorItemCotacaoCompra forn = (FornecedorItemCotacaoCompra)this.serviceFornecedorCotacao.get(item.getIdentificador());
                forn.setValorUnitario(item.getValorUnitario());
                if (this.isNull(forn.getValorUnitario()).booleanValue()) {
                    forn.setValorUnitario(Double.valueOf(0.0));
                }
                forn.setValorFrete(item.getValorFrete());
                if (this.isNull(forn.getValorFrete()).booleanValue()) {
                    forn.setValorFrete(Double.valueOf(0.0));
                }
                forn.getFornecedorItemCotacaoCompraLivroFiscal().setValorTotal(item.getValorTotal());
                forn.setPercentualFrete(item.getPercentualFrete());
                if (this.isNull(forn.getPercentualFrete()).booleanValue()) {
                    forn.setPercentualFrete(Double.valueOf(0.0));
                }
                forn.setTipoFrete((TipoFrete)this.serviceTipoFrete.get(item.getTipoFrete()));
                forn.setPrazoEntrega(item.getPrazoEntrega());
                forn.setCondicaoPagamentoMutante(item.getCondicoesPagamentoParcelas());
                if (item.getCondicoesPagamentoIdentificador() != null) {
                    CondicoesPagamento cond = (CondicoesPagamento)condicoes.get(item.getCondicoesPagamentoIdentificador());
                    if (cond == null) {
                        cond = (CondicoesPagamento)this.serviceCondicoesPagamento.get(item.getCondicoesPagamentoIdentificador());
                        condicoes.put(item.getCondicoesPagamentoIdentificador(), cond);
                    }
                    forn.setCondicoesPagamento(cond);
                }
                this.serviceFornecedorCotacao.saveOrUpdate(forn);
            }
        }
    }
}

