/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.portalcotacaocompra;

import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ItemNecCompraDetalhes;
import com.touchcomp.basementor.model.vo.Marca;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.helpers.impl.produto.HelperProduto;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.condicoespagamento.ServiceCondicoesPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.cotacaocompra.ServiceFornecedorItemCotacaoCompraImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.itemcotacaocompra.ServiceItemCotacaoCompraImpl;
import com.touchcomp.basementorservice.service.impl.marca.ServiceMarcaImpl;
import com.touchcomp.basementorservice.service.impl.tipofrete.ServiceTipoFreteImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.necessidadecompra.DTOItemNecCompraDetalhes;
import com.touchcomp.touchvomodel.vo.portalcotacaocompra.DTOPortalCotacaoCompraV4;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServicePortalCotacaoCompraV4
extends ServiceGenericImpl {
    @Autowired
    ServiceFornecedorItemCotacaoCompraImpl serviceFornecedorCotacao;
    @Autowired
    ServiceTipoFreteImpl serviceTipoFrete;
    @Autowired
    ServiceCondicoesPagamentoImpl serviceCondicoesPagamento;
    @Autowired
    ServiceGradeCorImpl serviceGradeCor;
    @Autowired
    ServiceItemCotacaoCompraImpl serviceItemCotacaoCompra;

    public DTOPortalCotacaoCompraV4 getCotacaoPortal(Fornecedor fornecedor, OpcoesCompraSuprimentos opcoesCompraSup, Empresa empresa) {
        List<FornecedorItemCotacaoCompra> fornecedoresItens = this.serviceFornecedorCotacao.getFornecedoresCotacaoCompra(fornecedor, opcoesCompraSup.getSituacaoCotacaoLibPortalForn(), opcoesCompraSup.getSituacaoCotacaoAvisoForn(), empresa);
        DTOPortalCotacaoCompraV4 d = new DTOPortalCotacaoCompraV4();
        d.setIdFornecedor(fornecedor.getIdentificador());
        d.setNomeFornecedor(fornecedor.getPessoa().getNome());
        HelperProduto helperProd = new HelperProduto();
        fornecedoresItens.forEach(fornItem -> {
            DTOPortalCotacaoCompraV4.DTOCotacao cotacao;
            CotacaoCompra cotacaoCompra = fornItem.getItemCotacaoCompra().getCotacaoCompra();
            ItemCotacaoCompra itemCotacaoCompra = fornItem.getItemCotacaoCompra();
            Produto produto = itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto();
            Optional<DTOPortalCotacaoCompraV4.DTOCotacao> found = d.getCotacoes().stream().filter(cot -> Objects.equals(cot.getIdentificador(), cotacaoCompra.getIdentificador())).findFirst();
            DTOPortalCotacaoCompraV4.DTOItemCotacao item = new DTOPortalCotacaoCompraV4.DTOItemCotacao();
            item.setCodAuxProduto(produto.getCodigoAuxiliar());
            item.setIdProduto(produto.getIdentificador());
            item.setCodigoBarras(helperProd.build(produto).getCodigosBarrasAtivos());
            item.setIdentificador(fornItem.getIdentificador());
            item.setNaturezaOperacaoDescricao(itemCotacaoCompra.getNaturezaOperacao().getDescricao());
            item.setObservacaoFornecedor(fornItem.getObservacao());
            item.setObservacaoItem(itemCotacaoCompra.getObservacao());
            item.setPercentualFrete(fornItem.getPercentualFrete());
            item.setPrazoEntrega(fornItem.getPrazoEntrega());
            item.setProduto(produto.getNome());
            item.setQuantidade(itemCotacaoCompra.getQuantidade());
            if (produto.getFabricante() != null) {
                item.setFabricanteNome(produto.getFabricante().getNome());
            }
            if (fornItem.getTipoFrete() != null) {
                item.setTipoFrete(fornItem.getTipoFrete().getIdentificador());
            }
            item.setUnidadeMedidaSigla(produto.getUnidadeMedida().getSigla());
            item.setUnidadeMedidaIdentificador(produto.getUnidadeMedida().getIdentificador());
            item.setValorFrete(fornItem.getValorFrete());
            if (fornItem.getFornecedorItemCotacaoCompraLivroFiscal() != null) {
                item.setValorTotal(fornItem.getFornecedorItemCotacaoCompraLivroFiscal().getValorTotal());
            }
            if (fornItem.getCondicoesPagamento() != null) {
                item.setCondicoesPagamento(fornItem.getCondicoesPagamento().getNome());
                item.setCondicoesPagamentoIdentificador(fornItem.getCondicoesPagamento().getIdentificador());
                item.setCondicoesPagamentoVariavelFixa(fornItem.getCondicoesPagamento().getMutanteFixa());
                if (ToolMethods.isEquals((Object)fornItem.getCondicoesPagamento().getMutanteFixa(), (Object)1)) {
                    item.setCondicoesPagamentoParcelas(fornItem.getCondicoesPagamento().getParcelasMutante());
                }
            }
            item.setCondicoesPagamentoParcelas(fornItem.getCondicaoPagamentoMutante());
            item.setValorUnitario(fornItem.getValorUnitario());
            if (fornItem.getMarca() != null) {
                item.setMarcaIdentificador(fornItem.getMarca().getIdentificador());
            }
            item.setValorDesconto(fornItem.getValorDesconto());
            item.setPercentualDesconto(fornItem.getPercentualDesconto());
            ArrayList<DTOPortalCotacaoCompraV4.DTONecessidadeCompra> necessidadeCompras = new ArrayList<DTOPortalCotacaoCompraV4.DTONecessidadeCompra>();
            if (itemCotacaoCompra.getNecessidadesCompra() != null) {
                for (NecessidadeCompra necessidadeCompra : itemCotacaoCompra.getNecessidadesCompra()) {
                    DTOPortalCotacaoCompraV4.DTONecessidadeCompra dtoNec = new DTOPortalCotacaoCompraV4.DTONecessidadeCompra();
                    if (necessidadeCompra.getItemNecCompraDetalhes() != null) {
                        ArrayList<DTOItemNecCompraDetalhes> detalhes = new ArrayList<DTOItemNecCompraDetalhes>();
                        for (ItemNecCompraDetalhes i : necessidadeCompra.getItemNecCompraDetalhes()) {
                            DTOItemNecCompraDetalhes dtoDet = new DTOItemNecCompraDetalhes();
                            dtoDet.setAltura(i.getAltura());
                            dtoDet.setLargura(i.getLargura());
                            dtoDet.setComprimento(i.getComprimento());
                            dtoDet.setVolume(i.getVolume());
                            dtoDet.setQuantidade(i.getQuantidade());
                            dtoDet.setQtdReferencia(i.getQtdReferencia());
                            dtoDet.setIdentificador(i.getIdentificador());
                            if (i.getUnidadeMedida() != null) {
                                dtoDet.setUnidadeMedida(i.getUnidadeMedida().toString());
                                dtoDet.setUnidadeMedidaIdentificador(i.getUnidadeMedida().getIdentificador());
                            }
                            detalhes.add(dtoDet);
                        }
                        dtoNec.setItemNecCompraDetalhes(detalhes);
                    }
                    dtoNec.setIdentificador(necessidadeCompra.getIdentificador());
                    necessidadeCompras.add(dtoNec);
                }
            }
            item.setNecessidadesCompra(necessidadeCompras);
            if (!found.isPresent()) {
                cotacao = new DTOPortalCotacaoCompraV4.DTOCotacao();
                cotacao.setDataCotacaoCompra(cotacaoCompra.getDataCotacaoCompra());
                cotacao.setDataFinalizacaoProcesso(cotacaoCompra.getDataFinalizacao());
                cotacao.setDataPrevFinalizacao(cotacaoCompra.getDataPrevFinalizacao());
                cotacao.setIdentificador(cotacaoCompra.getIdentificador());
                cotacao.setObservacao(cotacaoCompra.getObservacao());
                cotacao.setSituacaoCotacao(cotacaoCompra.getSituacaoCotacaoCompra().getDescricao());
                cotacao.setIdEmpresa(cotacaoCompra.getEmpresa().getIdentificador());
                cotacao.setCondicoesPagamento(item.getCondicoesPagamento());
                cotacao.setCondicoesPagamentoParcelas(item.getCondicoesPagamentoParcelas());
                cotacao.setCondicoesPagamentoIdentificador(item.getCondicoesPagamentoIdentificador());
                cotacao.setCondicoesPagamentoVariavel(item.getCondicoesPagamentoVariavel());
                cotacao.setCondicoesPagamentoVariavelFixa(item.getCondicoesPagamentoVariavelFixa());
                d.getCotacoes().add(cotacao);
            } else {
                cotacao = found.get();
            }
            cotacao.getItens().add(item);
        });
        return d;
    }

    public void salvarDadosCotacaoPortal(DTOPortalCotacaoCompraV4 portalCotacoes) {
        HashMap<Long, CondicoesPagamento> condicoes = new HashMap<Long, CondicoesPagamento>();
        for (DTOPortalCotacaoCompraV4.DTOCotacao cotacao : portalCotacoes.getCotacoes()) {
            for (DTOPortalCotacaoCompraV4.DTOItemCotacao item : cotacao.getItens()) {
                FornecedorItemCotacaoCompra forn = (FornecedorItemCotacaoCompra)this.serviceFornecedorCotacao.get(item.getIdentificador());
                forn.setValorUnitario(item.getValorUnitario());
                if (this.isNull(forn.getValorUnitario()).booleanValue()) {
                    forn.setValorUnitario(Double.valueOf(0.0));
                }
                forn.setValorFrete(item.getValorFrete());
                if (this.isNull(forn.getValorFrete()).booleanValue()) {
                    forn.setValorFrete(Double.valueOf(0.0));
                }
                forn.getFornecedorItemCotacaoCompraLivroFiscal().setValorTotal(item.getValorTotal());
                forn.setPercentualFrete(item.getPercentualFrete());
                if (this.isNull(forn.getPercentualFrete()).booleanValue()) {
                    forn.setPercentualFrete(Double.valueOf(0.0));
                }
                forn.setTipoFrete((TipoFrete)this.serviceTipoFrete.get(item.getTipoFrete()));
                forn.setPrazoEntrega(item.getPrazoEntrega());
                forn.setCondicaoPagamentoMutante(item.getCondicoesPagamentoParcelas());
                if (ToolMethods.isWithData((Number)item.getMarcaIdentificador())) {
                    forn.setMarca((Marca)this.getBean(ServiceMarcaImpl.class).get(item.getMarcaIdentificador()));
                }
                if (item.getCondicoesPagamentoIdentificador() != null) {
                    CondicoesPagamento cond = (CondicoesPagamento)condicoes.get(item.getCondicoesPagamentoIdentificador());
                    if (cond == null) {
                        cond = (CondicoesPagamento)this.serviceCondicoesPagamento.get(item.getCondicoesPagamentoIdentificador());
                        condicoes.put(item.getCondicoesPagamentoIdentificador(), cond);
                    }
                    forn.setCondicoesPagamento(cond);
                }
                if (item.getObservacaoItem() != null && forn.getItemCotacaoCompra() != null) {
                    forn.getItemCotacaoCompra().setObservacao(item.getObservacaoItem());
                }
                if (item.getObservacaoFornecedor() != null) {
                    forn.setObservacao(item.getObservacaoFornecedor());
                }
                forn.setValorDesconto(item.getValorDesconto());
                if (this.isNull(forn.getValorDesconto()).booleanValue()) {
                    forn.setValorDesconto(Double.valueOf(0.0));
                }
                forn.setPercentualDesconto(item.getPercentualDesconto());
                if (this.isNull(forn.getPercentualDesconto()).booleanValue()) {
                    forn.setPercentualDesconto(Double.valueOf(0.0));
                }
                this.serviceFornecedorCotacao.saveOrUpdate(forn);
            }
        }
    }

    public DTOPortalCotacaoCompraV4.DTOItemCotacao setarItemSubstituto(Long idGradeCor, DTOPortalCotacaoCompraV4.DTOItemCotacao item) throws ExceptionObjNotFound, ExceptionValidacaoDados {
        FornecedorItemCotacaoCompra fornecedor = (FornecedorItemCotacaoCompra)this.serviceFornecedorCotacao.getOrThrow(item.getIdentificador());
        ItemCotacaoCompra vo = fornecedor.getItemCotacaoCompra();
        if (!this.isNull(vo).booleanValue()) {
            HelperProduto helperProd = new HelperProduto();
            this.serviceItemCotacaoCompra.setarItemSubstituto(idGradeCor, vo);
            this.serviceItemCotacaoCompra.saveOrUpdate(vo);
            item.setProduto(vo.getGradeCor().getProdutoGrade().getProduto().getNome());
            item.setIdProduto(vo.getGradeCor().getProdutoGrade().getProduto().getIdentificador());
            item.setCodAuxProduto(vo.getGradeCor().getProdutoGrade().getProduto().getCodigoAuxiliar());
            item.setCodigoBarras(helperProd.build(vo.getGradeCor().getProdutoGrade().getProduto()).getCodigosBarrasAtivos());
            if (vo.getGradeCor().getProdutoGrade().getProduto().getFabricante() != null) {
                item.setFabricanteNome(vo.getGradeCor().getProdutoGrade().getProduto().getFabricante().getNome());
            }
            item.setUnidadeMedidaSigla(vo.getGradeCor().getProdutoGrade().getProduto().getUnidadeMedida().getSigla());
            item.setUnidadeMedidaIdentificador(vo.getGradeCor().getProdutoGrade().getProduto().getUnidadeMedida().getIdentificador());
        }
        return item;
    }
}

