/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.preacuracidadeest;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.estoque.EnumTipoArquivoColetorCodBarras;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.PreAcuracidadeEst;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoPreAcuracidadeEstImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.proccodigobarras.ServiceProcCodigoBarrasImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementortools.tools.barcode.ToolBarcode;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.preacuracidadeest.web.DTOPreAcuracidadeEst;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServicePreAcuracidadeEstImpl
extends ServiceGenericEntityImpl<PreAcuracidadeEst, Long, DaoPreAcuracidadeEstImpl> {
    @Autowired
    ServiceProdutoImpl serviceProdutoImpl;
    @Autowired
    ServiceGradeCorImpl serviceGradeCorImpl;
    @Autowired
    ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;
    @Autowired
    ServiceProcCodigoBarrasImpl serviceProcCodigoBarrasImpl;

    @Autowired
    public ServicePreAcuracidadeEstImpl(DaoPreAcuracidadeEstImpl dao, ServiceProdutoImpl serviceProdutoImpl, ServiceGradeCorImpl serviceGradeCorImpl, ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl, ServiceProcCodigoBarrasImpl serviceProcCodigoBarrasImpl) {
        super(dao);
        this.serviceProdutoImpl = serviceProdutoImpl;
        this.serviceGradeCorImpl = serviceGradeCorImpl;
        this.serviceProcCodigoBarrasImpl = serviceProcCodigoBarrasImpl;
    }

    public List<DTOPreAcuracidadeEst.DTOPreAcuracidadeEstItem> getProduto(Long idProduto) {
        Produto prod = (Produto)this.serviceProdutoImpl.get(idProduto);
        if (this.isNull(prod).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1939.001", new Object[]{idProduto}));
        }
        List<GradeCor> grade = this.serviceGradeCorImpl.get(prod);
        if (this.isNull(grade).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1439.002", new Object[]{idProduto}));
        }
        List<DTOPreAcuracidadeEst.DTOPreAcuracidadeEstItem> dto = this.adicionarGrades(grade, 0.0);
        return dto;
    }

    public List<DTOPreAcuracidadeEst.DTOPreAcuracidadeEstItem> getItens(String produto, Double quantidade, OpcoesFaturamento opcoesFaturamento) {
        Produto prod = new Produto();
        List<Object> prods = new ArrayList();
        if (ToolString.isAIntegerNumber((String)produto) && ToolBarcode.isCodigoPesavel((String)produto)) {
            prod = this.serviceProdutoImpl.getByCodigoBarras(produto);
        } else if (!ToolString.isAIntegerNumber((String)produto)) {
            if (this.isEquals(opcoesFaturamento.getUsarCodigoAuxProduto(), EnumConstantsMentorSimNao.SIM.getValue())) {
                prod = this.serviceProdutoImpl.getByCodigoAuxiliar(produto);
            }
        } else if (ToolString.isAIntegerNumber((String)produto)) {
            if (this.isEquals(opcoesFaturamento.getUsarIdProduto(), EnumConstantsMentorSimNao.SIM.getValue()) && this.isEquals(opcoesFaturamento.getUsarCodigoAuxProduto(), EnumConstantsMentorSimNao.NAO.getValue()) || this.isEquals(opcoesFaturamento.getUsarIdProduto(), EnumConstantsMentorSimNao.NAO.getValue()) && this.isEquals(opcoesFaturamento.getUsarCodigoAuxProduto(), EnumConstantsMentorSimNao.NAO.getValue())) {
                prod = (Produto)this.serviceProdutoImpl.get(Long.parseLong(produto));
            } else if (this.isEquals(opcoesFaturamento.getUsarCodigoAuxProduto(), EnumConstantsMentorSimNao.SIM.getValue()) && this.isEquals(opcoesFaturamento.getUsarIdProduto(), EnumConstantsMentorSimNao.NAO.getValue())) {
                prod = this.serviceProdutoImpl.getByCodigoAuxiliar(produto);
            } else {
                prods = this.serviceProdutoImpl.getByIdentificadorProdutoAndCodigoAuxiliar(Long.parseLong(produto), produto);
            }
        }
        ArrayList<GradeCor> grades = new ArrayList<GradeCor>();
        if (prods.isEmpty() || this.isNull(prods).booleanValue() && this.isNull(prod).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1939.001", new String[]{produto}));
        }
        if (!prods.isEmpty()) {
            for (Produto pro : prods) {
                grades.addAll(this.serviceGradeCorImpl.get(pro));
            }
        } else {
            grades.addAll(this.serviceGradeCorImpl.get(prod));
        }
        if (this.isNull(grades).booleanValue() || grades.isEmpty()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1439.002", new String[]{produto}));
        }
        List<DTOPreAcuracidadeEst.DTOPreAcuracidadeEstItem> dto = this.adicionarGrades(grades, quantidade);
        return dto;
    }

    private List<DTOPreAcuracidadeEst.DTOPreAcuracidadeEstItem> adicionarGrades(List<GradeCor> grades, Double quantidade) {
        ArrayList<DTOPreAcuracidadeEst.DTOPreAcuracidadeEstItem> itens = new ArrayList<DTOPreAcuracidadeEst.DTOPreAcuracidadeEstItem>();
        for (GradeCor grade : grades) {
            DTOPreAcuracidadeEst.DTOPreAcuracidadeEstItem p = new DTOPreAcuracidadeEst.DTOPreAcuracidadeEstItem();
            this.getLoteFabricacao(grade, p);
            p.setGradeCorIdentificador(grade.getIdentificador());
            p.setGradeCor(grade.getCor().getNome());
            p.setAltura(grade.getProdutoGrade().getProduto().getAltura());
            p.setComprimento(grade.getProdutoGrade().getProduto().getComprimento());
            p.setLargura(grade.getProdutoGrade().getProduto().getLargura());
            p.setQuantidade(quantidade);
            p.setQuantidadeRef(quantidade);
            p.setIdentificadorProduto(grade.getProdutoGrade().getProduto().getIdentificador());
            p.setProduto(grade.getProdutoGrade().getProduto().getNome());
            p.setCodigoAuxiliar(grade.getProdutoGrade().getProduto().getCodigoAuxiliar());
            p.setUn(grade.getProdutoGrade().getProduto().getUnidadeMedida().getSigla());
            itens.add(p);
        }
        return itens;
    }

    private void getLoteFabricacao(GradeCor grade, DTOPreAcuracidadeEst.DTOPreAcuracidadeEstItem p) {
        if (!this.isNull(grade.getProdutoGrade().getProduto().getLoteUnico()).booleanValue() || grade.getProdutoGrade().getProduto().getLoteUnico().shortValue() != EnumConstantsMentorSimNao.NAO.getValue()) {
            LoteFabricacao l = this.serviceLoteFabricacaoImpl.findOrCreateLoteUnico(grade.getProdutoGrade().getProduto());
            p.setLoteFabricacaoIdentificador(l.getIdentificador());
            p.setLoteFabricacao(l.getLoteFabricacao());
            p.setDataValidade(l.getDataValidade());
            p.setDataFabricacao(l.getDataFabricacao());
        }
    }

    public List<DTOPreAcuracidadeEst.DTOPreAcuracidadeEstItem> getPreAcuracidadeEstItemGrade(Long idGrade) {
        ArrayList<GradeCor> gradeCor = new ArrayList<GradeCor>();
        gradeCor.add((GradeCor)this.serviceGradeCorImpl.get(idGrade));
        if (!ServicePreAcuracidadeEstImpl.isWithData(gradeCor)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1439.002", new Object[]{idGrade}));
        }
        List<DTOPreAcuracidadeEst.DTOPreAcuracidadeEstItem> dto = this.adicionarGrades(gradeCor, 0.0);
        return dto;
    }

    public List<DTOPreAcuracidadeEst.DTOPreAcuracidadeEstItem> importDadosColetorInterno(String text, Short tipoArquivo, String separador) throws ExceptionIO, ExceptionRuntimeBase {
        EnumTipoArquivoColetorCodBarras tipo = EnumTipoArquivoColetorCodBarras.get((Object)tipoArquivo);
        if ((this.isEquals(tipo, EnumTipoArquivoColetorCodBarras.DUAS_COLUNAS_COM_SEPARADOR) || this.isEquals(tipo, EnumTipoArquivoColetorCodBarras.TRES_COLUNAS_COM_SEPARADOR)) && this.isNull(separador).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1439.003", new String[]{separador}));
        }
        List<ServiceProcCodigoBarrasImpl.CodigoBarrasItem> dados = this.serviceProcCodigoBarrasImpl.processCodigoBarrasColetor(text, tipo, separador);
        ArrayList<DTOPreAcuracidadeEst.DTOPreAcuracidadeEstItem> dto = new ArrayList<DTOPreAcuracidadeEst.DTOPreAcuracidadeEstItem>();
        for (ServiceProcCodigoBarrasImpl.CodigoBarrasItem dado : dados) {
            ArrayList<GradeCor> grade = new ArrayList<GradeCor>();
            grade.add(dado.getGradeCor());
            dto.addAll(this.adicionarGrades(grade, dado.getQuantidade()));
        }
        return dto;
    }

    @Override
    public PreAcuracidadeEst beforeSave(PreAcuracidadeEst aux) {
        aux.getItens().forEach(i -> i.setPreAcuracidadeEstoque(aux));
        return aux;
    }
}

