/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.proccodigobarras;

import com.touchcomp.basementor.constants.enums.estoque.EnumTipoArquivoColetorCodBarras;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceProduto;
import com.touchcomp.basementortools.tools.excel.ToolExcel;
import com.touchcomp.basementortools.tools.excel.model.ExcelSheet;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceProcCodigoBarrasImpl
extends ServiceGenericImpl {
    @Autowired
    private ServiceProduto serviceProduto;
    @Autowired
    private ServiceGradeCorImpl serviceGradeCor;

    public List<CodigoBarrasItem> processCodigoBarrasColetor(String text, EnumTipoArquivoColetorCodBarras tipoColetor, String separador) throws ExceptionIO {
        ExcelSheet sheet = this.isStrWithData(separador) ? ToolExcel.read((String)text, (char)separador.charAt(0)) : ToolExcel.read((String)text, (char)'\t');
        LinkedList<CodigoBarrasItem> ret = new LinkedList<CodigoBarrasItem>();
        for (ExcelSheet.Row row : sheet.getRows()) {
            switch (tipoColetor) {
                case UMA_COLUNA: {
                    this.readRow(row, ret, 0, 1);
                    break;
                }
                case DUAS_COLUNAS: 
                case DUAS_COLUNAS_COM_SEPARADOR: {
                    this.readRow(row, ret, 0, 1);
                    break;
                }
                case TRES_COLUNAS: 
                case TRES_COLUNAS_COM_SEPARADOR: {
                    this.readRow(row, ret, 1, 2);
                }
            }
        }
        return ret;
    }

    private void readRow(ExcelSheet.Row row, List<CodigoBarrasItem> ret, int columnCodeProd, int columnQtd) {
        ExcelSheet.Cell cell;
        String codProduto = "";
        String quantidade = "1";
        if (row.getCellsSize() > columnCodeProd) {
            cell = row.getCell(columnCodeProd);
            codProduto = cell.asString();
        }
        if (row.getCellsSize() > columnQtd && (quantidade = (cell = row.getCell(columnQtd)).asString()) != null && quantidade.contains(",")) {
            quantidade = quantidade.replace(",", ".");
        }
        if (!TMethods.isStrWithData((String)quantidade)) {
            quantidade = "1";
        }
        if (ToolMethods.isStrWithData((String)codProduto) && ToolMethods.isStrWithData((String)quantidade)) {
            this.addProduto(codProduto, quantidade, ret);
        }
    }

    private void addProduto(String codProduto, String quantidade, List<CodigoBarrasItem> ret) {
        Double qtd = Double.valueOf(quantidade);
        CodigoBarrasItem cod = null;
        String tempCodProd = codProduto;
        Optional<CodigoBarrasItem> found = ret.stream().filter(i -> Objects.equals(tempCodProd, i.codigoBarras)).findFirst();
        if (found.isPresent()) {
            cod = found.get();
            cod.setQuantidade(cod.getQuantidade() + qtd);
            return;
        }
        cod = new CodigoBarrasItem();
        cod.setQuantidade(qtd);
        GradeCor gc = this.serviceGradeCor.getByCodigoBarras(codProduto);
        Produto prod = null;
        if (gc != null) {
            prod = gc.getProdutoGrade().getProduto();
        }
        if (prod == null) {
            prod = this.serviceProduto.getByCodigoBarras(codProduto);
        }
        if (prod == null) {
            prod = this.serviceProduto.getByCodigoAuxiliar(codProduto);
        }
        if (prod == null && codProduto.length() < 10) {
            prod = (Produto)this.serviceProduto.get(codProduto);
        }
        if (prod == null) {
            return;
        }
        if (gc == null) {
            gc = this.serviceGradeCor.getFirstGradeCor(prod);
        }
        cod.setCodigoBarras(codProduto);
        cod.setGradeCor(gc);
        cod.setEncontrou(Boolean.TRUE);
        cod.setProduto(prod);
        ret.add(cod);
    }

    public static class CodigoBarrasItem {
        private GradeCor gradeCor;
        private Produto produto;
        private Double quantidade = 0.0;
        private String codigoBarras;
        private Boolean encontrou = false;

        public GradeCor getGradeCor() {
            return this.gradeCor;
        }

        public void setGradeCor(GradeCor gradeCor) {
            this.gradeCor = gradeCor;
        }

        public Produto getProduto() {
            return this.produto;
        }

        public void setProduto(Produto produto) {
            this.produto = produto;
        }

        public Double getQuantidade() {
            return this.quantidade;
        }

        public void setQuantidade(Double quantidade) {
            this.quantidade = quantidade;
        }

        public String getCodigoBarras() {
            return this.codigoBarras;
        }

        public void setCodigoBarras(String codigoBarras) {
            this.codigoBarras = codigoBarras;
        }

        public Boolean getEncontrou() {
            return this.encontrou;
        }

        public void setEncontrou(Boolean encontrou) {
            this.encontrou = encontrou;
        }
    }
}

