/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.processotrabalhista;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.capsules.impl.CapsUsuario;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocProcessoTrabalhista;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorservice.dao.impl.DaoProcessoTrabalhistaImpl;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperEsocPreEvento;
import com.touchcomp.basementorservice.model.TempSaveObj;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.esocpreevento.ServiceEsocPreEventoImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementorvalidator.crud.ValidGenericCrud;
import com.touchcomp.basementorvalidator.entities.ValidGeneric;
import com.touchcomp.touchvomodel.vo.processotrabalhista.DTOEsocProcessoTrabalhista;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceProcessoTrabalhistaImpl
extends ServiceGenericEntityImpl<EsocProcessoTrabalhista, Long, DaoProcessoTrabalhistaImpl> {
    @Autowired
    private HelperEsocPreEvento helper;
    @Autowired
    private ServiceEsocPreEventoImpl serviceEsocPreEvento;
    @Autowired
    private ServiceEmpresaImpl serviceEmpresa;
    @Autowired
    private ServiceUsuarioImpl serviceUsuario;

    @Autowired
    public ServiceProcessoTrabalhistaImpl(DaoProcessoTrabalhistaImpl genericDao) {
        super(genericDao);
    }

    @Override
    public EsocProcessoTrabalhista beforeSave(EsocProcessoTrabalhista vo) {
        if (vo.getCompetenciaInicial() != null) {
            vo.setCompetenciaInicial(TDate.getDataInicial((Date)vo.getCompetenciaInicial()));
        }
        if (vo.getCompetenciaFinal() != null) {
            vo.setCompetenciaFinal(TDate.getDataFinal((Date)vo.getCompetenciaFinal()));
        }
        if (vo.getBaseCalculoContribPrevidenciarias() != null) {
            vo.getBaseCalculoContribPrevidenciarias().forEach(i -> i.setProcessoTrabalhista(vo));
        }
        if (vo.getAbonos() != null) {
            vo.getAbonos().forEach(i -> i.setProcessoTrabalhista(vo));
        }
        if (vo.getInformacoesFGTS() != null) {
            vo.getInformacoesFGTS().forEach(i -> i.setProcessoTrabalhista(vo));
        }
        if (vo.getRemuneracoes() != null) {
            vo.getRemuneracoes().forEach(i -> i.setProcessoTrabalhista(vo));
        }
        if (vo.getPreEventosEsocial() != null) {
            vo.getPreEventosEsocial().forEach(i -> i.setProcessoTrabalhista(vo));
        }
        return vo;
    }

    public void buildEsocEventos(EsocProcessoTrabalhista vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        if (vo.getPreEventosEsocial() == null || vo.getPreEventosEsocial().isEmpty()) {
            vo.setPreEventosEsocial(new ArrayList());
            vo.getPreEventosEsocial().add(this.helper.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
            vo.getPreEventosEsocial().add(this.helper.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
        }
    }

    public List<EsocProcessoTrabalhista> getEsocProcessoTrabalhistaByNrProcTrab(String nrProcTrab) {
        return ((DaoProcessoTrabalhistaImpl)this.getGenericDao()).getEsocProcessoTrabalhistaByNrProcTrab(nrProcTrab);
    }

    public TempSaveObj<EsocProcessoTrabalhista> saveInterno(DTOEsocProcessoTrabalhista input, CapsUsuario capsUsuario, CapsEmpresa capsEmpresa, ValidGeneric<EsocProcessoTrabalhista> validator, ValidGenericCrud validCrud) throws ExceptionEsocial {
        EsocProcessoTrabalhista vo = (EsocProcessoTrabalhista)this.buildToEntity(input);
        Usuario usuario = (Usuario)this.serviceUsuario.get(capsUsuario.get());
        Empresa empresa = (Empresa)this.serviceEmpresa.get(capsEmpresa.get());
        this.buildEsocEventos(vo, usuario, empresa);
        return this.saveOrUpdateValidate(vo, validator, validCrud);
    }
}

