/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.produto;

import com.touchcomp.basementor.constants.enums.logproduto.EnumConstLogProduto;
import com.touchcomp.basementor.model.vo.LogProduto;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorservice.dao.impl.DaoLogProdutoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.TDate;
import java.util.Date;
import org.springframework.stereotype.Service;

@Service
public class ServiceLogProdutoImpl
extends ServiceGenericEntityImpl<LogProduto, Long, DaoLogProdutoImpl> {
    public ServiceLogProdutoImpl(DaoLogProdutoImpl genericDao) {
        super(genericDao);
    }

    public LogProduto getLogProdutoAberto(EnumConstLogProduto tipoLog, Produto produto) {
        return ((DaoLogProdutoImpl)this.getDao()).getLogProdutoAberto(tipoLog, produto);
    }

    public void avaliarCriarLog(Produto old, Produto produto) {
        if (old == null || produto == null) {
            return;
        }
        if (!produto.getNome().equalsIgnoreCase(old.getNome())) {
            LogProduto l = this.getLogProdutoAberto(EnumConstLogProduto.DESCRICAO_NOME_PRODUTO, produto);
            if (l != null && TDate.difBetweenDatesInDays((Date)l.getDataIniUtilDesc(), (Date)TDate.dataSemHora((Date)new Date())) > 1L) {
                l.setDataFimUtilDesc(new Date());
                this.saveOrUpdate(l);
            }
            if (l == null) {
                l = new LogProduto();
            }
            l.setCodigo(EnumConstLogProduto.DESCRICAO_NOME_PRODUTO.getValue());
            l.setConteudoAnterior(old.getNome());
            l.setDataIniUtilDesc(new Date());
            l.setProduto(produto);
            this.saveOrUpdate(l);
        }
    }
}

