/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.produto;

import com.touchcomp.basementor.model.vo.CaracteristicaProduto;
import com.touchcomp.basementor.model.vo.ParamCodAuxProduto;
import com.touchcomp.basementor.model.vo.ParamCodAuxProdutoEspecie;
import com.touchcomp.basementor.model.vo.ParamCodAuxProdutoSubEspecie;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TipoCaracteristicaProduto;
import com.touchcomp.basementor.model.vo.TipoParamCodAuxProduto;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.EnumExcepInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.paramcodauxproduto.ServiceParamCodAuxProdutoImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.TString;
import org.springframework.stereotype.Service;

@Service
public class ServiceProdutoGeraCodAuxiliarImpl
extends ServiceGenericImpl {
    ServiceParamCodAuxProdutoImpl serviceParamCodAuxProdutoImpl;
    private final char CACACTER_ABERTURA = (char)91;
    private final char CACACTER_ENCERRAMENTO = (char)93;

    public ServiceProdutoGeraCodAuxiliarImpl(ServiceParamCodAuxProdutoImpl serviceParamCodAuxProdutoImpl) {
        this.serviceParamCodAuxProdutoImpl = serviceParamCodAuxProdutoImpl;
    }

    public void gerarCodigoAuxiliar(Produto prod) throws ExceptionObjNotFound, ExceptionInvalidData {
        if (TMethods.isStrWithData((String)prod.getCodigoAuxiliar())) {
            return;
        }
        ParamCodAuxProduto param = this.serviceParamCodAuxProdutoImpl.findParamCodAuxProduto(prod.getEspecie(), prod.getSubEspecie());
        if (param == null) {
            return;
        }
        String codAux = this.gerarTextoPesquisaCodAuxProduto(param, prod);
        prod.setCodigoAuxiliar(codAux);
        prod.setParamCodAuxProduto(param);
    }

    private String gerarTextoPesquisaCodAuxProduto(ParamCodAuxProduto p, Produto vo) throws ExceptionObjNotFound, ExceptionInvalidData {
        ParamCodAuxProdutoEspecie paramEspecie = this.getParamCodAuxProdutoEspecie(p, vo);
        ParamCodAuxProdutoSubEspecie paramSubEspecie = this.getParamCodAuxProdutoSubEspecie(p, vo);
        StringBuilder sb = new StringBuilder();
        for (TipoParamCodAuxProduto tipoParamCodAux : p.getTipoParamCodAuxProduto()) {
            if (tipoParamCodAux.getTipoVariavelCodAuxProduto().getIdentificador().equals(2L)) {
                sb.append('[').append(tipoParamCodAux.getMascara()).append(']');
                continue;
            }
            String texto = this.getSufixoOrPrefixoFormula(tipoParamCodAux, paramEspecie, paramSubEspecie, vo);
            sb.append(texto);
        }
        return this.gerarCodAuxProduto(sb, p);
    }

    private String gerarCodAuxProduto(StringBuilder sb, ParamCodAuxProduto p) throws ExceptionInvalidData {
        int tamanhoCod = sb.toString().replaceAll("\\" + String.valueOf('['), "").replaceAll("\\" + String.valueOf(']'), "").length();
        StringBuilder tempCod = new StringBuilder();
        char[] data = sb.toString().toCharArray();
        Object tempTokenSeq = "";
        boolean iniciadoTokenSeq = false;
        for (int i = 0; i < data.length; ++i) {
            char currentChar = data[i];
            if ('[' == currentChar) {
                iniciadoTokenSeq = true;
                continue;
            }
            if (iniciadoTokenSeq && ']' == currentChar) {
                int tamanhoToken = ((String)tempTokenSeq).length();
                String prefixo = tempCod.toString();
                String sufixo = i < tamanhoCod ? sb.substring(i) : "";
                tempCod.append(this.getMaxSeqCod(prefixo, sufixo, tamanhoToken, p));
                iniciadoTokenSeq = false;
                tempTokenSeq = "";
                continue;
            }
            if (iniciadoTokenSeq) {
                tempTokenSeq = (String)tempTokenSeq + currentChar;
                continue;
            }
            tempCod.append(currentChar);
        }
        return tempCod.toString();
    }

    private ParamCodAuxProdutoEspecie getParamCodAuxProdutoEspecie(ParamCodAuxProduto p, Produto vo) {
        for (ParamCodAuxProdutoEspecie paramEspecie : p.getEspecies()) {
            if (!paramEspecie.getEspecie().equals((Object)vo.getEspecie())) continue;
            return paramEspecie;
        }
        return null;
    }

    private ParamCodAuxProdutoSubEspecie getParamCodAuxProdutoSubEspecie(ParamCodAuxProduto p, Produto vo) {
        for (ParamCodAuxProdutoSubEspecie paramSubEspecie : p.getSubEspecies()) {
            if (!paramSubEspecie.getSubEspecie().equals((Object)vo.getSubEspecie())) continue;
            return paramSubEspecie;
        }
        return null;
    }

    private String getSufixoOrPrefixoFormula(TipoParamCodAuxProduto t, ParamCodAuxProdutoEspecie paramEspecie, ParamCodAuxProdutoSubEspecie paramSubEspecie, Produto vo) throws ExceptionObjNotFound {
        if (t.getTipoVariavelCodAuxProduto().getIdentificador().equals(1L)) {
            return t.getVariavelFixa();
        }
        if (t.getTipoVariavelCodAuxProduto().getIdentificador().equals(2L)) {
            if (t.getFixo() == 0) {
                return t.getMascara();
            }
            return t.getVariavelFixa();
        }
        if (t.getTipoVariavelCodAuxProduto().getIdentificador().equals(3L)) {
            if (t.getFixo() == 0) {
                if (paramEspecie != null) {
                    return paramEspecie.getConteudo();
                }
                throw new ExceptionObjNotFound(new ExcepCodeDetail("N\u00e3o foi encontrada nenhuma parametriza\u00e7\u00e3o com a Esp\u00e9cie: " + vo.getEspecie().getNome()));
            }
            return t.getVariavelFixa();
        }
        if (t.getTipoVariavelCodAuxProduto().getIdentificador().equals(4L)) {
            if (t.getFixo() == 0) {
                if (paramSubEspecie != null) {
                    return paramSubEspecie.getConteudo();
                }
                throw new ExceptionObjNotFound(new ExcepCodeDetail("N\u00e3o foi encontrada nenhuma parametriza\u00e7\u00e3o com a Subesp\u00e9cie: " + vo.getEspecie().getNome()));
            }
            return t.getVariavelFixa();
        }
        if (t.getTipoVariavelCodAuxProduto().getIdentificador().equals(5L)) {
            TipoCaracteristicaProduto tipo = t.getTipoCaracteristicaProduto();
            for (CaracteristicaProduto c : vo.getCaracteristicasProdutos()) {
                if (!c.getTipoCaracteristicaProduto().equals((Object)tipo)) continue;
                return c.getCodigo();
            }
        }
        return "";
    }

    private String getMaxSeqCod(String prefixo, String sufixo, int tamanhoStrSequencia, ParamCodAuxProduto p) throws ExceptionInvalidData {
        String aux = this.serviceParamCodAuxProdutoImpl.getMaxSeqCodAuxiliarProd(prefixo, sufixo, tamanhoStrSequencia, p);
        if (!TMethods.isStrWithData((String)aux)) {
            aux = this.serviceParamCodAuxProdutoImpl.getMaxSeqCodAuxiliarProd(prefixo, sufixo, tamanhoStrSequencia, p);
        }
        if (!TMethods.isStrWithData((String)aux)) {
            aux = "0";
        }
        if (!TString.isALongNumber((String)aux)) {
            throw new ExceptionInvalidData(EnumExcepInvalidData.DADOS_INVALIDOS, new Object[0]);
        }
        aux = String.valueOf(Long.parseLong(aux) + 1L);
        return ToolFormatter.completaZerosEsquerda((String)aux, (int)tamanhoStrSequencia);
    }
}

