/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.produto;

import com.touchcomp.basementor.constants.enums.entsaida.EnumConstEntSaida;
import com.touchcomp.basementor.constants.enums.receitaagronomica.EnumConstProvedorRecAgro;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemUnidadeMedida;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoAliquotaUF;
import com.touchcomp.basementor.model.vo.SubEspecie;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementorclientwebservices.ccgconsgtin.model.TRetConsGTIN;
import com.touchcomp.basementorclientwebservices.components.DocConsultaCodigoBarras;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jaxb.ExceptionJaxb;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.components.cotacaocompra.CompItemCotacaoCompra;
import com.touchcomp.basementorservice.dao.impl.DaoProdutoImpl;
import com.touchcomp.basementorservice.helpers.impl.produto.HelperProduto;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.converters.DTOClasseCestConverter;
import com.touchcomp.basementorservice.service.converters.DTOClasseEnqIPICodigoConverter;
import com.touchcomp.basementorservice.service.converters.DTONCMCodigoConverter;
import com.touchcomp.basementorservice.service.converters.DTOPlanoContaCodigoConverter;
import com.touchcomp.basementorservice.service.converters.DTOPlanoContaGerCodigoConverter;
import com.touchcomp.basementorservice.service.converters.DTOTipoItemSpedConverter;
import com.touchcomp.basementorservice.service.converters.DTOUnidadeMedidaSiglaConverter;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaoctbrequisicao.ServiceParametrizacaoCtbRequisicaoImpl;
import com.touchcomp.basementorservice.service.impl.produto.DTOProdutoInfoColetorEstoque;
import com.touchcomp.basementorservice.service.impl.produto.ServiceLogProdutoImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoGeraCodAuxiliarImpl;
import com.touchcomp.basementorservice.service.impl.produtograde.ServiceProdutoGradeImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceProduto;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.dtotransfer.ToolDTOBuilder;
import com.touchcomp.basementortools.tools.dtotransfer.conversor.DTOEntityConversor;
import com.touchcomp.touchvomodel.res.DTOProdutoRes;
import com.touchcomp.touchvomodel.temp.informacoescomerciais.DTOInfoComercialProdutoSug;
import com.touchcomp.touchvomodel.vo.cotacaocompra.web.DTOValoresProdutoCotacao;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.springframework.stereotype.Service;

@Service
public class ServiceProdutoImpl
extends ServiceGenericEntityImpl<Produto, Long, DaoProdutoImpl>
implements ServiceProduto {
    final ServiceLogProdutoImpl serviceLogProdutoImpl;
    final ServiceProdutoGradeImpl serviceProdGrade;
    final ServiceLoteFabricacaoImpl serviceLoteFab;
    final ServiceParametrizacaoCtbRequisicaoImpl serviceParametrizacaoCtbRequisicao;
    final ServiceProdutoGeraCodAuxiliarImpl serviceProdutoGeraCodAuxiliar;
    final DTOClasseCestConverter classeCestConverter;
    final DTOClasseEnqIPICodigoConverter classeEnqIPICodigoConverter;
    final DTONCMCodigoConverter classeNCMCodigoConverter;
    final DTOPlanoContaGerCodigoConverter classePlanoContaGerCodigoConverter;
    final DTOUnidadeMedidaSiglaConverter classeUnidadeMedidaSiglaConverter;
    final DTOPlanoContaCodigoConverter classePlanoContaCodigoConverter;
    final DTOTipoItemSpedConverter classeTipoItemSpedConverter;

    public ServiceProdutoImpl(ServiceLogProdutoImpl serviceLogProdutoImpl, ServiceProdutoGradeImpl serviceProdGrade, ServiceLoteFabricacaoImpl serviceLoteFab, ServiceParametrizacaoCtbRequisicaoImpl serviceParametrizacaoCtbRequisicao, ServiceProdutoGeraCodAuxiliarImpl serviceProdutoGeraCodAuxiliar, DTOClasseCestConverter classeCestConverter, DTOClasseEnqIPICodigoConverter classeEnqIPICodigoConverter, DTONCMCodigoConverter classeNCMCodigoConverter, DTOPlanoContaGerCodigoConverter classePlanoContaGerCodigoConverter, DTOUnidadeMedidaSiglaConverter classeUnidadeMedidaSiglaConverter, DTOPlanoContaCodigoConverter classePlanoContaCodigoConverter, DTOTipoItemSpedConverter classeTipoItemSpedConverter, DaoProdutoImpl genericDao) {
        super(genericDao);
        this.serviceLogProdutoImpl = serviceLogProdutoImpl;
        this.serviceProdGrade = serviceProdGrade;
        this.serviceLoteFab = serviceLoteFab;
        this.serviceParametrizacaoCtbRequisicao = serviceParametrizacaoCtbRequisicao;
        this.serviceProdutoGeraCodAuxiliar = serviceProdutoGeraCodAuxiliar;
        this.classeCestConverter = classeCestConverter;
        this.classeEnqIPICodigoConverter = classeEnqIPICodigoConverter;
        this.classeNCMCodigoConverter = classeNCMCodigoConverter;
        this.classePlanoContaGerCodigoConverter = classePlanoContaGerCodigoConverter;
        this.classeUnidadeMedidaSiglaConverter = classeUnidadeMedidaSiglaConverter;
        this.classePlanoContaCodigoConverter = classePlanoContaCodigoConverter;
        this.classeTipoItemSpedConverter = classeTipoItemSpedConverter;
    }

    @Override
    protected void addCustomConverters(ToolDTOBuilder dtoBuilder) {
        dtoBuilder.addDTOConverter((DTOEntityConversor)this.classeCestConverter);
        dtoBuilder.addDTOConverter((DTOEntityConversor)this.classeEnqIPICodigoConverter);
        dtoBuilder.addDTOConverter((DTOEntityConversor)this.classeNCMCodigoConverter);
        dtoBuilder.addDTOConverter((DTOEntityConversor)this.classePlanoContaGerCodigoConverter);
        dtoBuilder.addDTOConverter((DTOEntityConversor)this.classeUnidadeMedidaSiglaConverter);
        dtoBuilder.addDTOConverter((DTOEntityConversor)this.classePlanoContaCodigoConverter);
        dtoBuilder.addDTOConverter((DTOEntityConversor)this.classeTipoItemSpedConverter);
    }

    @Override
    public Map getDadosProdutoPontoEstoque(Long idProduto) {
        return ((DaoProdutoImpl)this.getGenericDao()).getDadosProdutoPontoEstoque(idProduto);
    }

    @Override
    public Produto getByCodigoAuxiliar(String codAux) {
        return ((DaoProdutoImpl)this.getGenericDao()).getByCodigoAuxiliar(codAux);
    }

    public Produto getByCodSincronizacao(String codSincronizacao) {
        return ((DaoProdutoImpl)this.getGenericDao()).getByCodSincronizacao(codSincronizacao);
    }

    @Override
    public Produto getByIdentificadorCastLong(Long idProd) {
        return ((DaoProdutoImpl)this.getGenericDao()).getByIdentificadorCastLong(idProd);
    }

    @Override
    public Produto getByCodigoBarras(String codigo) {
        return ((DaoProdutoImpl)this.getGenericDao()).getByCodigoBarras(codigo);
    }

    public List<Produto> getByCodSincronizacao(String codSincronizacao, EnumConstProvedorRecAgro enumConstProvedorRecAgro) {
        return ((DaoProdutoImpl)this.getGenericDao()).getByCodSincronizacao(codSincronizacao, enumConstProvedorRecAgro);
    }

    public List<Produto> getAllCodSincronizacao(EnumConstProvedorRecAgro enumConstProvedorRecAgro) {
        return ((DaoProdutoImpl)this.getGenericDao()).getAllCodSincronizacao(enumConstProvedorRecAgro);
    }

    public List<Produto> getByIdentificadorProdutoAndCodigoAuxiliar(Long idProd, String codAux) {
        return ((DaoProdutoImpl)this.getGenericDao()).getByIdentificadorProdutoAndCodigoAuxiliar(idProd, codAux);
    }

    public List<Produto> getProdutosAltCriados(Date lastDateSync, Long idGrupo) {
        return ((DaoProdutoImpl)this.getDao()).getProdutosAltCriadas(lastDateSync, idGrupo);
    }

    public List<DTOProdutoRes> getProdutos(String strTyped, Short usarId, Short usarCodAux, boolean useIlike) {
        return ((DaoProdutoImpl)this.getDao()).getProdutos(strTyped, usarId, usarCodAux, useIlike);
    }

    public DTOProdutoRes getByCodigoBarrasRes(String codigoBarras) {
        Produto prod = this.getByCodigoBarras(codigoBarras);
        if (prod == null) {
            return null;
        }
        DTOProdutoRes ret = new DTOProdutoRes();
        ret.setCodigoAuxiliar(prod.getCodigoAuxiliar());
        ret.setIdentificador(prod.getIdentificador());
        ret.setNome(prod.getNome());
        ret.setUnidadeMedidaSigla(prod.getUnidadeMedida().getSigla());
        return ret;
    }

    public TRetConsGTIN consultarCodigoBarras(String codigoBarras, ConfiguracaoCertificado configuracoesCertificado) throws ExceptionCertificado, ExceptionJaxb, ExceptionIO, XMLStreamException, RemoteException {
        DocConsultaCodigoBarras docConsultaCodigoBarras = (DocConsultaCodigoBarras)Context.get(DocConsultaCodigoBarras.class);
        return docConsultaCodigoBarras.consultaCodigoBarras(codigoBarras, configuracoesCertificado);
    }

    public List<Produto> getByCodSincronizacaoLike(String codSincronizacao) {
        return ((DaoProdutoImpl)this.getGenericDao()).getByCodSincronizacaoLike(codSincronizacao);
    }

    public List<DTOProdutoRes> getProdutosSaida(String text) {
        return this.getProdutos(text, EnumConstEntSaida.SAIDA);
    }

    public List<DTOProdutoRes> getProdutos(String text) {
        return this.getProdutos(text, null);
    }

    public List<DTOProdutoRes> getProdutos(String text, EnumConstEntSaida entSai) {
        if (text == null || text.length() > 115) {
            return new LinkedList<DTOProdutoRes>();
        }
        if (text.length() < 3) {
            return new LinkedList<DTOProdutoRes>();
        }
        return ((DaoProdutoImpl)this.getDao()).getProdutos(text, entSai);
    }

    @Override
    public Produto beforeSaveEntity(Produto produto) {
        try {
            for (ProdutoAliquotaUF aux : produto.getAliquotasUF()) {
                aux.setProduto(produto);
            }
            for (ProdutoAliquotaUF aux : produto.getCategoriasProduto()) {
                aux.setProduto(produto);
            }
            for (ProdutoAliquotaUF aux : produto.getCodigoBarras()) {
                aux.setProduto(produto);
            }
            for (ProdutoAliquotaUF aux : produto.getItemUnidadeMedida()) {
                aux.setProduto(produto);
            }
            for (ProdutoAliquotaUF aux : produto.getModeloFiscal()) {
                aux.setProduto(produto);
            }
            this.serviceProdutoGeraCodAuxiliar.gerarCodigoAuxiliar(produto);
            Produto old = (Produto)this.get(produto.getIdentificador());
            ((DaoProdutoImpl)this.getDao()).evict(old);
            this.serviceLogProdutoImpl.avaliarCriarLog(old, produto);
            return produto;
        }
        catch (ExceptionInvalidData | ExceptionObjNotFound ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase(ex.getFormattedMessage(), ex);
        }
    }

    @Override
    public Produto afterSaveEntity(Produto entity) {
        this.serviceLoteFab.avaliarCriarLoteFab(entity);
        this.serviceProdGrade.avaliarCriarGradeProduto(entity);
        return entity;
    }

    public List<ItemUnidadeMedida> getItensUnidMedidasAtivoUnProd(Long idProduto) {
        Produto produto = (Produto)this.get(idProduto);
        if (produto != null) {
            HelperProduto helperProduto = new HelperProduto().build(produto);
            return helperProduto.getItensUnidMedidasAtivoUnProd();
        }
        return new ArrayList<ItemUnidadeMedida>();
    }

    public UnidadeMedida getUnidadeMedidaPrincipalProduto(Long idProduto) throws ExceptionObjNotFound {
        Produto produto = (Produto)this.getOrThrow(idProduto);
        if (produto != null) {
            return produto.getUnidadeMedida();
        }
        return null;
    }

    public List<GradeCor> getGradeCoresAtivas(Long idProduto) {
        Produto produto = (Produto)this.get(idProduto);
        if (produto != null) {
            HelperProduto helperProduto = new HelperProduto().build(produto);
            return helperProduto.getGradeCoresAtivas();
        }
        return new ArrayList<GradeCor>();
    }

    public List<NaturezaRequisicao> getItensNaturezaReqProd(Long idProduto, Empresa empresa) {
        Produto produto = (Produto)this.get(idProduto);
        if (produto != null) {
            HelperProduto helperProduto = new HelperProduto().build(produto);
            return helperProduto.getItensNaturezaReqProd(this.serviceParametrizacaoCtbRequisicao.getAll(produto, empresa));
        }
        return new ArrayList<NaturezaRequisicao>();
    }

    public DTOValoresProdutoCotacao getValoresAtualizadosProdCotacao(Long identificador, Empresa empresa) {
        DTOValoresProdutoCotacao dto = new DTOValoresProdutoCotacao();
        if (identificador == null) {
            return dto;
        }
        Produto produto = (Produto)this.get(identificador);
        if (produto != null) {
            CompItemCotacaoCompra compItemCotacaoCompra = (CompItemCotacaoCompra)ConfApplicationContext.getBean(CompItemCotacaoCompra.class);
            dto = compItemCotacaoCompra.findValoresProduto(produto, empresa);
        }
        return dto;
    }

    public DTOProdutoInfoColetorEstoque getInfoProdGradeLoteFabColetor(String informacoesProd, Long idGradeCor, Long idLoteFab, Empresa empresa) {
        return ((DaoProdutoImpl)this.getDao()).getInfoProdGradeLoteFabColetor(informacoesProd, idGradeCor, idLoteFab, this.getSharedData().getOpcoesFaturamento(empresa).getUsarIdProduto(), this.getSharedData().getOpcoesFaturamento(empresa).getUsarCodigoAuxProduto());
    }

    public void limparCodAuxProdutos() {
        ((DaoProdutoImpl)this.getGenericDao()).limparCodAuxProdutos();
    }

    @Override
    public List<Produto> get(SubEspecie sub) {
        return ((DaoProdutoImpl)this.getDao()).get(sub);
    }

    public List<DTOInfoComercialProdutoSug> getProdutosSugeridos(List<Long> ids) {
        return ((DaoProdutoImpl)this.getDao()).getProdutosSugeridos(ids);
    }

    public List<String> getCodigosAuxProdSalvos() {
        return ((DaoProdutoImpl)this.getDao()).getCodigosAuxProdSalvos();
    }
}

