/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.produtograde;

import com.touchcomp.basementor.model.vo.Cor;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoGrade;
import com.touchcomp.basementorservice.dao.impl.DaoProdutoGradeImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import java.util.Date;
import org.springframework.stereotype.Service;

@Service
public class ServiceProdutoGradeImpl
extends ServiceGenericEntityImpl<ProdutoGrade, Long, DaoProdutoGradeImpl> {
    public ServiceProdutoGradeImpl(DaoProdutoGradeImpl repository) {
        super(repository);
    }

    public void criarGradeUnicaProduto(Empresa empresa, Cor cor) {
        ((DaoProdutoGradeImpl)this.getGenericDao()).criarGradeUnicaProduto(empresa, cor);
    }

    @Override
    public ProdutoGrade beforeSave(ProdutoGrade vo) {
        for (GradeCor gradesCore : vo.getGradesCores()) {
            if (!this.isNull(gradesCore.getCodigoBarras()).booleanValue() && gradesCore.getCodigoBarras().trim().isEmpty()) {
                gradesCore.setCodigoBarras(null);
            }
            gradesCore.setProdutoGrade(vo);
        }
        return vo;
    }

    public void avaliarCriarGradeProduto(Produto prod) {
        OpcoesFaturamento opcoes = this.getSharedData().getOpcoesFaturamento(prod.getEmpresa());
        if (opcoes == null || !this.isAffimative(opcoes.getUsarGradeUnica())) {
            return;
        }
        if (!this.isAffimative(prod.getAtivo())) {
            return;
        }
        ProdutoGrade pg = this.getProdutoGrade(prod);
        if (pg == null) {
            pg = new ProdutoGrade();
            pg.setDataCadastro(new Date());
            pg.setEmpresa(prod.getEmpresa());
            pg.setProduto(prod);
            pg.setDataUltModificacao(new Date());
            GradeCor g = new GradeCor();
            g.setCor(opcoes.getCor());
            g.setGradePrincipal(Short.valueOf((short)0));
            g.setAtivo(Short.valueOf((short)1));
            g.setProdutoGrade(pg);
            pg.getGradesCores().add(g);
            this.saveOrUpdate(pg);
        }
    }

    private ProdutoGrade getProdutoGrade(Produto prod) {
        return ((DaoProdutoGradeImpl)this.getDao()).getProdutoGrade(prod);
    }
}

