/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.produtossimilares;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoGrade;
import com.touchcomp.basementor.model.vo.ProdutosSimilares;
import com.touchcomp.basementor.model.vo.ProdutosSimilaresItens;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoProdutosSimilaresImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.produto.web.DTOProdutoSubstituto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceProdutosSimilaresImpl
extends ServiceGenericEntityImpl<ProdutosSimilares, Long, DaoProdutosSimilaresImpl> {
    @Autowired
    ServiceProdutoImpl serviceProduto;

    @Autowired
    public ServiceProdutosSimilaresImpl(DaoProdutosSimilaresImpl genericDao) {
        super(genericDao);
    }

    public List<ProdutosSimilares> get(Produto prod, Empresa empresa) {
        return ((DaoProdutosSimilaresImpl)this.getDao()).get(prod, empresa);
    }

    public ProdutosSimilares getOne(Produto prod, Empresa empresa) {
        return ((DaoProdutosSimilaresImpl)this.getDao()).getOne(prod, empresa);
    }

    @Override
    public ProdutosSimilares beforeSave(ProdutosSimilares vo) {
        if (vo.getProdutosSimilaresEmp() != null) {
            vo.getProdutosSimilaresEmp().forEach(it -> it.setProdutosSimilares(vo));
        }
        if (vo.getProdutosSimilaresItens() != null) {
            vo.getProdutosSimilaresItens().forEach(it -> it.setProdutosSimilares(vo));
        }
        return vo;
    }

    public List<DTOProdutoSubstituto> getProdutosSubstitutos(Long produto, Empresa empresa) throws ExceptionObjNotFound {
        Produto vo = (Produto)this.serviceProduto.getOrThrow(produto);
        return this.getProdutosSubstitutos(vo, empresa);
    }

    public List<DTOProdutoSubstituto> getProdutosSubstitutos(Produto produto, Empresa empresa) {
        ArrayList<DTOProdutoSubstituto> ret = new ArrayList<DTOProdutoSubstituto>();
        List<ProdutosSimilares> produtosSubstitutos = this.get(produto, empresa);
        if (TMethods.isWithData(produtosSubstitutos)) {
            for (ProdutosSimilares ps : produtosSubstitutos) {
                if (!TMethods.isWithData((Collection)ps.getProdutosSimilaresItens())) continue;
                for (ProdutosSimilaresItens psi : ps.getProdutosSimilaresItens()) {
                    if (this.isNull(psi.getProduto()).booleanValue() || !TMethods.isWithData((Collection)psi.getProduto().getGradesProduto())) continue;
                    for (ProdutoGrade pg : psi.getProduto().getGradesProduto()) {
                        if (this.isEquals(psi.getProduto(), produto) || !TMethods.isWithData((Collection)pg.getGradesCores())) continue;
                        for (GradeCor gc : pg.getGradesCores()) {
                            DTOProdutoSubstituto dto = new DTOProdutoSubstituto();
                            dto.setCodigoAuxiliarProdutoSimilar(gc.getProdutoGrade().getProduto().getCodigoAuxiliar());
                            dto.setIdentificadorProdutoSimilar(gc.getProdutoGrade().getProduto().getIdentificador());
                            dto.setNomeProdutoProdutoSimilar(gc.getProdutoGrade().getProduto().getNome());
                            dto.setUnidadeMedidaProdutoSimilar(gc.getProdutoGrade().getProduto().getUnidadeMedida().getSigla());
                            dto.setIdentificadorGradeCor(gc.getIdentificador());
                            dto.setDescricaoGradeCor(gc.toString());
                            ret.add(dto);
                        }
                    }
                }
            }
        }
        return ret;
    }
}

