/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.projeto;

import com.touchcomp.basementor.model.vo.PrioridadeMarketing;
import com.touchcomp.basementor.model.vo.Projeto;
import com.touchcomp.basementor.model.vo.ProjetoParticipante;
import com.touchcomp.basementor.model.vo.ProjetoTarefa;
import com.touchcomp.basementor.model.vo.ProjetoTarefaHist;
import com.touchcomp.basementorservice.service.impl.prioridademarketing.ServicePrioridadeMarketingImpl;
import com.touchcomp.basementorservice.service.impl.projeto.ServiceProjetoParticipanteImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class AuxProjeto {
    final ServicePrioridadeMarketingImpl servicePrioridadeMarketingImpl;
    final ServiceProjetoParticipanteImpl serviceProjetoParticipanteImpl;

    public AuxProjeto(ServicePrioridadeMarketingImpl servicePrioridadeMarketingImpl, ServiceProjetoParticipanteImpl serviceProjetoParticipanteImpl) {
        this.servicePrioridadeMarketingImpl = servicePrioridadeMarketingImpl;
        this.serviceProjetoParticipanteImpl = serviceProjetoParticipanteImpl;
    }

    void buildHistorico(Projeto aux, List<Map> tarefas) {
        for (ProjetoTarefa tarefa : aux.getTarefas()) {
            Optional<Map> found = tarefas.stream().filter(i -> ToolMethods.isEquals(i.get("F_IDENTIFICADOR"), (Object)tarefa.getIdentificador())).findFirst();
            if (found.isPresent()) {
                this.createLog(aux, tarefa, found.get());
                continue;
            }
            this.createLog(aux, tarefa, new HashMap());
        }
    }

    private void createLog(Projeto aux, ProjetoTarefa tarefa, Map map) {
        Date dataIn = (Date)map.get("F_DATA_INICIAL");
        Date dataFinal = (Date)map.get("F_DATA_FINAL");
        Long idPrioridade = (Long)map.get("F_ID_PRIORIDADE");
        Long idParticipante = (Long)map.get("F_ID_PARTICIPANTE_RESPONSAVEL");
        if (!ToolMethods.isEquals((Object)ToolDate.dataSemHora((Date)dataIn), (Object)ToolDate.dataSemHora((Date)tarefa.getDataInicial()))) {
            this.createLog(aux, tarefa, dataIn, dataFinal, idPrioridade, idParticipante);
        }
        if (!ToolMethods.isEquals((Object)ToolDate.dataSemHora((Date)dataFinal), (Object)ToolDate.dataSemHora((Date)tarefa.getDataFinal()))) {
            this.createLog(aux, tarefa, dataIn, dataFinal, idPrioridade, idParticipante);
        }
        if (tarefa.getPrioridadeTarefa() != null && !ToolMethods.isEquals((Object)idPrioridade, (Object)tarefa.getPrioridadeTarefa().getIdentificador())) {
            this.createLog(aux, tarefa, dataIn, dataFinal, idPrioridade, idParticipante);
        }
        if (tarefa.getParticipanteResponsavel() != null && !ToolMethods.isEquals((Object)idParticipante, (Object)tarefa.getParticipanteResponsavel().getIdentificador())) {
            this.createLog(aux, tarefa, dataIn, dataFinal, idPrioridade, idParticipante);
        }
    }

    private void createLog(Projeto aux, ProjetoTarefa tarefa, Date dataIn, Date dataFim, Long idPrioridade, Long idParticipante) {
        ProjetoTarefaHist pa = new ProjetoTarefaHist();
        pa.setDataInicial(dataIn);
        pa.setDataFinal(dataFim);
        pa.setPrioridadeTarefa((PrioridadeMarketing)this.servicePrioridadeMarketingImpl.get(idPrioridade));
        pa.setDescricao(tarefa.getDescricao());
        pa.setObservacao(tarefa.getObservacao());
        pa.setProjetoTarefa(tarefa);
        pa.setUsuario(aux.getUsuarioUltAlteracao());
        pa.setDataAlteracao(new Date());
        pa.setParticipanteResponsavel((ProjetoParticipante)this.serviceProjetoParticipanteImpl.get(idParticipante));
        tarefa.getHistoricoTarefa().add(pa);
    }
}

