/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.projeto;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.vo.LogStatusProjeto;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Projeto;
import com.touchcomp.basementor.model.vo.ProjetoParticipante;
import com.touchcomp.basementor.model.vo.ProjetoRecursos;
import com.touchcomp.basementor.model.vo.ProjetoTarefa;
import com.touchcomp.basementor.model.vo.ProjetoTarefaDep;
import com.touchcomp.basementor.model.vo.ProjetoTarefaRecurso;
import com.touchcomp.basementor.model.vo.SubprojetoTarefasStat;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoProjetoImpl;
import com.touchcomp.basementorservice.helpers.impl.projeto.HelperProjeto;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementorservice.service.impl.prioridademarketing.ServicePrioridadeMarketingImpl;
import com.touchcomp.basementorservice.service.impl.projeto.AuxProjeto;
import com.touchcomp.basementorservice.service.impl.projeto.ServiceProjetoParticipanteImpl;
import com.touchcomp.basementorservice.service.impl.subprojetotarefasstat.ServiceSubprojetoTarefasStatImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.projeto.web.DTOProjeto;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class ServiceProjetoImpl
extends ServiceGenericEntityImpl<Projeto, Long, DaoProjetoImpl> {
    private final ServiceSubprojetoTarefasStatImpl serviceSubProjetoStatus;
    private final ServicePessoaImpl servicePessoa;
    private final HelperProjeto helperProjeto;
    private final ServicePrioridadeMarketingImpl servicePrioridadeMarketingImpl;
    private final ServiceProjetoParticipanteImpl serviceProjetoParticipanteImpl;

    public ServiceProjetoImpl(ServiceSubprojetoTarefasStatImpl serviceSubProjetoStatus, ServicePessoaImpl servicePessoa, HelperProjeto helperProjeto, ServicePrioridadeMarketingImpl servicePrioridadeMarketingImpl, ServiceProjetoParticipanteImpl serviceProjetoParticipanteImpl, DaoProjetoImpl genericDao) {
        super(genericDao);
        this.serviceSubProjetoStatus = serviceSubProjetoStatus;
        this.servicePessoa = servicePessoa;
        this.helperProjeto = helperProjeto;
        this.servicePrioridadeMarketingImpl = servicePrioridadeMarketingImpl;
        this.serviceProjetoParticipanteImpl = serviceProjetoParticipanteImpl;
    }

    public DTOProjeto.DTOProjetoParticipante newItemParticipante(Long idPessoa) throws ExceptionObjNotFound {
        Pessoa pessoa = (Pessoa)this.servicePessoa.get(idPessoa);
        if (this.isNull(pessoa).booleanValue()) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0047.004", new Object[]{idPessoa}));
        }
        ProjetoParticipante i = new ProjetoParticipante();
        i.setParticipante(pessoa);
        return this.buildToDTOGeneric(i, DTOProjeto.DTOProjetoParticipante.class);
    }

    public DTOProjeto processarProjeto(DTOProjeto input) {
        Projeto t = (Projeto)this.buildToEntity(input);
        this.helperProjeto.build(t).processarProjeto();
        return this.buildToDTO(t, DTOProjeto.class);
    }

    @Override
    public Projeto beforeSave(Projeto aux) {
        List<SubprojetoTarefasStat> status = this.serviceSubProjetoStatus.getStatus();
        for (ProjetoRecursos recurso : aux.getRecursos()) {
            recurso.setProjeto(aux);
        }
        for (LogStatusProjeto log : aux.getLogsProjeto()) {
            log.setProjeto(aux);
        }
        for (ProjetoParticipante part : aux.getParticipantesProjeto()) {
            part.setProjeto(aux);
        }
        this.helperProjeto.build(aux).calcPercProjeto();
        for (ProjetoTarefa tarefa : aux.getTarefas()) {
            Optional<SubprojetoTarefasStat> fStatus;
            Optional<ProjetoRecursos> foundRec;
            Optional<ProjetoParticipante> foundResponsavel;
            tarefa.setProjeto(aux);
            Optional<ProjetoTarefa> found = aux.getTarefas().stream().filter(i -> this.isEquals(i.getCodigoTarefa(), tarefa.getCodigoTarefaVinculada())).findFirst();
            if (found.isPresent()) {
                tarefa.setTarefaVinculada(found.get());
            }
            if ((foundResponsavel = aux.getParticipantesProjeto().stream().filter(i -> this.isEquals(i.getCodParticipanteResponsavel(), tarefa.getCodParticipanteResponsavel())).findFirst()).isPresent()) {
                tarefa.setParticipanteResponsavel(foundResponsavel.get());
            }
            for (ProjetoTarefaRecurso pt : tarefa.getProjetoTarefaRecurso()) {
                foundRec = aux.getRecursos().stream().filter(i -> this.isEquals(i.getCodigoRecurso(), pt.getCodigoRecurso())).findFirst();
                if (foundRec.isPresent()) {
                    pt.setProjetoRecursos(foundRec.get());
                }
                pt.setProjetoTarefa(tarefa);
            }
            for (ProjetoTarefaRecurso pt : tarefa.getTarefasDependentes()) {
                foundRec = aux.getTarefas().stream().filter(arg_0 -> this.lambda$beforeSave$3((ProjetoTarefaDep)pt, arg_0)).findFirst();
                if (foundRec.isPresent()) {
                    pt.setProjetoTarefaDependente((ProjetoTarefa)foundRec.get());
                }
                pt.setProjetoTarefa(tarefa);
            }
            if ((tarefa.getStatusTarefa() == null || tarefa.getPercentualAndamento() > 0.0) && (fStatus = status.stream().filter(i -> i.getValorMaximo() >= 0.0 && ToolMethods.isBetween((Double)tarefa.getPercentualAndamento(), (Double)i.getValorMinimo(), (Double)i.getValorMaximo())).findFirst()).isPresent()) {
                tarefa.setStatusTarefa(fStatus.get());
            }
            if (tarefa.getStatusTarefa() == null || !(tarefa.getStatusTarefa().getPercConclusao() < 0.0)) continue;
            tarefa.setPercentualAndamento(tarefa.getStatusTarefa().getPercConclusao());
        }
        new AuxProjeto(this.servicePrioridadeMarketingImpl, this.serviceProjetoParticipanteImpl).buildHistorico(aux, ((DaoProjetoImpl)this.getDao()).getTarefas(aux));
        this.helperProjeto.build(aux).setMarcaTarefasProjeto();
        this.helperProjeto.build(aux).processarProjeto();
        this.helperProjeto.build(aux).ordenarTarefasProjeto();
        this.helperProjeto.build(aux).calcularDiasTarefa();
        return super.beforeSave(aux);
    }

    @Override
    public Projeto beforeSaveEntity(Projeto entity) {
        this.helperProjeto.build(entity).ordenarTarefasProjeto();
        return entity;
    }

    public Integer showTarefas(Long idProjeto) {
        Projeto projeto = (Projeto)this.get(idProjeto);
        if (this.isNull(projeto).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1266.001", new Object[]{idProjeto}));
        }
        return (int)projeto.getTarefas().stream().filter(i -> this.isEquals(i.getMarca(), EnumConstSinteticoAnalitico.ANALITICO.getValue())).count();
    }

    public Double showPercentual(Long idProjeto) {
        Projeto projeto = (Projeto)this.get(idProjeto);
        if (this.isNull(projeto).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1266.001", new Object[]{idProjeto}));
        }
        Double percentual = 0.0;
        if (!projeto.getTarefas().isEmpty()) {
            for (ProjetoTarefa p : projeto.getTarefas()) {
                if (!this.isEquals(p.getMarca(), EnumConstSinteticoAnalitico.ANALITICO.getValue())) continue;
                percentual = percentual + p.getPercentualAndamento();
            }
            int totalAnalitico = (int)projeto.getTarefas().stream().filter(i -> this.isEquals(i.getMarca(), EnumConstSinteticoAnalitico.ANALITICO.getValue())).count();
            return totalAnalitico > 0 ? percentual / (double)totalAnalitico : 0.0;
        }
        return 0.0;
    }

    public List<DTOProjeto.DTOProjetoTarefa> showTarefasConcluidas(Long idProjeto) {
        Projeto projeto = (Projeto)this.get(idProjeto);
        if (this.isNull(projeto).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1266.001", new Object[]{idProjeto}));
        }
        Double concluido = 100.0;
        ArrayList<DTOProjeto.DTOProjetoTarefa> dto = new ArrayList<DTOProjeto.DTOProjetoTarefa>();
        for (ProjetoTarefa p : projeto.getTarefas()) {
            if (p == null || !this.isEquals(p.getPercentualAndamento(), concluido) || !this.isEquals(p.getMarca(), EnumConstSinteticoAnalitico.ANALITICO.getValue())) continue;
            DTOProjeto.DTOProjetoTarefa DTOProjetoTarefa2 = new DTOProjeto.DTOProjetoTarefa();
            DTOProjetoTarefa2.setIdentificador(p.getIdentificador());
            DTOProjetoTarefa2.setDescricao(p.getDescricao());
            DTOProjetoTarefa2.setCodigoTarefa(p.getCodigoTarefa());
            DTOProjetoTarefa2.setDataInicial(p.getDataInicial());
            DTOProjetoTarefa2.setDataFinal(p.getDataFinal());
            DTOProjetoTarefa2.setIndice(p.getIndice());
            dto.add(DTOProjetoTarefa2);
        }
        return dto;
    }

    public List<DTOProjeto.DTOProjetoTarefa> showTarefasNaoConcluidas(Long idProjeto) {
        Projeto projeto = (Projeto)this.get(idProjeto);
        if (this.isNull(projeto).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1266.001", new Object[]{idProjeto}));
        }
        ArrayList<DTOProjeto.DTOProjetoTarefa> dto = new ArrayList<DTOProjeto.DTOProjetoTarefa>();
        Double concluido = 100.0;
        for (ProjetoTarefa p : projeto.getTarefas()) {
            if (this.isEquals(p.getPercentualAndamento(), concluido) || !(p.getPercentualAndamento() >= 0.0) || !this.isEquals(p.getMarca(), EnumConstSinteticoAnalitico.ANALITICO.getValue())) continue;
            DTOProjeto.DTOProjetoTarefa DTOProjetoTarefa2 = new DTOProjeto.DTOProjetoTarefa();
            DTOProjetoTarefa2.setIdentificador(p.getIdentificador());
            DTOProjetoTarefa2.setDescricao(p.getDescricao());
            DTOProjetoTarefa2.setPercentualAndamento(p.getPercentualAndamento());
            DTOProjetoTarefa2.setStatusTarefa(p.getStatusTarefa().getDescricao());
            DTOProjetoTarefa2.setStatusTarefaIdentificador(p.getStatusTarefa().getIdentificador());
            DTOProjetoTarefa2.setIndice(p.getIndice());
            dto.add(DTOProjetoTarefa2);
        }
        return dto;
    }

    public List<DTOProjeto.DTOProjetoTarefa> showTarefasEmAtraso(Long idProjeto) {
        Projeto projeto = (Projeto)this.get(idProjeto);
        if (this.isNull(projeto).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1266.001", new Object[]{idProjeto}));
        }
        ArrayList<DTOProjeto.DTOProjetoTarefa> dto = new ArrayList<DTOProjeto.DTOProjetoTarefa>();
        Double concluido = 100.0;
        for (ProjetoTarefa p : projeto.getTarefas()) {
            if (!p.getDataFinal().before(new Date()) || this.isEquals(p.getPercentualAndamento(), concluido) || !(p.getPercentualAndamento() >= 0.0) || !this.isEquals(p.getMarca(), EnumConstSinteticoAnalitico.ANALITICO.getValue())) continue;
            DTOProjeto.DTOProjetoTarefa DTOProjetoTarefa2 = new DTOProjeto.DTOProjetoTarefa();
            DTOProjetoTarefa2.setIdentificador(p.getIdentificador());
            DTOProjetoTarefa2.setDescricao(p.getDescricao());
            DTOProjetoTarefa2.setCodigoTarefa(p.getCodigoTarefa());
            DTOProjetoTarefa2.setStatusTarefa(p.getStatusTarefa().getDescricao());
            DTOProjetoTarefa2.setStatusTarefaIdentificador(p.getStatusTarefa().getIdentificador());
            DTOProjetoTarefa2.setDataInicial(p.getDataInicial());
            DTOProjetoTarefa2.setDataFinal(p.getDataFinal());
            DTOProjetoTarefa2.setIndice(p.getIndice());
            dto.add(DTOProjetoTarefa2);
        }
        return dto;
    }

    public List<DTOProjeto.DTOProjetoTarefa> showTarefasDesistidas(Long idProjeto) {
        Projeto projeto = (Projeto)this.get(idProjeto);
        if (this.isNull(projeto).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1266.001", new Object[]{idProjeto}));
        }
        ArrayList<DTOProjeto.DTOProjetoTarefa> dto = new ArrayList<DTOProjeto.DTOProjetoTarefa>();
        for (ProjetoTarefa p : projeto.getTarefas()) {
            if (!(p.getPercentualAndamento() < 0.0) || !this.isEquals(p.getMarca(), EnumConstSinteticoAnalitico.ANALITICO.getValue())) continue;
            DTOProjeto.DTOProjetoTarefa DTOProjetoTarefa2 = new DTOProjeto.DTOProjetoTarefa();
            DTOProjetoTarefa2.setIdentificador(p.getIdentificador());
            DTOProjetoTarefa2.setDescricao(p.getDescricao());
            DTOProjetoTarefa2.setCodigoTarefa(p.getCodigoTarefa());
            DTOProjetoTarefa2.setPercentualAndamento(p.getPercentualAndamento());
            DTOProjetoTarefa2.setStatusTarefa(p.getStatusTarefa().getDescricao());
            DTOProjetoTarefa2.setStatusTarefaIdentificador(p.getStatusTarefa().getIdentificador());
            DTOProjetoTarefa2.setDataInicial(p.getDataInicial());
            DTOProjetoTarefa2.setDataFinal(p.getDataFinal());
            DTOProjetoTarefa2.setIndice(p.getIndice());
            dto.add(DTOProjetoTarefa2);
        }
        return dto;
    }

    private /* synthetic */ boolean lambda$beforeSave$3(ProjetoTarefaDep pt, ProjetoTarefa i) {
        return this.isEquals(i.getCodigoTarefa(), pt.getCodTarefaDependente());
    }
}

