/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.propostacomercial;

import com.touchcomp.basementor.model.vo.ItemModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.PropComercialModFichaTec;
import com.touchcomp.basementor.model.vo.PropComercialModFichaTecItem;
import com.touchcomp.basementor.model.vo.PropComercialPessoa;
import com.touchcomp.basementor.model.vo.PropostaComercial;
import com.touchcomp.basementor.model.vo.ProspPessoasModFichaTec;
import com.touchcomp.basementor.model.vo.ProspPessoasModFichaTecItem;
import com.touchcomp.basementor.model.vo.ProspeccaoPessoas;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoPropostaComercialImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.modelofichatecnica.ServiceModeloFichaTecnicaImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementorservice.service.impl.prospeccaopessoas.ServiceProspeccaoPessoasImpl;
import com.touchcomp.touchvomodel.vo.propcomercialmodfichatec.web.DTOPropComercialModFichaTec;
import com.touchcomp.touchvomodel.vo.propcomercialpessoa.web.DTOPropComercialPessoa;
import com.touchcomp.touchvomodel.vo.propostacomercial.web.DTOPropostaComercial;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServicePropostaComercialImpl
extends ServiceGenericEntityImpl<PropostaComercial, Long, DaoPropostaComercialImpl> {
    @Autowired
    ServicePessoaImpl servicePessoaImpl;
    @Autowired
    ServiceModeloFichaTecnicaImpl serviceModeloFichaTecnicaImpl;
    @Autowired
    ServiceProspeccaoPessoasImpl serviceProspeccaoPessoasImp;

    @Autowired
    public ServicePropostaComercialImpl(DaoPropostaComercialImpl dao) {
        super(dao);
    }

    @Override
    public PropostaComercial beforeSaveEntity(PropostaComercial vo) {
        vo.getIndicantes().forEach(i -> i.setPropostaComercial(vo));
        vo.getItensProposta().forEach(i -> i.setPropostaComercial(vo));
        vo.getPropComercialModFichaTec().forEach(i -> {
            i.setPropComercial(vo);
            i.getItensModFichaTecnica().forEach(mft -> mft.setPropComercialModFichaTec(i));
        });
        return vo;
    }

    public List<DTOPropComercialPessoa> getPropComercialPessoa(Long[] ids) {
        List pessoas = this.servicePessoaImpl.gets(ids);
        List PropComercialPessoa2 = pessoas.stream().map(i -> {
            PropComercialPessoa item = new PropComercialPessoa();
            item.setPessoa(i);
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(PropComercialPessoa2, DTOPropComercialPessoa.class);
    }

    public List<DTOPropComercialModFichaTec> getPropComercialModFichaTec(Long[] ids) {
        List modeloFichaTecnicas = this.serviceModeloFichaTecnicaImpl.gets(ids);
        ArrayList<PropComercialModFichaTec> listPropComercialModFichaTec = new ArrayList<PropComercialModFichaTec>();
        for (ModeloFichaTecnica modeloFicha : modeloFichaTecnicas) {
            PropComercialModFichaTec propComercialModFichaTec = new PropComercialModFichaTec();
            propComercialModFichaTec.setModeloFichaTecnica(modeloFicha);
            ArrayList<PropComercialModFichaTecItem> listPropComercialModFichaTecItem = new ArrayList<PropComercialModFichaTecItem>();
            for (ItemModeloFichaTecnica itemModelo : modeloFicha.getItensModeloFichaTecnica()) {
                PropComercialModFichaTecItem propComercialModFichaTecItem = new PropComercialModFichaTecItem();
                propComercialModFichaTecItem.setItensModeloFichaTecnica(itemModelo);
                propComercialModFichaTecItem.setPropComercialModFichaTec(propComercialModFichaTec);
                propComercialModFichaTecItem.setChave(itemModelo.getDescricao());
                propComercialModFichaTecItem.setValorObrigatorio(itemModelo.getCampoObrigatorio());
                listPropComercialModFichaTecItem.add(propComercialModFichaTecItem);
            }
            propComercialModFichaTec.setItensModFichaTecnica(listPropComercialModFichaTecItem);
            listPropComercialModFichaTec.add(propComercialModFichaTec);
        }
        return this.buildToDTOGeneric(listPropComercialModFichaTec, DTOPropComercialModFichaTec.class);
    }

    public DTOPropostaComercial getProspecaoPessoas(Long idProspecaoPessoa, DTOPropostaComercial input) throws ExceptionObjNotFound {
        PropostaComercial vo = (PropostaComercial)this.buildToEntity(input);
        ProspeccaoPessoas prospeccaoPessoas = (ProspeccaoPessoas)this.serviceProspeccaoPessoasImp.getOrThrow(idProspecaoPessoa);
        ArrayList<PropComercialModFichaTec> listPropComercialModFichaTec = new ArrayList<PropComercialModFichaTec>();
        vo.setPessoa(prospeccaoPessoas.getPessoa());
        vo.setRepresentante(prospeccaoPessoas.getRepresentante());
        vo.setObservacao(prospeccaoPessoas.getObservacao());
        List propComercialPessoa = prospeccaoPessoas.getIndicantes().stream().map(i -> {
            PropComercialPessoa item = new PropComercialPessoa();
            item.setPessoa(i.getPessoa());
            return item;
        }).collect(Collectors.toList());
        vo.setIndicantes(propComercialPessoa);
        for (ProspPessoasModFichaTec prospPessoasModFichaTec : prospeccaoPessoas.getProspPessoasModFichaTec()) {
            PropComercialModFichaTec propComercialModFichaTec = new PropComercialModFichaTec();
            propComercialModFichaTec.setModeloFichaTecnica(prospPessoasModFichaTec.getModeloFichaTecnica());
            ArrayList<PropComercialModFichaTecItem> listPropComercialModFichaTecItem = new ArrayList<PropComercialModFichaTecItem>();
            for (ProspPessoasModFichaTecItem prospPessoasModFichaTecItem : prospPessoasModFichaTec.getItensModFichaTecnica()) {
                PropComercialModFichaTecItem propComercialModFichaTecItem = new PropComercialModFichaTecItem();
                propComercialModFichaTecItem.setItensModeloFichaTecnica(prospPessoasModFichaTecItem.getItensModeloFichaTecnica());
                propComercialModFichaTecItem.setValor(prospPessoasModFichaTecItem.getValor());
                propComercialModFichaTecItem.setPropComercialModFichaTec(propComercialModFichaTec);
                propComercialModFichaTecItem.setChave(prospPessoasModFichaTecItem.getChave());
                listPropComercialModFichaTecItem.add(propComercialModFichaTecItem);
            }
            propComercialModFichaTec.setItensModFichaTecnica(listPropComercialModFichaTecItem);
            listPropComercialModFichaTec.add(propComercialModFichaTec);
        }
        vo.setPropComercialModFichaTec(listPropComercialModFichaTec);
        return this.buildToDTOGeneric(vo, DTOPropostaComercial.class);
    }
}

