/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.prospeccaopessoas;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.prioridademarketing.EnumConstPrioridadeMarketing;
import com.touchcomp.basementor.model.vo.EmailEnviadoRelPessoa;
import com.touchcomp.basementor.model.vo.ItemInfAdicionalItemRelPes;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PrioridadeMarketing;
import com.touchcomp.basementor.model.vo.ProspPessoasModFichaTec;
import com.touchcomp.basementor.model.vo.ProspeccaoPessoasEvt;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoa;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaLog;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServiceEmailPessoaImpl;
import com.touchcomp.basementorservice.service.impl.prioridademarketing.ServicePrioridadeMarketingImpl;
import com.touchcomp.basementorservice.service.impl.relacionamentopessoa.ServiceRelacionamentoPessoaImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SCompProspeccaoPessoas
extends ServiceGenericImpl {
    ServiceEmailPessoaImpl serviceEmailPessoaImpl;
    ServicePrioridadeMarketingImpl servicePrioridadeMarketingImpl;
    ServiceRelacionamentoPessoaImpl serviceRelacionamentoPessoaImpl;

    public void criaItensInfAdProspPessoas(RelacionamentoPessoa relPessoa, List<ProspPessoasModFichaTec> prospPessoasModFichaTec) {
        List itensInfAd = prospPessoasModFichaTec.stream().filter(prospModFicha -> SCompProspeccaoPessoas.isWithData(prospModFicha.getItensModFichaTecnica())).flatMap(i -> i.getItensModFichaTecnica().stream().map(itenModFicha -> {
            ItemInfAdicionalItemRelPes item = new ItemInfAdicionalItemRelPes();
            item.setRelacionamentoPessoa(relPessoa);
            item.setValor(itenModFicha.getValor());
            item.setChave(itenModFicha.getChave());
            item.setValorObrigatorio(itenModFicha.getValorObrigatorio());
            item.setItensModeloFichaTecnica(itenModFicha.getItensModeloFichaTecnica());
            item.setVlrPadraoSelecionado(itenModFicha.getVlrPadraoSelecionado());
            return item;
        })).collect(Collectors.toList());
        relPessoa.setItensInfAdicional(itensInfAd);
    }

    public RelacionamentoPessoa criarRelacionamentoPessoa(ProspeccaoPessoasEvt vo) {
        if (this.isNull(vo.getFaseComercial()).booleanValue()) {
            return null;
        }
        if (this.isNull(vo.getPessoaEvento()).booleanValue()) {
            return null;
        }
        RelacionamentoPessoa rel = vo.getRelacionamentoPessoa();
        if (this.isNull(rel).booleanValue() && this.isNotNull(vo.getCriarRelacionamento()).booleanValue() && this.isEquals(vo.getCriarRelacionamento(), EnumConstantsMentorSimNao.SIM.getValue())) {
            rel = new RelacionamentoPessoa();
            rel.setAssunto(MessagesBaseMentor.getMsg((String)"M.ERP.1117.001", (Object[])new Object[]{vo.getFaseComercial().getDescricao(), this.isStrWithData(vo.getObservacao()) ? vo.getObservacao() : ""}));
            rel.setClassificacaoMarketing(vo.getFaseComercial().getClassificacaoMarketing());
            rel.setDataCadastro(new Date());
            rel.setDataRelacionamento(vo.getDataEvento());
            rel.setEmailContato(this.serviceEmailPessoaImpl.findFirstEmailPessoaByPessoa(vo.getPessoaEvento().getIdentificador()));
            rel.setEmpresa(vo.getProspeccaoPessoas().getEmpresa());
            rel.setOrigemRel(MessagesBaseMentor.getMsg((String)"M.ERP.1117.001", (Object[])new Object[0]));
            rel.setEmailsEnviados(this.getEmailsAtivosEnviarRel(vo.getPessoaEvento()));
            rel.setPessoa(vo.getPessoaEvento());
            rel.setPrioridadeMarketing((PrioridadeMarketing)this.servicePrioridadeMarketingImpl.get(EnumConstPrioridadeMarketing.ALTA.getEnumId()));
            rel.setProcedenciaSolicitacao(vo.getFaseComercial().getProcedenciaSolicitacao());
            rel.setSetor(vo.getUsuario().getSetorUsuario());
            rel.setUsuario(vo.getUsuario());
            rel.setNrProtocolo(this.serviceRelacionamentoPessoaImpl.findNrProtocolo());
            rel.setSetor(vo.getFaseComercial().getSetorUsuario());
            rel.setUsuarioAgendamento(vo.getUsuario());
            rel.setAgendamentos(this.criarRelacionamentoPessoaLog(vo, rel));
        }
        return rel;
    }

    private List<EmailEnviadoRelPessoa> getEmailsAtivosEnviarRel(Pessoa pessoa) {
        return pessoa.getComplemento().getEmails().stream().filter(emails -> this.isEquals(emails.getAtivo(), EnumConstantsMentorSimNao.SIM.getValue()) && this.isEquals(emails.getEnviarDadosRelacionamento(), EnumConstantsMentorSimNao.SIM.getValue())).map(i -> {
            EmailEnviadoRelPessoa em = new EmailEnviadoRelPessoa();
            em.setEmail(i.getEmail());
            return em;
        }).collect(Collectors.toList());
    }

    private List<RelacionamentoPessoaLog> criarRelacionamentoPessoaLog(ProspeccaoPessoasEvt vo, RelacionamentoPessoa rel) {
        RelacionamentoPessoaLog relacionamentoPessoaLog = new RelacionamentoPessoaLog();
        relacionamentoPessoaLog.setDataAgendamento(vo.getDataAgendamento());
        relacionamentoPessoaLog.setDataInicial(vo.getDataAgendamento());
        relacionamentoPessoaLog.setFinalizado(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        relacionamentoPessoaLog.setRelacionamentoPessoa(rel);
        relacionamentoPessoaLog.setUsuario(vo.getUsuario());
        relacionamentoPessoaLog.setUsuarioAgendamento(vo.getUsuario());
        return ToolMethods.toList((Object[])new Object[]{relacionamentoPessoaLog});
    }

    @Generated
    public SCompProspeccaoPessoas(ServiceEmailPessoaImpl serviceEmailPessoaImpl, ServicePrioridadeMarketingImpl servicePrioridadeMarketingImpl, ServiceRelacionamentoPessoaImpl serviceRelacionamentoPessoaImpl) {
        this.serviceEmailPessoaImpl = serviceEmailPessoaImpl;
        this.servicePrioridadeMarketingImpl = servicePrioridadeMarketingImpl;
        this.serviceRelacionamentoPessoaImpl = serviceRelacionamentoPessoaImpl;
    }
}

