/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.prospeccaopessoas;

import com.touchcomp.basementor.capsules.impl.CapsUsuario;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.fasecomercial.EnumConstStatusFaseComercial;
import com.touchcomp.basementor.model.vo.ItemModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.ProspPessoasModFichaTec;
import com.touchcomp.basementor.model.vo.ProspPessoasModFichaTecItem;
import com.touchcomp.basementor.model.vo.ProspeccaoPessoas;
import com.touchcomp.basementor.model.vo.ProspeccaoPessoasEvt;
import com.touchcomp.basementor.model.vo.ProspeccaoPessoasEvtItem;
import com.touchcomp.basementor.model.vo.ProspeccaoPessoasPessoa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoProspeccaoPessoasImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.fasecomercial.ServiceFaseComercialImpl;
import com.touchcomp.basementorservice.service.impl.modelofichatecnica.ServiceModeloFichaTecnicaImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementorservice.service.impl.prospeccaopessoas.SCompProspeccaoPessoas;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.prospeccaopessoasevt.web.DTOProspeccaoPessoasEvt;
import com.touchcomp.touchvomodel.vo.prospeccaopessoaspessoa.web.DTOProspeccaoPessoasPessoa;
import com.touchcomp.touchvomodel.vo.prosppessoasmodfichatec.web.DTOProspPessoasModFichaTec;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceProspeccaoPessoasImpl
extends ServiceGenericEntityImpl<ProspeccaoPessoas, Long, DaoProspeccaoPessoasImpl> {
    @Autowired
    ServicePessoaImpl servicePessoaImpl;
    @Autowired
    ServiceUsuarioImpl serviceUsuarioImpl;
    @Autowired
    ServiceFaseComercialImpl serviceFaseComercialImpl;
    @Autowired
    ServiceModeloFichaTecnicaImpl serviceModeloFichaTecnicaImpl;
    @Autowired
    SCompProspeccaoPessoas sCompProspeccaoPessoas;

    @Autowired
    public ServiceProspeccaoPessoasImpl(DaoProspeccaoPessoasImpl genericDao) {
        super(genericDao);
    }

    public ProspeccaoPessoas getLastProspeccaoPessoa(Pessoa pessoa) {
        return ((DaoProspeccaoPessoasImpl)this.getGenericDao()).getLastProspeccaoPessoa(pessoa);
    }

    @Override
    public ProspeccaoPessoas beforeSaveEntity(ProspeccaoPessoas vo) {
        vo.getIndicantes().forEach(i -> i.setProspeccaoPessoas(vo));
        vo.getProspPessoasModFichaTec().forEach(i -> {
            i.setProspeccaoPessoas(vo);
            i.getItensModFichaTecnica().forEach(mft -> mft.setProspPessoasModFichaTec(i));
        });
        Date dataEncerramento = null;
        for (ProspeccaoPessoasEvt i2 : vo.getEventosProspeccao()) {
            i2.setProspeccaoPessoas(vo);
            i2.getItensEvento().forEach(ie -> ie.setProspeccaoPessoasEvt(i2));
            if (this.isNotNull(i2.getRelacionamentoPessoa()).booleanValue()) {
                i2.getRelacionamentoPessoa().setOrigemRel(vo.getObservacao());
            }
            if (i2.getDataEvento() == null || i2.getFaseComercial() == null || this.isEquals(i2.getFaseComercial().getStatusProspeccaoComercial(), EnumConstStatusFaseComercial.ANDAMENTO.getValue()) || dataEncerramento != null && !dataEncerramento.before(i2.getDataEvento())) continue;
            dataEncerramento = i2.getDataEvento();
        }
        vo.setDataEncerramentoProspeccao(dataEncerramento);
        return vo;
    }

    @Override
    public ProspeccaoPessoas beforeSave(ProspeccaoPessoas vo) {
        vo.getEventosProspeccao().forEach(i -> {
            i.setProspeccaoPessoas(vo);
            if (this.isNull(i.getRelacionamentoPessoa()).booleanValue() && this.isEquals(i.getCriarRelacionamento(), EnumConstantsMentorSimNao.SIM.getValue())) {
                i.setRelacionamentoPessoa(this.sCompProspeccaoPessoas.criarRelacionamentoPessoa((ProspeccaoPessoasEvt)i));
            }
        });
        return vo;
    }

    @Override
    public ProspeccaoPessoas afterSaveEntity(ProspeccaoPessoas vo) {
        vo.getEventosProspeccao().stream().filter(evento -> ToolMethods.isAffirmative((Number)evento.getCriarRelacionamento()) && this.isNotNull(evento.getRelacionamentoPessoa()) != false).forEach(evt -> this.sCompProspeccaoPessoas.criaItensInfAdProspPessoas(evt.getRelacionamentoPessoa(), vo.getProspPessoasModFichaTec()));
        return vo;
    }

    public List<DTOProspeccaoPessoasPessoa> getProspeccaoPessoaPessoa(Long[] ids) {
        List pessoas = this.servicePessoaImpl.gets(ids);
        List prospeccaoPessoasPessoa = pessoas.stream().map(i -> {
            ProspeccaoPessoasPessoa item = new ProspeccaoPessoasPessoa();
            item.setPessoa(i);
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(prospeccaoPessoasPessoa, DTOProspeccaoPessoasPessoa.class);
    }

    public List<DTOProspeccaoPessoasEvt> getProspeccaoPessoasEvt(Long[] ids, Long idPessoa, CapsUsuario capsUsuarioLogado) throws ExceptionObjNotFound {
        Pessoa pessoa = (Pessoa)this.servicePessoaImpl.getOrThrow(idPessoa);
        Usuario usuario = (Usuario)this.serviceUsuarioImpl.getOrThrow(capsUsuarioLogado.get());
        List faseComercial = this.serviceFaseComercialImpl.gets(ids);
        List prospeccaoPessoasEvt = faseComercial.stream().map(i -> {
            ProspeccaoPessoasEvt item = new ProspeccaoPessoasEvt();
            item.setFaseComercial(i);
            item.setPessoaEvento(pessoa);
            item.setUsuario(usuario);
            item.setDataEvento(new Date());
            if (this.isNotNull(i.getModeloFichaTecnica()).booleanValue()) {
                item.setItensEvento(i.getModeloFichaTecnica().getItensModeloFichaTecnica().stream().map(mft -> {
                    ProspeccaoPessoasEvtItem evtItem = new ProspeccaoPessoasEvtItem();
                    evtItem.setItensModeloFichaTecnica(mft);
                    evtItem.setProspeccaoPessoasEvt(item);
                    evtItem.setChave(mft.getDescricao());
                    evtItem.setValorObrigatorio(mft.getCampoObrigatorio());
                    return evtItem;
                }).collect(Collectors.toList()));
            }
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(prospeccaoPessoasEvt, DTOProspeccaoPessoasEvt.class);
    }

    public List<DTOProspPessoasModFichaTec> getProspPessoasModFichaTec(Long[] ids) {
        List modeloFichaTecnicas = this.serviceModeloFichaTecnicaImpl.gets(ids);
        ArrayList<ProspPessoasModFichaTec> listProspPessoasModFichaTec = new ArrayList<ProspPessoasModFichaTec>();
        for (ModeloFichaTecnica modeloFicha : modeloFichaTecnicas) {
            ProspPessoasModFichaTec prospPessoasModFichaTec = new ProspPessoasModFichaTec();
            prospPessoasModFichaTec.setModeloFichaTecnica(modeloFicha);
            ArrayList<ProspPessoasModFichaTecItem> listProspPessoasModFichaTecItem = new ArrayList<ProspPessoasModFichaTecItem>();
            for (ItemModeloFichaTecnica itemModelo : modeloFicha.getItensModeloFichaTecnica()) {
                ProspPessoasModFichaTecItem prospPessoasModFichaTecItem = new ProspPessoasModFichaTecItem();
                prospPessoasModFichaTecItem.setItensModeloFichaTecnica(itemModelo);
                prospPessoasModFichaTecItem.setProspPessoasModFichaTec(prospPessoasModFichaTec);
                prospPessoasModFichaTecItem.setChave(itemModelo.getDescricao());
                prospPessoasModFichaTecItem.setValorObrigatorio(itemModelo.getCampoObrigatorio());
                listProspPessoasModFichaTecItem.add(prospPessoasModFichaTecItem);
            }
            prospPessoasModFichaTec.setItensModFichaTecnica(listProspPessoasModFichaTecItem);
            listProspPessoasModFichaTec.add(prospPessoasModFichaTec);
        }
        return this.buildToDTOGeneric(listProspPessoasModFichaTec, DTOProspPessoasModFichaTec.class);
    }
}

