/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.provisaodec;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemProvisaoDec;
import com.touchcomp.basementor.model.vo.ProvisaoDec;
import com.touchcomp.basementorservice.dao.impl.DaoProvisaoDecImpl;
import com.touchcomp.basementorservice.helpers.impl.provisaodecimoterceiro.HelperLancamentoProvisaoDecTerceiros;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceProvisaoDecImpl
extends ServiceGenericEntityImpl<ProvisaoDec, Long, DaoProvisaoDecImpl> {
    final HelperLancamentoProvisaoDecTerceiros helperLancamentoProvisaoDecTerceiros;

    @Autowired
    public ServiceProvisaoDecImpl(DaoProvisaoDecImpl dao, HelperLancamentoProvisaoDecTerceiros helperLancamentoProvisaoDecTerceiros) {
        super(dao);
        this.helperLancamentoProvisaoDecTerceiros = helperLancamentoProvisaoDecTerceiros;
    }

    public List<Colaborador> findColaboradoresProvisaoDecCentroCusto(Date dataInicial, Date dataFinal, Empresa empresaFiltrada) {
        return ((DaoProvisaoDecImpl)this.getGenericDao()).findColaboradoresProvisaoDecCentroCusto(dataInicial, dataFinal, empresaFiltrada);
    }

    public List<Colaborador> findColaboradoresProvisaoDec(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        return ((DaoProvisaoDecImpl)this.getGenericDao()).findColaboradoresProvisaoDec(dataInicial, dataFinal, grupoEmpresa);
    }

    public List afastamentoColaborador(Colaborador colaborador, Date dataProvisao) {
        return ((DaoProvisaoDecImpl)this.getGenericDao()).afastamentoColaborador(colaborador, dataProvisao);
    }

    public Double vlrMediaProvDecimoTerceiro(Colaborador colaborador, Date dataInicial) {
        return ((DaoProvisaoDecImpl)this.getGenericDao()).vlrMediaProvDecimoTerceiro(colaborador, dataInicial);
    }

    public Boolean verificarFolhaPagamentoContabilizada(Date dataPeriodo) {
        return ((DaoProvisaoDecImpl)this.getGenericDao()).verificarExistenciaIntegContFolha(dataPeriodo);
    }

    @Override
    public ProvisaoDec beforeSave(ProvisaoDec p) {
        if (p != null && p.getEmpresa() != null && this.getSharedData() != null) {
            p = this.helperLancamentoProvisaoDecTerceiros.salvarAndContabilizarprovisaoDec(p, this.getSharedData().getEmpresaRh(p.getEmpresa()));
            for (ItemProvisaoDec i : p.getItensProvisoes()) {
                i.setProvisao(p);
            }
        }
        return p;
    }
}

