/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.provisaoferias;

import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.PeriodoAqFeriasColab;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.afastamentocolaborador.ServiceAfastamentoColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.colaboradordadosferias.ServiceColaboradorDadosFeriasImpl;
import com.touchcomp.basementorservice.service.impl.periodoaqferiascolab.ServicePeriodoAqFeriasColabImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCompCalculoAvos
extends ServiceGenericImpl {
    @Autowired
    ServicePeriodoAqFeriasColabImpl servicePeriodoAqFeriasColab;
    @Autowired
    ServiceColaboradorDadosFeriasImpl serviceColaboradorDadosFerias;
    @Autowired
    ServiceAfastamentoColaboradorImpl serviceAfastamentoColaborador;
    private final int METADE_MES_15_DIAS = 15;
    private final int SEIS_MESES_180_DIAS = 180;
    private final int SEIS_MESES = 6;

    public ProvisaoFeriasAvos pesquisarAvosProvisao(Colaborador colaborador, Date dataProvisao) {
        return null;
    }

    ProvisaoFeriasAvos calcularAvosAfastamento(Colaborador colaborador, Date dataProvisao, List<AfastamentoColaborador> listAfastamentoColaborador) {
        Integer avosFinal = 0;
        Date dataFinalFerias = null;
        for (AfastamentoColaborador afastamentoColaborador : listAfastamentoColaborador) {
            Date dataAfastamento = afastamentoColaborador.getDataAfastamento();
            if (this.isEquals(afastamentoColaborador.getAfastamentoSefip().getCodigo(), "U3")) {
                // empty if block
            }
            int diasAfastados = ToolDate.diferenceDayBetweenDates((Date)dataAfastamento, (Date)dataProvisao);
            dataFinalFerias = ToolDate.getDateWeek((Date)this.pesquisarDataFinalFerias(colaborador, dataProvisao), (int)1);
            if (diasAfastados >= 180) {
                Integer avos = this.pesquisarAvosAfastados(dataFinalFerias, dataAfastamento);
                if (avos <= 6) {
                    avos = 0;
                }
                avosFinal = avosFinal + avos;
                continue;
            }
            avosFinal = avosFinal + this.pesquisarAvosAfastados(dataFinalFerias, dataProvisao);
        }
        return new ProvisaoFeriasAvos(avosFinal, dataFinalFerias);
    }

    Date pesquisarDataFinalFerias(Colaborador colaborador, Date dataProvisao) {
        PeriodoAqFeriasColab periodoAqFeriasColab = this.servicePeriodoAqFeriasColab.pesquisarPeriodoAqFeriasColaboradorColaboradorDataProvisao(colaborador, dataProvisao);
        if (this.isNotNull(periodoAqFeriasColab).booleanValue()) {
            return periodoAqFeriasColab.getDataFinal();
        }
        return ToolDate.nextDays((Date)colaborador.getDataAdmissao(), (int)-1);
    }

    Integer pesquisarAvosAfastados(Date dataFinalFerias, Date dataAfastamento) {
        Integer avos = this.pesquisarPrimeiroAvosFerias(dataFinalFerias, dataAfastamento);
        dataFinalFerias = ToolDate.nextMonth((Date)dataFinalFerias, (int)1);
        Boolean continuar = true;
        do {
            if (dataFinalFerias.before(dataAfastamento) && 15 < ToolDate.diferenceDayBetweenDates((Date)dataFinalFerias, (Date)dataAfastamento) + 1) {
                avos = avos + 1;
            } else {
                avos = this.pesquisarUltimoAvosFerias(dataFinalFerias, dataAfastamento) + avos;
                continuar = false;
            }
            dataFinalFerias = ToolDate.nextMonth((Date)dataFinalFerias, (int)1);
        } while (continuar.booleanValue());
        return avos;
    }

    Integer pesquisarPrimeiroAvosFerias(Date dataFinalFerias, Date dataAfastamento) {
        if (dataAfastamento.before(dataFinalFerias)) {
            return 0;
        }
        Integer avos = ToolDate.getDaysOnMonth((Date)dataFinalFerias) - ToolDate.getDayFromDate((Date)dataFinalFerias) + 1;
        if (avos >= 15) {
            return 1;
        }
        return 0;
    }

    Integer pesquisarUltimoAvosFerias(Date dataFinalFerias, Date dataAfastamento) {
        Integer avos = ToolDate.diferenceDayBetweenDates((Date)dataFinalFerias, (Date)dataAfastamento) + 2;
        if (avos >= 15) {
            return 1;
        }
        return 0;
    }

    ProvisaoFeriasAvos calcularFeriasNormais(Colaborador colaborador, Date dataProvisao) {
        Date dataFinalFerias = this.pesquisarDataFinalFerias(colaborador, dataProvisao);
        Date dataRetorno = this.pesquisarDataRetornoAfastamento(colaborador, dataFinalFerias);
        if (this.isNotNull(dataRetorno).booleanValue()) {
            dataFinalFerias = dataRetorno;
        }
        Date dataFinalFeriasNova = dataFinalFerias;
        Date dataProximoPeriodo = ToolDate.nextYear((Date)dataFinalFeriasNova, (int)1);
        Integer avos = this.pesquisarPrimeiroAvosFeriasNormais(dataFinalFeriasNova, dataProvisao);
        dataFinalFeriasNova = ToolDate.nextMonth((Date)dataFinalFeriasNova, (int)1);
        Boolean continuar = true;
        do {
            if (this.isEquals(dataFinalFeriasNova, dataProximoPeriodo)) {
                dataRetorno = this.pesquisarDataRetornoAfastamento(colaborador, dataProximoPeriodo);
                if (this.isNotNull(dataRetorno).booleanValue()) {
                    dataFinalFeriasNova = dataRetorno;
                }
                dataProximoPeriodo = ToolDate.nextDays((Date)dataProximoPeriodo, (int)1);
            }
            if (dataFinalFeriasNova.before(dataProvisao) && 15L < ToolDate.difBetweenDatesInDays((Date)dataFinalFeriasNova, (Date)dataProvisao) + 1L) {
                avos = avos + 1;
            } else {
                avos = this.pesquisarUltimoAvosFerias(dataFinalFeriasNova, dataProvisao) + avos;
                continuar = false;
            }
            dataFinalFeriasNova = ToolDate.nextMonth((Date)dataFinalFeriasNova, (int)1);
        } while (continuar.booleanValue());
        return new ProvisaoFeriasAvos(avos, dataFinalFerias);
    }

    Date pesquisarDataRetornoAfastamento(Colaborador colaborador, Date dataFinalFerias) {
        return null;
    }

    Integer pesquisarPrimeiroAvosFeriasNormais(Date dataFinalFerias, Date dataProvisao) {
        if (dataProvisao.before(dataFinalFerias)) {
            return 0;
        }
        if (ToolDate.diferenceDayBetweenDates((Date)dataFinalFerias, (Date)dataProvisao) + 1 < 15) {
            return 0;
        }
        if (this.isEquals(dataFinalFerias, dataProvisao)) {
            Integer avos = ToolDate.getDaysOnMonth((Date)dataFinalFerias) - ToolDate.getDayFromDate((Date)dataFinalFerias) + 1;
            if (avos >= 15) {
                return 1;
            }
            return 0;
        }
        Integer avos = ToolDate.diferenceDayBetweenDates((Date)dataFinalFerias, (Date)ToolDate.nextMonth((Date)dataFinalFerias, (int)1)) + 1;
        if (avos >= 15) {
            return 1;
        }
        return 0;
    }

    public record ProvisaoFeriasAvos(Integer avos, Date ultimaDataFerias) {
    }
}

