/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.provisaoferias;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemProvisaoFerias;
import com.touchcomp.basementor.model.vo.ProvisaoFerias;
import com.touchcomp.basementorservice.dao.impl.DaoProvisaoFeriasImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.provisaoferias.UtilLancamentoProvisaoFeriasCentroCusto;
import com.touchcomp.basementorservice.service.impl.provisaoferias.UtilProvisaoFerias;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceProvisaoFeriasImpl
extends ServiceGenericEntityImpl<ProvisaoFerias, Long, DaoProvisaoFeriasImpl> {
    @Autowired
    public ServiceProvisaoFeriasImpl(DaoProvisaoFeriasImpl dao) {
        super(dao);
    }

    public Boolean verificarFolhaPagamentoContabilizada(Date periodo) {
        return ((DaoProvisaoFeriasImpl)this.getDao()).verificarFolhaPagamentoContabilizada(periodo);
    }

    public List<ItemProvisaoFerias> processarDados(Date periodo, Double percDesoneracao, Empresa empresa, EmpresaRh empresaRh) {
        return UtilProvisaoFerias.processarDados(periodo, percDesoneracao, empresa, empresaRh);
    }

    public List<Colaborador> findColaboradoresProvisaoFeriasCentroCusto(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Empresa empresa) {
        return ((DaoProvisaoFeriasImpl)this.getDao()).findColaboradoresProvisaoFeriasCentroCusto(dataInicial, dataFinal, grupoEmpresa, empresa);
    }

    public List<Colaborador> findColaboradoresProvisaoFerias(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Empresa empresa) {
        return ((DaoProvisaoFeriasImpl)this.getDao()).findColaboradoresProvisaoFerias(dataInicial, dataFinal, grupoEmpresa, empresa);
    }

    public Double findMediaFerias(Date dataInicio, Date dataFinal, Colaborador colaborador) {
        return ((DaoProvisaoFeriasImpl)this.getDao()).findMediaFerias(dataInicio, dataFinal, colaborador);
    }

    @Override
    public ProvisaoFerias beforeSave(ProvisaoFerias p) {
        if (p != null && p.getEmpresa() != null && this.getSharedData() != null) {
            p = this.salvarAndContabilizarProvisaoFerias(p, this.getSharedData().getEmpresaRh(p.getEmpresa()));
            for (ItemProvisaoFerias i : p.getItensProvisoes()) {
                i.setProvisao(p);
            }
        }
        return p;
    }

    public List<Colaborador> findCentroCustos(ProvisaoFerias vo) {
        return ((DaoProvisaoFeriasImpl)this.getDao()).findCentroCustos(vo);
    }

    public HashMap findValoresProvisaoAnterior(Date periodo, Colaborador colaborador) {
        return ((DaoProvisaoFeriasImpl)this.getDao()).findValoresProvisaoAnterior(periodo, colaborador);
    }

    public ProvisaoFerias salvarAndContabilizarProvisaoFerias(ProvisaoFerias vo, EmpresaRh empresaRh) {
        return new UtilLancamentoProvisaoFeriasCentroCusto().salvarAndContabilizarProvisaoFerias(vo, empresaRh);
    }
}

