/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.provisaoferias;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldo;
import com.touchcomp.basementor.model.impl.SaldoContaContabil;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.ItemProvisaoFerias;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.PlanoContaImpostoFolha;
import com.touchcomp.basementor.model.vo.ProvisaoFerias;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidDataRuntime;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.service.impl.planocontaimpostofolha.ServicePlanoContaImpostoFolhaImpl;
import com.touchcomp.basementorservice.service.impl.saldoconta.ServiceSaldoContaImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class UtilLancamentoProvisaoFeriasCentroCusto
extends CompLancamentoBase {
    public ProvisaoFerias salvarAndContabilizarProvisaoFerias(ProvisaoFerias vo, EmpresaRh empresaRh) {
        if (vo != null && empresaRh != null) {
            LoteContabil l = this.gerarLancamentos(vo, empresaRh.getAjustarContaInssProvisao(), empresaRh.getPossuiDesoneracao());
            vo.setLoteContabil(l);
            if (empresaRh.getGerarLancamentosGerenciais().equals((short)1)) {
                this.integrandoLancamentosGerenciaisProvisaoFerias(vo);
            }
        }
        return vo;
    }

    public LoteContabil gerarLancamentos(ProvisaoFerias vo, Short ajustarContaInss, Short empresaDesonerada) {
        LoteContabil lote = this.contabilizarProvisaoFerias(vo, ajustarContaInss, empresaDesonerada);
        if (lote.getLancamentos() != null && !lote.getLancamentos().isEmpty()) {
            return lote;
        }
        return null;
    }

    public LoteContabil contabilizarProvisaoFerias(ProvisaoFerias vo, Short ajustarContaInss, Short empresaDesonerada) {
        LoteContabil lote = this.criarLoteContabil(vo.getLoteContabil(), vo.getPeriodo(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.PROVISAO_FERIAS);
        for (ItemProvisaoFerias item : vo.getItensProvisoes()) {
            Double vlrFerias = item.getVlrFerias();
            Double vlrUmTercFerias = item.getVlrFerias13();
            Double vrInssEmpresa = item.getVlrInssEmpresa();
            Double vrInssTerceiros = item.getVlrInssTerceiros();
            Double vrFgts = item.getVlrFgts();
            Double vrRat = item.getVlrRat();
            Double vrAposentadoria = item.getVlrAposentadoria25();
            this.criarLancamentosPorCentroCusto(lote, item.getColaborador(), vlrFerias, vlrUmTercFerias, vrInssEmpresa, vrInssTerceiros, vrFgts, vrRat, vrAposentadoria, ajustarContaInss, empresaDesonerada);
        }
        this.verificarSaldoContaAnterior(lote, vo.getEmpresa());
        this.verificarLancamentosZerados(lote);
        return lote;
    }

    private void getLancamento(Double valor, PlanoConta planoCredito, PlanoConta planoDebito, HistoricoPadrao historicoPadrao, LoteContabil lote, CentroResultadoContFin centroResultado, Empresa emp) {
        for (Lancamento lancamento : lote.getLancamentos()) {
            if (!lancamento.getPlanoContaCred().equals((Object)planoCredito) || !lancamento.getPlanoContaDeb().equals((Object)planoDebito) || !lancamento.getCentroResultadoContFin().equals((Object)centroResultado)) continue;
            lancamento.setValor(Double.valueOf(lancamento.getValor() + valor));
            return;
        }
        Lancamento vo = CompLancamentoBase.newLancamento(lote, emp);
        vo.setValor(valor);
        vo.setPlanoContaDeb(planoDebito);
        vo.setPlanoContaCred(planoCredito);
        vo.setHistoricoPadrao(historicoPadrao);
        vo.setHistorico(historicoPadrao.getDescricao());
        lote.getLancamentos().add(vo);
    }

    private void criarLancamentosPorCentroCusto(LoteContabil lote, Colaborador colaborador, Double vlrFerias, Double vlrUmTercFerias, Double vrInssEmpresa, Double vrInssTerceiros, Double vrFgts, Double vrRat, Double vrAposentadoria, Short ajustarContaInss, Short empresaDesonerada) {
        List<PlanoContaImpostoFolha> ret = ((ServicePlanoContaImpostoFolhaImpl)ConfApplicationContext.getBean(ServicePlanoContaImpostoFolhaImpl.class)).getPlanoContaImpostoProvisao(colaborador.getCentroCusto());
        if (ret.size() > 1) {
            String retorno = "EXISTE MAIS DE UMA PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + colaborador.getCentroCusto().getNome() + "\n  Id: ";
            Iterator<PlanoContaImpostoFolha> iterator = ret.iterator();
            while (iterator.hasNext()) {
                PlanoContaImpostoFolha obj;
                PlanoContaImpostoFolha p = obj = iterator.next();
                retorno = retorno + " " + p.getIdentificador().toString() + ";";
            }
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{retorno}));
        }
        if (ret.isEmpty() || ret.size() == 0) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{"N\u00c3O EXISTE PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + colaborador.getCentroCusto().getNome()}));
        }
        PlanoContaImpostoFolha p = ret.get(0);
        if (vlrFerias > 0.0 && p.getPlanoCCCreditoFeriasProv() != null && p.getPlanoCCDebitoFeriasProv() != null) {
            this.getLancamento(vlrFerias, p.getPlanoCCCreditoFeriasProv(), p.getPlanoCCDebitoFeriasProv(), p.getHistoricoFeriasProv(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
        }
        if (vlrUmTercFerias > 0.0 && p.getPlanoCCCreditoTercProvFerias() != null && p.getPlanoCCdebitoUmTercProvFerias() != null) {
            this.getLancamento(vlrUmTercFerias, p.getPlanoCCCreditoTercProvFerias(), p.getPlanoCCdebitoUmTercProvFerias(), p.getHistoricoUmTercFerias(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
        }
        if ((vrInssEmpresa > 0.0 || ajustarContaInss.equals((short)1) && empresaDesonerada.equals((short)1)) && p.getPlanoCCCreditoInssProvFerias() != null && p.getPlanoCCDebitoInssProvFerias() != null) {
            this.getLancamento(vrInssEmpresa, p.getPlanoCCCreditoInssProvFerias(), p.getPlanoCCDebitoInssProvFerias(), p.getHistoricoInssProvFerias(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
        }
        if (vrInssTerceiros > 0.0 && p.getPlanoCCCreditoTerceirosProvFerias() != null && p.getPlanoCCDebitoTerceirosProvFerias() != null) {
            this.getLancamento(vrInssTerceiros, p.getPlanoCCCreditoTerceirosProvFerias(), p.getPlanoCCDebitoTerceirosProvFerias(), p.getHistoricoTerceirosProvFerias(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
        }
        if (vrFgts > 0.0 && p.getPlanoCCCreditoFgtsProvFerias() != null && p.getPlanoCCDebitoFgtsProvFerias() != null) {
            this.getLancamento(vrFgts, p.getPlanoCCCreditoFgtsProvFerias(), p.getPlanoCCDebitoFgtsProvFerias(), p.getHistoricoFgtsProvFerias(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
        }
        if (vrRat > 0.0 && p.getPlanoCCCreditoRatProvFerias() != null && p.getPlanoCCDebitoRatProvFerias() != null) {
            this.getLancamento(vrRat, p.getPlanoCCCreditoRatProvFerias(), p.getPlanoCCDebitoRatProvFerias(), p.getHistoricoRatProvFerias(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
        }
        if (vrAposentadoria > 0.0 && p.getPlanoCCCreditoRatProvFerias() != null && p.getPlanoCCDebitoRatProvFerias() != null) {
            this.getLancamento(vrAposentadoria, p.getPlanoCCCreditoRatProvFerias(), p.getPlanoCCDebitoRatProvFerias(), p.getHistoricoRatProvFerias(), lote, colaborador.getEmpresa().getEmpresaDados().getCentroResultadoContFin(), colaborador.getEmpresa());
        }
    }

    private void verificarSaldoContaAnterior(LoteContabil lote, Empresa empresa) {
        ArrayList<Lancamento> aux = new ArrayList<Lancamento>();
        for (Lancamento lancamento : lote.getLancamentos()) {
            Date data = lote.getDataLote();
            SaldoContaContabil saldo = ((ServiceSaldoContaImpl)ConfApplicationContext.getBean(ServiceSaldoContaImpl.class)).findSaldoContaUnica(lancamento.getCentroResultadoContFin().getIdentificador(), lancamento.getCentroResultadoContFin().getIdentificador(), lancamento.getPlanoContaCred().getCodigo(), data, data, empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador(), EnumConstantsTipoSaldo.TIPO_SALDO_CENTRO_RESULTADO);
            if (lancamento.getValor() == 0.0 && saldo.getSaldoAtual() * -1.0 == 0.0) continue;
            if (lancamento.getValor() >= saldo.getSaldoAtual() * -1.0) {
                Double valorLancamento = ToolFormatter.arrredondarNumero((Double)(lancamento.getValor() - saldo.getSaldoAtual() * -1.0), (int)2);
                lancamento.setValor(valorLancamento);
                aux.add(lancamento);
                continue;
            }
            this.tratarReversao(lancamento, saldo);
            aux.add(lancamento);
        }
        lote.setLancamentos(aux);
    }

    private void tratarReversao(Lancamento lancamento, SaldoContaContabil saldo) {
        PlanoConta contaCredito = lancamento.getPlanoContaDeb();
        PlanoConta contaDebito = lancamento.getPlanoContaCred();
        Double valorLancamento = ToolFormatter.arrredondarNumero((Double)(saldo.getSaldoAtual() * -1.0 - lancamento.getValor()), (int)2);
        lancamento.setPlanoContaCred(contaCredito);
        lancamento.setPlanoContaDeb(contaDebito);
        lancamento.setValor(valorLancamento);
    }

    private void verificarLancamentosZerados(LoteContabil lote) {
        ArrayList<Lancamento> lancs = new ArrayList<Lancamento>();
        for (Lancamento lancamento : lote.getLancamentos()) {
            if (!(lancamento.getValor() > 0.0)) continue;
            lancs.add(lancamento);
        }
        lote.setLancamentos(lancs);
    }

    public void integrandoLancamentosGerenciaisProvisaoFerias(ProvisaoFerias provisao) {
        ArrayList<LancamentoCtbGerencial> lancs = new ArrayList<LancamentoCtbGerencial>();
        for (ItemProvisaoFerias item : provisao.getItensProvisoes()) {
            LancamentoCtbGerencial lanc;
            String historico;
            PlanoContaGerencial planoConta;
            Double valor;
            Short tipoLancamento;
            CentroCusto cc = item.getColaborador().getCentroCusto();
            List<PlanoContaImpostoFolha> ret = ((ServicePlanoContaImpostoFolhaImpl)ConfApplicationContext.getBean(ServicePlanoContaImpostoFolhaImpl.class)).getPlanoContaImpostoProvisao(cc);
            if (ret.size() > 1) {
                String retorno = "EXISTE MAIS DE UMA PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + cc.getNome() + "\n  Id: ";
                Iterator<PlanoContaImpostoFolha> iterator = ret.iterator();
                while (iterator.hasNext()) {
                    PlanoContaImpostoFolha obj;
                    PlanoContaImpostoFolha p = obj = iterator.next();
                    retorno = retorno + " " + p.getIdentificador().toString() + ";";
                }
                throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{retorno}));
            }
            if (ret.isEmpty() || ret.size() == 0) {
                throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.WEB-FOR.000.000", new String[]{"N\u00c3O EXISTE PARAMETRIZA\u00c7\u00c3O PARA: \nCentro de custo: " + cc.getNome()}));
            }
            PlanoContaImpostoFolha p = ret.get(0);
            Double valorFerias = item.getVlrFerias() + item.getVlrFerias13();
            if (valorFerias > 0.0) {
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = valorFerias;
                planoConta = p.getPlanoCGFeriasProv();
                historico = p.getHistoricoFeriasProv().getDescricao();
                lanc = this.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (item.getVlrInssEmpresa() > 0.0) {
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrInssEmpresa();
                planoConta = p.getPlanoCGInssProvFerias();
                historico = p.getHistoricoInssProvFerias().getDescricao();
                lanc = this.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (item.getVlrFgts() > 0.0) {
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrFgts();
                planoConta = p.getPlanoCGFgtsProvFerias();
                historico = p.getHistoricoFgtsProvFerias().getDescricao();
                lanc = this.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (item.getVlrInssTerceiros() > 0.0) {
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrInssTerceiros();
                planoConta = p.getPlanoCGTerceirosProvFerias();
                historico = p.getHistoricoTerceirosProvFerias().getDescricao();
                lanc = this.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (item.getVlrRat() > 0.0) {
                tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
                valor = item.getVlrRat();
                planoConta = p.getPlanoCGRatProvFerias();
                historico = p.getHistoricoRatProvFerias().getDescricao();
                lanc = this.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
                lancs.add(lanc);
            }
            if (!(item.getVlrAposentadoria25() > 0.0)) continue;
            tipoLancamento = EnumLancamentoCTBGerencial.DEBITO.getValue();
            valor = item.getVlrAposentadoria25();
            planoConta = p.getPlanoCGRatProvFerias();
            historico = p.getHistoricoRatProvFerias().getDescricao();
            lanc = this.criarLancamentoGerencial(tipoLancamento, valor, historico, cc, planoConta, provisao.getPeriodo(), provisao.getDataAtualizacao(), provisao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
            lancs.add(lanc);
        }
        provisao.setLancsGerencial(lancs);
    }

    private LancamentoCtbGerencial criarLancamentoGerencial(Short tipoLancamento, Double valor, String historico, CentroCusto centroCusto, PlanoContaGerencial planoConta, Date dataCadastro, Timestamp dataAtualizacao, Empresa empresa, Short gerado) {
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, dataCadastro, dataCadastro, tipoLancamento, empresa, gerado, historico, planoConta, EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue(), centroCusto, valor, null);
        return l;
    }
}

