/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.provisaoferias;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.ItemProvisaoFerias;
import com.touchcomp.basementorservice.service.impl.provisaoferias.SCompCalculoAvos;
import com.touchcomp.basementorservice.service.impl.provisaoferias.ServiceProvisaoFeriasImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class UtilProvisaoFerias {
    static List<ItemProvisaoFerias> processarDados(Date periodo, Double percDesoneracao, Empresa empresa, EmpresaRh empresaRh) {
        ArrayList<ItemProvisaoFerias> itensProvisao = new ArrayList<ItemProvisaoFerias>();
        List<Object> colaboradores = new ArrayList();
        colaboradores = empresaRh.getContabilizarProvisaoCC().equals((short)1) ? ((ServiceProvisaoFeriasImpl)ConfApplicationContext.getBean(ServiceProvisaoFeriasImpl.class)).findColaboradoresProvisaoFeriasCentroCusto(periodo, periodo, empresa.getEmpresaDados().getGrupoEmpresa(), empresaRh.getEmpresa()) : ((ServiceProvisaoFeriasImpl)ConfApplicationContext.getBean(ServiceProvisaoFeriasImpl.class)).findColaboradoresProvisaoFerias(periodo, periodo, empresa.getEmpresaDados().getGrupoEmpresa(), null);
        for (Colaborador colaborador : colaboradores) {
            ItemProvisaoFerias item;
            if (colaborador.getIdentificador() == 43L) {
                System.out.println("");
            }
            if (!((item = UtilProvisaoFerias.findItemProvisaoFerias(colaborador, periodo, periodo, percDesoneracao, empresaRh)).getAvos() > 0.0)) continue;
            itensProvisao.add(item);
        }
        return null;
    }

    private static ItemProvisaoFerias findItemProvisaoFerias(Colaborador colaborador, Date periodoInicial, Date periodoFinal, Double percDesoneracao, EmpresaRh empresaRh) {
        SCompCalculoAvos.ProvisaoFeriasAvos provisaoFeriasAvos;
        Double vrSalarioBase = UtilProvisaoFerias.salarioProvisao(colaborador);
        if (colaborador.getNumeroRegistro().equals("55")) {
            System.out.println("");
        }
        if ((provisaoFeriasAvos = ((SCompCalculoAvos)ConfApplicationContext.getBean(SCompCalculoAvos.class)).pesquisarAvosProvisao(colaborador, periodoFinal)) != null) {
            Integer aux = provisaoFeriasAvos.avos();
            Double avos = aux.doubleValue();
            Date ultimaDataFerias = provisaoFeriasAvos.ultimaDataFerias();
            Double vlrMedias = UtilProvisaoFerias.getMediaFeriasColaborador(ultimaDataFerias, periodoFinal, colaborador);
            Double vlrMaiorRemuneracao = 0.0;
            vlrMaiorRemuneracao = avos > 0.0 ? ToolFormatter.arrredondarNumero((Double)(vrSalarioBase + vlrMedias / avos), (int)2) : ToolFormatter.arrredondarNumero((Double)vrSalarioBase, (int)2);
            Double vlrFerias = UtilProvisaoFerias.getFerias(vlrMaiorRemuneracao, avos);
            Double vlr13Ferias = UtilProvisaoFerias.get13Ferias(vlrFerias);
            Double vlrInssEmpresa = UtilProvisaoFerias.getVlrInssEmpresa(vlrFerias, vlr13Ferias, percDesoneracao, empresaRh);
            Double vlrInssTer = UtilProvisaoFerias.getVlrInssTer(vlrFerias, vlr13Ferias, empresaRh);
            Double vlrFgts = UtilProvisaoFerias.getVlFgts(vlrFerias, vlr13Ferias);
            Double vlrRat = UtilProvisaoFerias.getVlrRat(vlrFerias, vlr13Ferias, empresaRh);
            Double vlrAposentadoria25 = UtilProvisaoFerias.getVlrAposentadoriaEspecial25Anos(colaborador, vlrFerias, vlr13Ferias, empresaRh);
            Double vlrPis = UtilProvisaoFerias.getVlrPis(vlrFerias + vlr13Ferias, empresaRh);
            ItemProvisaoFerias item = new ItemProvisaoFerias(colaborador, vrSalarioBase, vlrMedias, avos, vlrFerias, vlr13Ferias, vlrInssEmpresa, vlrInssTer, vlrFgts, vlrMaiorRemuneracao, vlrRat, vlrAposentadoria25, ultimaDataFerias, vlrPis);
            return item;
        }
        return null;
    }

    public static Double salarioProvisao(Colaborador colaborador) {
        String cod = colaborador.getTipoSalario().getCodigo();
        System.err.println(colaborador.toString() + "Metodo");
        Integer codigo = Integer.parseInt(cod);
        Double vlrSalario = colaborador.getValorSalario();
        if (vlrSalario == null) {
            return 0.0;
        }
        Double valor = vlrSalario;
        switch (codigo) {
            case 1: {
                return valor;
            }
            case 2: {
                return valor;
            }
            case 3: {
                return valor;
            }
            case 4: {
                valor = valor * colaborador.getDiasJornada();
                return valor;
            }
            case 5: {
                valor = valor * colaborador.getDiasJornada() * colaborador.getHorasTrabDia();
                valor = ToolFormatter.arrredondarNumero((Double)valor, (int)2);
                return valor;
            }
            case 6: {
                return valor;
            }
            case 7: {
                return valor;
            }
        }
        return valor;
    }

    private static Double getMediaFeriasColaborador(Date dataInicio, Date dataFinal, Colaborador colaborador) {
        return ((ServiceProvisaoFeriasImpl)ConfApplicationContext.getBean(ServiceProvisaoFeriasImpl.class)).findMediaFerias(dataInicio, dataFinal, colaborador);
    }

    public static Double getFerias(Double maiorRemuneracao, Double avos) {
        return ToolFormatter.arrredondarNumero((Double)(maiorRemuneracao / 12.0 * avos), (int)2);
    }

    public static Double get13Ferias(Double vlrFerias) {
        return ToolFormatter.arrredondarNumero((Double)(vlrFerias / 3.0), (int)2);
    }

    public static Double getVlrInssEmpresa(Double vlrFerias, Double vlr13Ferias, Double percDesoneracao, EmpresaRh empresaRh) {
        if (empresaRh.getPossuiDesoneracao().equals((short)0)) {
            Double vlrBaseInss = ToolFormatter.arrredondarNumero((Double)(vlrFerias + vlr13Ferias), (int)2);
            Double percInssEmpresa = empresaRh.getPercEmpresa() / 100.0;
            return ToolFormatter.arrredondarNumero((Double)(vlrBaseInss * percInssEmpresa), (int)2);
        }
        Double vlrBaseInss = ToolFormatter.arrredondarNumero((Double)(vlrFerias + vlr13Ferias), (int)2);
        Double percInssEmpresa = empresaRh.getPercEmpresa() / 100.0;
        Double inss = vlrBaseInss * percInssEmpresa;
        inss = inss * ((100.0 - percDesoneracao) / 100.0);
        return inss;
    }

    public static Double getVlrInssTer(Double vlrFerias, Double vlr13Ferias, EmpresaRh empresaRh) {
        Double vlrBase = ToolFormatter.arrredondarNumero((Double)(vlrFerias + vlr13Ferias), (int)2);
        Double percInssTer = empresaRh.getPercTerceiros() / 100.0;
        return ToolFormatter.arrredondarNumero((Double)(vlrBase * percInssTer), (int)2);
    }

    public static Double getVlFgts(Double vlrFerias, Double vlr13Ferias) {
        Double vlrBase = ToolFormatter.arrredondarNumero((Double)(vlrFerias + vlr13Ferias), (int)2);
        Double percFgts = 0.08;
        return ToolFormatter.arrredondarNumero((Double)(vlrBase * percFgts), (int)2);
    }

    public static Double getVlrRat(Double vlrFerias, Double vlr13Ferias, EmpresaRh empresaRh) {
        Double vlrBase = ToolFormatter.arrredondarNumero((Double)(vlrFerias + vlr13Ferias), (int)2);
        Double indiceFat = empresaRh.getIndiceFAP();
        Double rat = empresaRh.getPercRat();
        return ToolFormatter.arrredondarNumero((Double)(vlrBase * indiceFat * (rat / 100.0)), (int)2);
    }

    public static Double getVlrAposentadoriaEspecial25Anos(Colaborador c, Double vlrFerias, Double vlr13Ferias, EmpresaRh empresaRh) {
        if (c.getCategoriaSefip().getCodigo().equals("04")) {
            Double vlrBase = ToolFormatter.arrredondarNumero((Double)(vlrFerias + vlr13Ferias), (int)2);
            Double percAposent25 = empresaRh.getPercAposentadoriaEspecial25Anos();
            return ToolFormatter.arrredondarNumero((Double)(vlrBase * (percAposent25 / 100.0)), (int)2);
        }
        return 0.0;
    }

    private static Double getVlrPis(Double baseCalculo, EmpresaRh empresaRh) {
        Empresa empresa = empresaRh.getEmpresa();
        if (empresa.getEmpresaDados().getIndicadorNaturezaJuridica() == null || !empresa.getEmpresaDados().getIndicadorNaturezaJuridica().getCodigo().equals("02")) {
            return 0.0;
        }
        if (empresaRh.getAliquotaPis() <= 0.0) {
            return 0.0;
        }
        Double valorPis = ToolFormatter.arrredondarNumero((Double)(baseCalculo * empresaRh.getAliquotaPis() / 100.0), (int)2);
        return valorPis;
    }
}

