/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.rateiovaloresdirf;

import com.touchcomp.basementor.helper.impl.colaborador.HelperColaborador;
import com.touchcomp.basementor.model.vo.DeParaTipoEventoDirf;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.service.impl.colaboradordependente.ServiceColaboradorDependenteImpl;
import com.touchcomp.basementorservice.service.impl.deparatipoeventodirf.ServiceDeParaTipoEventoDirfImpl;
import com.touchcomp.basementorservice.service.impl.itemmovimentofolha.ServiceItemMovimentoFolhaImpl;
import com.touchcomp.touchvomodel.vo.cadastrorateiopensaoalimenticia.web.DTOCadastroRateioPensaoAlimenticia;
import com.touchcomp.touchvomodel.vo.cadastrorateiovalorplanosaude.web.DTOCadastroRateioValorPlanoSaude;
import com.touchcomp.touchvomodel.vo.itemcadastrodependenteplanosaude.web.DTOItemCadastroDependentePlanoSaude;
import com.touchcomp.touchvomodel.vo.itemcadastrorateiopensaoalimenticia.web.DTOItemCadastroRateioPensaoAlimenticia;
import com.touchcomp.touchvomodel.vo.itemcadastrorateiovalorplanosaude.web.DTOItemCadastroRateioValorPlanoSaude;
import com.touchcomp.touchvomodel.vo.itemrateiobeneficiariopensao.web.DTOItemRateioBeneficiarioPensao;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class AuxRateioValoresDirfImpl
extends BaseMethods {
    final ServiceDeParaTipoEventoDirfImpl serviceDeParaTipoEventoDirfImpl;
    final ServiceItemMovimentoFolhaImpl serviceItemMovimentoFolhaImpl;
    final ServiceColaboradorDependenteImpl serviceColaboradorDependenteImpl;
    final HelperColaborador helperColab;

    public AuxRateioValoresDirfImpl(ServiceDeParaTipoEventoDirfImpl serviceDeParaTipoEventoDirfImpl, ServiceItemMovimentoFolhaImpl serviceItemMovimentoFolhaImpl, ServiceColaboradorDependenteImpl serviceColaboradorDependenteImpl, HelperColaborador helperColab) {
        this.serviceDeParaTipoEventoDirfImpl = serviceDeParaTipoEventoDirfImpl;
        this.serviceItemMovimentoFolhaImpl = serviceItemMovimentoFolhaImpl;
        this.serviceColaboradorDependenteImpl = serviceColaboradorDependenteImpl;
        this.helperColab = helperColab;
    }

    public List<DTOItemCadastroRateioValorPlanoSaude> buscarColaboradoresPlanoSaude(DTOCadastroRateioValorPlanoSaude dto, Date periodo, Empresa empresa) {
        List<DeParaTipoEventoDirf> deParaTipoEventoDirf = this.serviceDeParaTipoEventoDirfImpl.getDeParaTipoEventoDirfByEventAndCodigoTipoEventoDirf(dto.getEventoPlanoSaudeIdentificador(), "PSE");
        if (!AuxRateioValoresDirfImpl.isWithData(deParaTipoEventoDirf)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1107.006"));
        }
        List<HashMap> colaboradores = this.serviceItemMovimentoFolhaImpl.getItemMovimentoFolhaByAberturaPeriodoDataFinalAndTipoCalculoEventoAndEmpresa(dto.getEventoPlanoSaudeIdentificador(), empresa.getIdentificador(), periodo);
        List<DTOItemCadastroRateioValorPlanoSaude> itemCadastroRateioValorPlanoSaude = colaboradores.stream().map(i -> {
            DTOItemCadastroRateioValorPlanoSaude item = new DTOItemCadastroRateioValorPlanoSaude();
            item.setValorTotalDescontoPlanoSaude((Double)i.get("valor"));
            item.setColaboradorIdentificador((Long)i.get("idColaborador"));
            item.setColaborador((String)i.get("nomeColaborador"));
            item.setNumeroRegistro((String)i.get("numeroRegistro"));
            item.setValorPlanoSaudeTitular((Double)i.get("valor"));
            item.setItensDepentendes(this.getDependentePlanoSaude((Long)i.get("idColaborador"), periodo));
            return item;
        }).collect(Collectors.toList());
        return itemCadastroRateioValorPlanoSaude;
    }

    public List<DTOItemCadastroDependentePlanoSaude> getDependentePlanoSaude(Long idColaborador, Date periodo) {
        List deps = this.serviceColaboradorDependenteImpl.getDependentes(idColaborador);
        deps = this.helperColab.getDependentesPlanoSaude(deps, periodo);
        List<DTOItemCadastroDependentePlanoSaude> listItemCadastroDependentePlanoSaude = deps.stream().map(i -> {
            DTOItemCadastroDependentePlanoSaude item = new DTOItemCadastroDependentePlanoSaude();
            item.setDependenteIdentificador(i.getIdentificador());
            item.setDependente(i.getNomeDependente());
            item.setValorPlanoDependente(Double.valueOf(0.0));
            return item;
        }).collect(Collectors.toList());
        return listItemCadastroDependentePlanoSaude;
    }

    public List<DTOItemCadastroRateioPensaoAlimenticia> buscarColaboradoresPensao(DTOCadastroRateioPensaoAlimenticia dto, Date periodo) {
        List<HashMap> colaboradores = this.serviceItemMovimentoFolhaImpl.getItemMovimentoFolhaByAberturaPeriodoDataFinalAndTipoCalculoEventoAndTipoCalculo(dto.getEventoPensaoIdentificador(), dto.getTipoCalculoFolhaIdentificador(), periodo);
        List<DTOItemCadastroRateioPensaoAlimenticia> listItemCadastroRateioPensaoAlimenticia = colaboradores.stream().map(i -> {
            List<DTOItemRateioBeneficiarioPensao> beneficiarioPensaoAlimenticia = this.getBeneficiarios((Long)i.get("idColaborador"), periodo);
            if (!AuxRateioValoresDirfImpl.isWithData(beneficiarioPensaoAlimenticia)) {
                return null;
            }
            DTOItemCadastroRateioPensaoAlimenticia item = new DTOItemCadastroRateioPensaoAlimenticia();
            item.setColaboradorIdentificador((Long)i.get("idColaborador"));
            item.setColaborador((String)i.get("nomeColaborador"));
            item.setNumeroRegistro((String)i.get("numeroRegistro"));
            item.setValorTotalPensao((Double)i.get("valor"));
            item.setRateioBeneficiario(beneficiarioPensaoAlimenticia);
            return item;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return listItemCadastroRateioPensaoAlimenticia;
    }

    private List<DTOItemRateioBeneficiarioPensao> getBeneficiarios(Long idColaborador, Date periodo) {
        List deps = this.serviceColaboradorDependenteImpl.getDependentes(idColaborador);
        deps = this.helperColab.getDependentesPensao(deps, periodo);
        List<DTOItemRateioBeneficiarioPensao> listItemRateioBeneficiarioPensao = deps.stream().map(i -> {
            DTOItemRateioBeneficiarioPensao item = new DTOItemRateioBeneficiarioPensao();
            item.setBeneficiarioPensaoIdentificador(i.getIdentificador());
            item.setBeneficiarioPensao(i.getNomeDependente());
            item.setValorPensao(Double.valueOf(0.0));
            return item;
        }).collect(Collectors.toList());
        return listItemRateioBeneficiarioPensao;
    }
}

