/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.rateiovaloresdirf;

import com.touchcomp.basementor.helper.impl.colaborador.HelperColaborador;
import com.touchcomp.basementor.model.vo.CadastroRateioPensaoAlimenticia;
import com.touchcomp.basementor.model.vo.CadastroRateioValorPlanoSaude;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.RateioValoresDirf;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoRateioValoresDirfImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.colaboradordependente.ServiceColaboradorDependenteImpl;
import com.touchcomp.basementorservice.service.impl.deparatipoeventodirf.ServiceDeParaTipoEventoDirfImpl;
import com.touchcomp.basementorservice.service.impl.itemmovimentofolha.ServiceItemMovimentoFolhaImpl;
import com.touchcomp.basementorservice.service.impl.rateiovaloresdirf.AuxRateioValoresDirfImpl;
import com.touchcomp.basementorservice.service.impl.tipocalculo.ServiceTipoCalculoImpl;
import com.touchcomp.basementorservice.service.impl.tipocalculoevento.ServiceTipoCalculoEventoImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchvomodel.vo.cadastrorateiopensaoalimenticia.web.DTOCadastroRateioPensaoAlimenticia;
import com.touchcomp.touchvomodel.vo.cadastrorateiovalorplanosaude.web.DTOCadastroRateioValorPlanoSaude;
import com.touchcomp.touchvomodel.vo.itemcadastrorateiovalorplanosaude.web.DTOItemCadastroRateioValorPlanoSaude;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class ServiceRateioValoresDirfImpl
extends ServiceGenericEntityImpl<RateioValoresDirf, Long, DaoRateioValoresDirfImpl> {
    final ServiceDeParaTipoEventoDirfImpl serviceDeParaTipoEventoDirfImpl;
    final ServiceItemMovimentoFolhaImpl serviceItemMovimentoFolhaImpl;
    final ServiceTipoCalculoEventoImpl serviceTipoCalculoEventoImpl;
    final ServiceColaboradorImpl serviceColaboradorImpl;
    final ServiceTipoCalculoImpl serviceTipoCalculoImpl;
    final ServiceColaboradorDependenteImpl serviceColaboradorDependenteImpl;

    public ServiceRateioValoresDirfImpl(ServiceDeParaTipoEventoDirfImpl serviceDeParaTipoEventoDirfImpl, ServiceItemMovimentoFolhaImpl serviceItemMovimentoFolhaImpl, ServiceTipoCalculoEventoImpl serviceTipoCalculoEventoImpl, ServiceColaboradorImpl serviceColaboradorImpl, ServiceTipoCalculoImpl serviceTipoCalculoImpl, ServiceColaboradorDependenteImpl serviceColaboradorDependenteImpl, DaoRateioValoresDirfImpl genericDao) {
        super(genericDao);
        this.serviceDeParaTipoEventoDirfImpl = serviceDeParaTipoEventoDirfImpl;
        this.serviceItemMovimentoFolhaImpl = serviceItemMovimentoFolhaImpl;
        this.serviceTipoCalculoEventoImpl = serviceTipoCalculoEventoImpl;
        this.serviceColaboradorImpl = serviceColaboradorImpl;
        this.serviceTipoCalculoImpl = serviceTipoCalculoImpl;
        this.serviceColaboradorDependenteImpl = serviceColaboradorDependenteImpl;
    }

    @Override
    public RateioValoresDirf beforeSaveEntity(RateioValoresDirf vo) {
        vo.setPeriodoApuracao(ToolDate.getLastDateOnMonth((Date)vo.getPeriodoApuracao()));
        vo.getValoresPlanoSaude().forEach(i -> {
            i.setRateioValoresDirf(vo);
            i.getItensRateio().forEach(itensRateio -> {
                itensRateio.setRateioPlanoSaude(i);
                itensRateio.getItensDepentendes().forEach(itemDep -> itemDep.setItemCadastroRateio(itensRateio));
            });
        });
        vo.getValoresPensao().forEach(i -> {
            i.setRateioValoresDirf(vo);
            i.getItensCadastroPensao().forEach(itensPensao -> {
                itensPensao.setRateioPensao(i);
                itensPensao.getRateioBeneficiario().forEach(itemBenef -> itemBenef.setItemRateioPensao(itensPensao));
            });
        });
        return vo;
    }

    public List<DTOCadastroRateioValorPlanoSaude> adicionarEventoPlanoSaude(Long periodoApuracao, Long[] ids) throws ExceptionObjNotFound {
        List tipoCalculo = this.serviceTipoCalculoEventoImpl.gets(ids);
        if (this.isNull(new Date(periodoApuracao)).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1107.002"));
        }
        List cadastroRateioValorPlanoSaude = tipoCalculo.stream().map(i -> {
            CadastroRateioValorPlanoSaude item = new CadastroRateioValorPlanoSaude();
            item.setEventoPlanoSaude(i);
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(cadastroRateioValorPlanoSaude, DTOCadastroRateioValorPlanoSaude.class);
    }

    public DTOCadastroRateioValorPlanoSaude buscarColaboradoresPlanoSaude(Long periodoApuracao, DTOCadastroRateioValorPlanoSaude dto, Empresa empresa) {
        Date periodo = new Date(periodoApuracao);
        if (this.isNull(dto.getEventoPlanoSaudeIdentificador()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1107.001"));
        }
        if (this.isNull(periodo).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1107.002"));
        }
        HelperColaborador helperColaborador = new HelperColaborador();
        List<DTOItemCadastroRateioValorPlanoSaude> dtoItemCadastroRateioValorPlanoSaude = new AuxRateioValoresDirfImpl(this.serviceDeParaTipoEventoDirfImpl, this.serviceItemMovimentoFolhaImpl, this.serviceColaboradorDependenteImpl, helperColaborador).buscarColaboradoresPlanoSaude(dto, ToolDate.getLastDateOnMonth((Date)ToolDate.getLastDateOnMonth((Date)periodo)), empresa);
        if (this.isNull(dtoItemCadastroRateioValorPlanoSaude).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1107.005"));
        }
        dto.setItensRateio(dtoItemCadastroRateioValorPlanoSaude);
        return dto;
    }

    public List<DTOItemCadastroRateioValorPlanoSaude> buscarPesquisaPersonalizada(Long periodoApuracao, Long[] ids) throws ExceptionObjNotFound {
        Date periodo = new Date(periodoApuracao);
        if (this.isNull(periodo).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1107.002"));
        }
        List colaboradores = this.serviceColaboradorImpl.gets(ids);
        HelperColaborador helperColaborador = new HelperColaborador();
        List<DTOItemCadastroRateioValorPlanoSaude> itemCadastroRateioValorPlanoSaude = colaboradores.stream().map(i -> {
            DTOItemCadastroRateioValorPlanoSaude item = new DTOItemCadastroRateioValorPlanoSaude();
            Double valorPlano = 0.0;
            item.setValorTotalDescontoPlanoSaude(valorPlano);
            item.setColaboradorIdentificador(i.getIdentificador());
            item.setColaborador(i.getPessoa().getNome());
            item.setNumeroRegistro(i.getNumeroRegistro());
            item.setValorPlanoSaudeTitular(valorPlano);
            item.setItensDepentendes(new AuxRateioValoresDirfImpl(this.serviceDeParaTipoEventoDirfImpl, this.serviceItemMovimentoFolhaImpl, this.serviceColaboradorDependenteImpl, helperColaborador).getDependentePlanoSaude(i.getIdentificador(), periodo));
            return item;
        }).collect(Collectors.toList());
        return itemCadastroRateioValorPlanoSaude;
    }

    public DTOCadastroRateioPensaoAlimenticia adicionarEventoPensao(Long periodoApuracao, Long idTipoCalculoFolha, Long idTipoCalculoEvento) throws ExceptionObjNotFound {
        TipoCalculoEvento tipoCalculoEvento = (TipoCalculoEvento)this.serviceTipoCalculoEventoImpl.getOrThrow(idTipoCalculoEvento);
        TipoCalculo tipoCalculo = (TipoCalculo)this.serviceTipoCalculoImpl.getOrThrow(idTipoCalculoFolha);
        if (this.isNull(new Date(periodoApuracao)).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1107.002"));
        }
        CadastroRateioPensaoAlimenticia cadastroRateio = new CadastroRateioPensaoAlimenticia();
        cadastroRateio.setTipoCalculoFolha(tipoCalculo);
        cadastroRateio.setEventoPensao(tipoCalculoEvento);
        return this.buildToDTOGeneric(cadastroRateio, DTOCadastroRateioPensaoAlimenticia.class);
    }

    public DTOCadastroRateioPensaoAlimenticia buscarColaboradoresPensao(Long periodoApuracao, DTOCadastroRateioPensaoAlimenticia dto) {
        Date periodo = new Date(periodoApuracao);
        if (this.isNull(dto.getEventoPensaoIdentificador()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1107.003"));
        }
        if (this.isNull(periodo).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1107.002"));
        }
        if (this.isNull(dto.getTipoCalculoFolhaIdentificador()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1107.004"));
        }
        HelperColaborador helperColaborador = new HelperColaborador();
        dto.setItensCadastroPensao(new AuxRateioValoresDirfImpl(this.serviceDeParaTipoEventoDirfImpl, this.serviceItemMovimentoFolhaImpl, this.serviceColaboradorDependenteImpl, helperColaborador).buscarColaboradoresPensao(dto, ToolDate.getLastDateOnMonth((Date)periodo)));
        return dto;
    }
}

