/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.recisao;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Evento;
import com.touchcomp.basementor.model.vo.ExportacaoArquivoConveniosFolha;
import com.touchcomp.basementor.model.vo.ItemMovimentoRescisao;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.parse.ExceptionParseObject;
import com.touchcomp.basementorservice.helpers.impl.rescisao.HelperRescisao;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.evento.ServiceEventoImpl;
import com.touchcomp.basementorservice.service.impl.recisao.ServiceRecisaoImpl;
import com.touchcomp.basementortools.tools.textfile.genericreader.ToolTextGenericFileReader;
import com.touchcomp.basementortools.tools.textfile.genericreader.model.TextLineConfig;
import com.touchcomp.basementortools.tools.textfile.genericreader.model.TextLineGenericReader;
import com.touchcomp.basementortools.tools.textfile.genericreader.model.TextLineRegGenericReader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCompImportacaoArquivoCriacaoItemMovimentoRescisao
extends ServiceGenericImpl {
    @Autowired
    ServiceRecisaoImpl serviceRecisao;
    @Autowired
    ServiceEventoImpl serviceEvento;

    public List<Recisao> importarArquivoCriacaoItemMovimentoRescisao(File file, ExportacaoArquivoConveniosFolha exportacaoArquivoConveniosFolha) throws ExceptionIO, ExceptionParseObject {
        ToolTextGenericFileReader t = this.lerArquivo(file, exportacaoArquivoConveniosFolha);
        ArrayList<Recisao> listRescisao = new ArrayList<Recisao>();
        for (TextLineGenericReader textLineGenericReader : t.getLines()) {
            Evento evento;
            textLineGenericReader.getReader().setDecSeparator(Character.valueOf('.'));
            String numeroRegistro = ((TextLineRegGenericReader)textLineGenericReader.getReg("numeroRegistro").get()).getData().trim();
            Double referencia = ((TextLineRegGenericReader)textLineGenericReader.getReg("referencia").get()).asDouble(2);
            Long codigoTipoCalculoEvento = ((TextLineRegGenericReader)textLineGenericReader.getReg("codigoTipoCalculoEvento").get()).asLong();
            Recisao rescisao = this.verificarExistRescicaoNumeroRegistro(listRescisao, numeroRegistro);
            if (!this.verificarExisteItemMovimentoRescisaoComTipoCalculoEvento(rescisao, evento = this.serviceEvento.pesquisarEventoPorCodigo(codigoTipoCalculoEvento), referencia).booleanValue()) continue;
            rescisao.getItemRescisao().add(new HelperRescisao().criarItemMovimentoRescisao(rescisao, evento, codigoTipoCalculoEvento, referencia));
        }
        return listRescisao;
    }

    private ToolTextGenericFileReader lerArquivo(File file, ExportacaoArquivoConveniosFolha exportacaoArquivoConveniosFolha) throws ExceptionIO {
        TextLineConfig readerConfig = new TextLineConfig();
        TextLineConfig.Line line = readerConfig.newLine();
        TextLineConfig.Reg reg1 = new TextLineConfig.Reg("numeroRegistro", Integer.parseInt(exportacaoArquivoConveniosFolha.getPosInicialColab()), Integer.parseInt(exportacaoArquivoConveniosFolha.getPosFinalColab()));
        line.addReg(new TextLineConfig.Reg[]{reg1});
        TextLineConfig.Reg reg2 = new TextLineConfig.Reg("referencia", Integer.parseInt(exportacaoArquivoConveniosFolha.getPosInicialValor()), Integer.parseInt(exportacaoArquivoConveniosFolha.getPosFinalValor()));
        line.addReg(new TextLineConfig.Reg[]{reg2});
        TextLineConfig.Reg reg3 = new TextLineConfig.Reg("codigoTipoCalculoEvento", Integer.parseInt(exportacaoArquivoConveniosFolha.getPosInicialValorA()), Integer.parseInt(exportacaoArquivoConveniosFolha.getPosFinalValorA()));
        line.addReg(new TextLineConfig.Reg[]{reg3});
        return new ToolTextGenericFileReader(file, readerConfig);
    }

    private Recisao verificarExistRescicaoNumeroRegistro(List<Recisao> listRescisao, String numeroRegistro) {
        for (Recisao rescisao : listRescisao) {
            if (!this.isEquals(rescisao.getColaborador().getNumeroRegistro(), numeroRegistro)) continue;
            return rescisao;
        }
        Recisao rescisao = this.serviceRecisao.pesquisarRecisaoPorColaboradorNumeroRegistro(numeroRegistro);
        listRescisao.add(rescisao);
        return rescisao;
    }

    private Boolean verificarExisteItemMovimentoRescisaoComTipoCalculoEvento(Recisao rescisao, Evento evento, Double referencia) {
        for (ItemMovimentoRescisao itemMovimentoRescisao : rescisao.getItemRescisao()) {
            if (!this.isEquals(itemMovimentoRescisao.getEventoColaborador().getTipoCalculoEvento(), evento.getTipoCalculoEvento().getFirst())) continue;
            itemMovimentoRescisao.setInformarValor(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            itemMovimentoRescisao.setReferencia(referencia);
            return false;
        }
        return true;
    }
}

