/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.recisao;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemMovimentoRescisao;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementorclientwebservices.ponto.model.demissao.DTOPontoDemissao;
import com.touchcomp.basementorservice.dao.impl.DaoRecisaoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.touchvomodel.vo.recisao.web.DTORecisao;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceRecisaoImpl
extends ServiceGenericEntityImpl<Recisao, Long, DaoRecisaoImpl> {
    @Autowired
    public ServiceRecisaoImpl(DaoRecisaoImpl dao) {
        super(dao);
    }

    @Override
    public Recisao beforeSaveEntity(Recisao vo) {
        if (ServiceRecisaoImpl.isWithData(vo.getMediaRecisao())) {
            vo.getMediaRecisao().forEach(i -> i.setRecisao(vo));
        }
        if (ServiceRecisaoImpl.isWithData(vo.getMediasFeriasVencidas())) {
            vo.getMediasFeriasVencidas().forEach(i -> i.setRecisao(vo));
        }
        if (ServiceRecisaoImpl.isWithData(vo.getItemRescisao())) {
            for (ItemMovimentoRescisao item : vo.getItemRescisao()) {
                item.setRecisao(vo);
                if (!ServiceRecisaoImpl.isWithData(item.getIntegracoesBdHoras())) continue;
                item.getIntegracoesBdHoras().forEach(i -> i.setItemRecisao(item));
            }
        }
        return vo;
    }

    public Integer findAfastamentoMedidaProvisoria(Colaborador colaborador, Date dataInicio, Date dataFinal) {
        return ((DaoRecisaoImpl)this.getGenericDao()).findAfastamentoMedidaProvisoria(colaborador, dataInicio, dataFinal);
    }

    public List<DTORecisao> getRecisaoPorColaborador(Long idColaborador) {
        return this.buildToDTOGeneric(((DaoRecisaoImpl)this.getGenericDao()).getRecisaoPorColaborador(idColaborador), DTORecisao.class);
    }

    public List<HashMap> getDetalhamentoImpostoByPeriodoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        return ((DaoRecisaoImpl)this.getGenericDao()).getDetalhamentoImpostoByPeriodoGrupoEmpresa(dataPeriodo, grupoEmpresa);
    }

    public Recisao getRecisaoByAvisoTrabalhado(Long identificador) {
        return ((DaoRecisaoImpl)this.getGenericDao()).getRecisaoByAvisoTrabalhado(identificador);
    }

    public List<Recisao> findRecisoesSemEventosESocial(OpcoesESocial opcoes, GrupoEmpresa grupo) {
        return ((DaoRecisaoImpl)this.getGenericDao()).findRecisoesSemEventosESocial(opcoes, grupo);
    }

    public List<Recisao> findMovimentosS1210(Date dataInicial, Date dataFinal, GrupoEmpresa grupo) {
        return ((DaoRecisaoImpl)this.getGenericDao()).findMovimentosS1210(dataInicial, dataFinal, grupo);
    }

    public List<DTOPontoDemissao> findRescisoesPonto(Date dataBaseSincDados, Date dataUltimaSincronizacao) {
        return ((DaoRecisaoImpl)this.getGenericDao()).findRescisoesPonto(dataBaseSincDados, dataUltimaSincronizacao);
    }

    public List<Recisao> findRecisaoPorDataPagamentoEmpresa(Date dataPagamento, Empresa empresa) {
        return ((DaoRecisaoImpl)this.getGenericDao()).findRecisaoPorDataPagamentoEmpresa(dataPagamento, empresa);
    }

    public Recisao pesquisarRecisaoPorColaboradorNumeroRegistro(String numeroRegistro) {
        return ((DaoRecisaoImpl)this.getGenericDao()).pesquisarRecisaoPorColaboradorNumeroRegistro(numeroRegistro);
    }
}

