/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.reinfaquisicaoprodrural;

import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocClienteProducaoRural;
import com.touchcomp.basementor.model.vo.EsocFornecedorProducaoRural;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.NotaAquisicaoProdRural;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.NotaPropriaAquisicaoProdRural;
import com.touchcomp.basementor.model.vo.ReinfAquisicaoProdRural;
import com.touchcomp.basementorservice.dao.impl.DaoReinfAquisicaoProdRuralImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceReinfAquisicaoProdRuralImpl
extends ServiceGenericEntityImpl<ReinfAquisicaoProdRural, Long, DaoReinfAquisicaoProdRuralImpl> {
    @Autowired
    public ServiceReinfAquisicaoProdRuralImpl(DaoReinfAquisicaoProdRuralImpl dao) {
        super(dao);
    }

    @Override
    public ReinfAquisicaoProdRural beforeSave(ReinfAquisicaoProdRural aux) {
        aux.getClienteProdRural().forEach(i -> {
            i.setReinfAquisicao(aux);
            i.getNotas().forEach(n -> n.setCliente(i));
        });
        aux.getFornecedorProdRural().forEach(i -> {
            i.setReinfAquisicao(aux);
            i.getNotasAqProdRural().forEach(n -> n.setFornecedorProdRural(i));
        });
        return aux;
    }

    public List<EsocFornecedorProducaoRural> findNotasTerceirosProdRural(Date inicialPeriodo, Date finalPeriodo, Empresa emp) {
        List<NotaFiscalTerceiros> notas = ((DaoReinfAquisicaoProdRuralImpl)this.getDao()).findNotasTerceirosProdRural(inicialPeriodo, finalPeriodo, emp);
        return this.processarNotasTerceiros(notas);
    }

    private List<EsocFornecedorProducaoRural> processarNotasTerceiros(List<NotaFiscalTerceiros> notas) {
        ArrayList<EsocFornecedorProducaoRural> res = new ArrayList<EsocFornecedorProducaoRural>();
        List<NotaFiscalTerceiros> notasPF = notas.stream().filter(n -> this.isEquals(n.getUnidadeFatFornecedor().getFornecedor().getPessoa().getComplemento().getCnpj().length(), 11)).collect(Collectors.toList());
        HashSet fornecedores = new HashSet();
        notasPF.forEach(n -> fornecedores.add(n.getUnidadeFatFornecedor().getFornecedor()));
        for (Fornecedor f : fornecedores) {
            EsocFornecedorProducaoRural esoc = new EsocFornecedorProducaoRural(f);
            List<NotaFiscalTerceiros> notasFor = notasPF.stream().filter(n -> this.isEquals(n.getUnidadeFatFornecedor().getFornecedor(), f)).collect(Collectors.toList());
            notasFor.forEach(n -> esoc.getNotasAqProdRural().add(new NotaAquisicaoProdRural(n, esoc)));
            esoc.setValorBrutoAquisicao(Double.valueOf(esoc.getNotasAqProdRural().stream().mapToDouble(m -> m.getNotaTerceiros().getValoresNfTerceiros().getValorTotal()).sum()));
            res.add(esoc);
        }
        return res;
    }

    public List<EsocClienteProducaoRural> findNotasPropriaProdRural(Date inicialPeriodo, Date finalPeriodo, Empresa emp) {
        List<NotaFiscalPropria> notas = ((DaoReinfAquisicaoProdRuralImpl)this.getDao()).findNotasPropriaProdRural(inicialPeriodo, finalPeriodo, emp);
        return this.processarNotasProprias(notas);
    }

    private List<EsocClienteProducaoRural> processarNotasProprias(List<NotaFiscalPropria> notas) {
        ArrayList<EsocClienteProducaoRural> res = new ArrayList<EsocClienteProducaoRural>();
        List<NotaFiscalPropria> notasPF = notas.stream().filter(n -> this.isEquals(n.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getCnpj().length(), 11)).collect(Collectors.toList());
        HashSet clientes = new HashSet();
        notasPF.forEach(n -> clientes.add(n.getUnidadeFatCliente().getCliente()));
        for (Cliente c : clientes) {
            EsocClienteProducaoRural esoc = new EsocClienteProducaoRural(c);
            List<NotaFiscalPropria> notasCli = notasPF.stream().filter(n -> this.isEquals(n.getUnidadeFatCliente().getCliente(), c)).collect(Collectors.toList());
            notasCli.forEach(n -> esoc.getNotas().add(new NotaPropriaAquisicaoProdRural(n, esoc)));
            esoc.setValorBrutoAquisicao(Double.valueOf(esoc.getNotas().stream().mapToDouble(m -> m.getNotaPropria().getValoresNfPropria().getValorTotal()).sum()));
            res.add(esoc);
        }
        return res;
    }
}

