/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.reinfpreevento;

import com.touchcomp.basementor.constants.enums.reinf.EnumConstTipoEventoReinf;
import com.touchcomp.basementor.constants.enums.reinf.EnumReinfFormaGerEvento;
import com.touchcomp.basementor.constants.enums.reinf.EnumReinfTipoEvento;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.ReinfIdentificacaoAmbiente;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementor.model.vo.TipoEventoReinf;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoReinfIdentificacaoAmbienteImpl;
import com.touchcomp.basementorservice.dao.impl.DaoReinfPreEventoImpl;
import com.touchcomp.basementorservice.dao.impl.DaoTipoEventoReinfImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.util.Date;

public class AuxGerarEventoAlteracaoR1000 {
    private static DaoReinfPreEventoImpl daoReinfPreEvento = (DaoReinfPreEventoImpl)ConfApplicationContext.getBean(DaoReinfPreEventoImpl.class);
    private static DaoReinfIdentificacaoAmbienteImpl daoReinfIdentificacaoAmbiente = (DaoReinfIdentificacaoAmbienteImpl)ConfApplicationContext.getBean(DaoReinfIdentificacaoAmbienteImpl.class);
    private static DaoTipoEventoReinfImpl daoTipoEventoReinf = (DaoTipoEventoReinfImpl)ConfApplicationContext.getBean(DaoTipoEventoReinfImpl.class);

    public static void gerarEventoAlteracaoR1000(R1000 opcoesReinf, Usuario usuario, String ambiente, Date dataInicial, Date dataFinal) throws ExceptionObjectNotFound {
        if (opcoesReinf.getPreEventosReinf() == null || opcoesReinf.getPreEventosReinf().isEmpty()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1718.001", new Object[]{opcoesReinf}));
        }
        for (ReinfPreEvento esocPreEvento : opcoesReinf.getPreEventosReinf()) {
            if (!esocPreEvento.getEmpresa().equals((Object)opcoesReinf.getEmpresa()) || esocPreEvento.getEventoPosterior() != null || !esocPreEvento.getTipoAmbiente().getCodigo().toString().equals(ambiente)) continue;
            if (esocPreEvento.getReinfEvento() == null || esocPreEvento.getReinfEvento().getNrRecibo() == null || esocPreEvento.getReinfEvento().getNrRecibo().isEmpty()) {
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1718.002", new Object[]{opcoesReinf}));
            }
            ReinfPreEvento newPreEvento = AuxGerarEventoAlteracaoR1000.createNewPreEvento(opcoesReinf, usuario, ambiente, dataInicial, dataFinal);
            newPreEvento.setTipoEvento(Short.valueOf(EnumReinfTipoEvento.TIPO_EVENTO_ALTERACAO.value));
            newPreEvento.setEventoAnterior(esocPreEvento);
            newPreEvento = daoReinfPreEvento.saveOrUpdate(newPreEvento);
            esocPreEvento.setEventoPosterior(newPreEvento);
            daoReinfPreEvento.saveOrUpdate(esocPreEvento);
            return;
        }
    }

    private static ReinfPreEvento createNewPreEvento(R1000 opcoesReinf, Usuario usuario, String tipoAmbiente, Date dataInicial, Date dataFinal) {
        ReinfPreEvento pre = new ReinfPreEvento();
        pre.setDataCadastro(new Date());
        pre.setDataInicioValidade(dataInicial);
        pre.setDataFimVal(dataFinal);
        pre.setTipoAmbiente(AuxGerarEventoAlteracaoR1000.getTipoAmbiente(tipoAmbiente));
        pre.setDesativarEnvio(Short.valueOf((short)0));
        pre.setEmpresa(opcoesReinf.getEmpresa());
        pre.setFormaGeracao(Short.valueOf(EnumReinfFormaGerEvento.TIPO_EVENTO_AUTOMATICO.value));
        pre.setUsuario(usuario);
        pre.setR1000(opcoesReinf);
        pre.setTipoEventoReinf(AuxGerarEventoAlteracaoR1000.getTipoEventoReinf(EnumConstTipoEventoReinf.R1000.getEnumId()));
        pre.setEventoRetificacao(Short.valueOf((short)1));
        return pre;
    }

    private static ReinfIdentificacaoAmbiente getTipoAmbiente(String tipoProducao) {
        return daoReinfIdentificacaoAmbiente.findByCodigo(tipoProducao);
    }

    private static TipoEventoReinf getTipoEventoReinf(String codigo) {
        return daoTipoEventoReinf.findByCodigo(codigo);
    }
}

