/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.reinfpreevento;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocClienteProducaoRural;
import com.touchcomp.basementor.model.vo.EsocFornecedorProducaoRural;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfIdentificacaoAmbiente;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementor.model.vo.TipoEventoReinf;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoReinfPreEventoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.reinfpreevento.UtilGerarEventoAlteracao;
import com.touchcomp.basementorservice.service.impl.reinfpreevento.UtilGerarEventoExclusao;
import com.touchcomp.basementorservice.service.impl.reinfpreevento.UtilGerarEventoInclusao;
import com.touchcomp.basementorservice.service.interfaces.ServiceReinfPreEvento;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ServiceReinfPreEventoImpl
extends ServiceGenericEntityImpl<ReinfPreEvento, Long, DaoReinfPreEventoImpl>
implements ServiceReinfPreEvento {
    @Autowired
    public ServiceReinfPreEventoImpl(DaoReinfPreEventoImpl genericDao) {
        super(genericDao);
    }

    @Override
    public List<ReinfPreEvento> getPreEventosNaoEnviados(Empresa empresa, ReinfIdentificacaoAmbiente tipoAmbiente, TipoEventoReinf tipoEvento) {
        return ((DaoReinfPreEventoImpl)this.getGenericDao()).getPreEventosNaoEnviados(empresa, tipoAmbiente, tipoEvento);
    }

    public List<ReinfPreEvento> getPreEventosNaoEnviados(Empresa empresa, ReinfIdentificacaoAmbiente tipoAmbiente, TipoEventoReinf tipoEvento, Date periodo, Pageable page) {
        return ((DaoReinfPreEventoImpl)this.getGenericDao()).getPreEventosNaoEnviados(empresa, tipoAmbiente, tipoEvento, periodo, page);
    }

    public List<ReinfEvento> findEventosGeradosEnviados(Empresa logedEmpresa, ReinfIdentificacaoAmbiente ambiente, TipoEventoReinf tipoEvento, Date periodo, Pageable page) {
        return ((DaoReinfPreEventoImpl)this.getGenericDao()).findEventosGeradosEnviados(logedEmpresa, ambiente, tipoEvento, periodo, page);
    }

    @Override
    public Object criarPreEventos(Object vo, Usuario usuario, Empresa empresa) {
        return UtilGerarEventoInclusao.gerarPreEventoReinf(vo, usuario, empresa);
    }

    @Override
    public List<EsocClienteProducaoRural> criarPreEventosCliente(List<EsocClienteProducaoRural> vo, Usuario usuario, Empresa empresa) {
        return UtilGerarEventoInclusao.gerarPreEventoReinfCliente(vo, usuario, empresa);
    }

    @Override
    public List<EsocFornecedorProducaoRural> criarPreEventosFornecedor(List<EsocFornecedorProducaoRural> vo, Usuario usuario, Empresa empresa) {
        return UtilGerarEventoInclusao.gerarPreEventoReinfFornecedor(vo, usuario, empresa);
    }

    @Override
    public void criarPreEventosAlteracaoRetificacao(Object vo, Usuario usuario, String ambiente, Date dataInicial, Date dataFinal) throws ExceptionObjectNotFound {
        new UtilGerarEventoAlteracao().gerarEventoAlteracao(vo, usuario, ambiente, dataInicial, dataFinal);
    }

    @Override
    public void criarPreEventosExclusao(Object vo, Usuario usuario, String ambiente, Date dataInicial, Date dataFinal) throws ExceptionObjectNotFound {
        new UtilGerarEventoExclusao().gerarEventoExclusao(vo, usuario, ambiente, dataInicial, dataFinal);
    }

    @Override
    public List<ReinfPreEvento> findTodosEventosProducaoRestrita(GrupoEmpresa grupoEmpresa, ReinfIdentificacaoAmbiente tipoAmbiente) {
        return ((DaoReinfPreEventoImpl)this.getGenericDao()).findTodosEventosProducaoRestrita(grupoEmpresa, tipoAmbiente);
    }
}

