/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.reinfr2060;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementor.model.vo.ReinfR2060;
import com.touchcomp.basementor.model.vo.ReinfR2060Ajuste;
import com.touchcomp.basementor.model.vo.ReinfR2060Item;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoReinfR2060Impl;
import com.touchcomp.basementorservice.helpers.impl.reinfr2060.HelperReinfR2060;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.reinfpreevento.ServiceReinfPreEventoImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.reinfr2060.web.DTOReinfR2060;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceReinfR2060Impl
extends ServiceGenericEntityImpl<ReinfR2060, Long, DaoReinfR2060Impl> {
    ServiceReinfPreEventoImpl serviceReinfPreEvento;
    HelperReinfR2060 helper;

    @Autowired
    public ServiceReinfR2060Impl(DaoReinfR2060Impl dao, ServiceReinfPreEventoImpl serviceReinfPreEvento, HelperReinfR2060 helper) {
        super(dao);
        this.serviceReinfPreEvento = serviceReinfPreEvento;
        this.helper = helper;
    }

    @Override
    public ReinfR2060 beforeSaveEntity(ReinfR2060 entity) {
        if (!TMethods.isAffirmative((Number)entity.getEmpresa().getEmpresaDados().getMatriz())) {
            throw new ExceptionRuntimeBase("E.ERP.1720.001");
        }
        if (ServiceReinfR2060Impl.isWithData(entity.getItens())) {
            for (ReinfR2060Item item : entity.getItens()) {
                item.setR2060(entity);
                if (!ServiceReinfR2060Impl.isWithData(item.getAjustes())) continue;
                item.getAjustes().forEach(i -> i.setR2060Item(item));
            }
        }
        return entity;
    }

    @Override
    public ReinfR2060 beforeDeleteEntity(ReinfR2060 entity) {
        if (ServiceReinfR2060Impl.isWithData(entity.getPreEventosReinf())) {
            for (ReinfPreEvento r : entity.getPreEventosReinf()) {
                if (!this.isNotNull(r.getReinfEvento()).booleanValue() || !this.isEquals(r.getReinfEvento().getStatus(), EnumConstantsMentorSimNao.NAO.getValue())) continue;
                throw new ExceptionRuntimeBase("E.ERP.1720.002");
            }
        }
        return entity;
    }

    @Override
    public boolean deleteOnly(ReinfR2060 entity) {
        return this.deletarReinfE2060NaoEnviada(entity);
    }

    public ReinfR2060 buildEventos(ReinfR2060 entity, Usuario usuario, Empresa empresa) {
        return (ReinfR2060)this.serviceReinfPreEvento.criarPreEventos(entity, usuario, empresa);
    }

    public boolean deletarReinfE2060NaoEnviada(ReinfR2060 vo) {
        if (ServiceReinfR2060Impl.isWithData(vo.getPreEventosReinf())) {
            List eventos = vo.getPreEventosReinf();
            vo.setPreEventosReinf(new ArrayList());
            for (ReinfPreEvento r : eventos) {
                r.setR2060(null);
                this.serviceReinfPreEvento.delete(r);
            }
        }
        return ((DaoReinfR2060Impl)this.getDao()).delete(vo);
    }

    public DTOReinfR2060.DTOReinfR2060Ajuste novoAjuste() {
        return this.buildToDTOGeneric(new ReinfR2060Ajuste(), DTOReinfR2060.DTOReinfR2060Ajuste.class);
    }

    public DTOReinfR2060.DTOReinfR2060Item novoItem() {
        return this.buildToDTOGeneric(new ReinfR2060Item(), DTOReinfR2060.DTOReinfR2060Item.class);
    }

    public void gerarEventoRetificacao(Long identificador, Short tipoAmbiente, Usuario usuario, Empresa empresa) throws ExceptionObjNotFound {
        ReinfR2060 vo = (ReinfR2060)this.getOrThrow(identificador);
        if (this.isNotNull(vo).booleanValue()) {
            if (this.isEquals(tipoAmbiente, (short)1)) {
                this.serviceReinfPreEvento.criarPreEventosAlteracaoRetificacao(vo, usuario, "1", new Date(), null);
            } else if (this.isEquals(tipoAmbiente, (short)2)) {
                this.serviceReinfPreEvento.criarPreEventosAlteracaoRetificacao(vo, usuario, "2", new Date(), null);
            }
        }
    }

    public void gerarEventoExclusao(Long identificador, Short tipoAmbiente, Usuario usuario, Empresa empresa) throws ExceptionObjNotFound {
        ReinfR2060 vo = (ReinfR2060)this.getOrThrow(identificador);
        if (this.isNotNull(vo).booleanValue()) {
            if (this.isEquals(tipoAmbiente, (short)1)) {
                this.serviceReinfPreEvento.criarPreEventosExclusao(vo, usuario, "1", new Date(), null);
            } else if (this.isEquals(tipoAmbiente, (short)2)) {
                this.serviceReinfPreEvento.criarPreEventosExclusao(vo, usuario, "2", new Date(), null);
            }
        }
    }

    public DTOReinfR2060.DTOReinfR2060Item recalcularValores(DTOReinfR2060.DTOReinfR2060Item item) {
        return this.helper.recalcularValores(item);
    }
}

