/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.reinfr2099;

import com.touchcomp.basementor.capsules.impl.CapsUsuario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ReinfR2099;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoReinfR2099Impl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.reinfpreevento.ServiceReinfPreEventoImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceReinfR2099Impl
extends ServiceGenericEntityImpl<ReinfR2099, Long, DaoReinfR2099Impl> {
    @Autowired
    ServiceReinfPreEventoImpl serviceReinfPreEventoImpl;
    @Autowired
    ServiceUsuarioImpl serviceUsuarioImpl;

    @Autowired
    public ServiceReinfR2099Impl(DaoReinfR2099Impl dao) {
        super(dao);
    }

    @Override
    public ReinfR2099 beforeSaveEntity(ReinfR2099 vo) {
        if (!TMethods.isAffirmative((Number)vo.getEmpresa().getEmpresaDados().getMatriz())) {
            throw new ExceptionRuntimeBase("E.ERP.1721.001");
        }
        return vo;
    }

    public void reabrirPeriodo(Long idR2099, CapsUsuario capsUsuario) throws ExceptionObjNotFound {
        ReinfR2099 vo = (ReinfR2099)this.getOrThrow(idR2099);
        Usuario usuario = (Usuario)this.serviceUsuarioImpl.getOrThrow(capsUsuario.get());
        this.serviceReinfPreEventoImpl.criarPreEventosAlteracaoRetificacao(vo, usuario, "1", new Date(), null);
    }

    public ReinfR2099 buildEventos(ReinfR2099 vo, Usuario usuario, Empresa empresa) {
        return (ReinfR2099)this.serviceReinfPreEventoImpl.criarPreEventos(vo, usuario, empresa);
    }
}

