/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.relacionamentopessoa;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoa;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaLog;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementorservice.components.email.builders.CompEmailBuilderRelPessoa;
import com.touchcomp.basementorservice.dao.impl.DaoRelacionamentoPessoaImpl;
import com.touchcomp.basementorservice.service.impl.relacionamentopessoa.ServiceRelacionamentoPessoaImpl;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Collection;

public class CompRelacionamentoPessoa {
    private final ServiceRelacionamentoPessoaImpl service;

    public CompRelacionamentoPessoa(ServiceRelacionamentoPessoaImpl service) {
        this.service = service;
    }

    public void sendEmail(RelacionamentoPessoa rel, OpcoesRelacionamento opcoes) {
        ModeloEmail mod;
        if (TMethods.isNull((Object)opcoes).booleanValue()) {
            return;
        }
        if (TMethods.isAffirmative((Number)opcoes.getEnviarEmailAltRel())) {
            mod = opcoes.getModeloAlteracaoRel();
            Email em = CompEmailBuilderRelPessoa.get().criarEmailAlteracao(rel, mod, opcoes);
            this.sendEmail(em);
        }
        if (TMethods.isAffirmative((Number)opcoes.getEnviarEmailSol()) && TMethods.isAffirmative((Number)rel.getSolucionado())) {
            boolean tmp = false;
            if (!TMethods.isAffirmative((Number)rel.getEnviadoEmailSolucao())) {
                tmp = true;
                rel.setEnviadoEmailSolucao(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            }
            if (tmp) {
                mod = opcoes.getModeloSolucaoRel();
                this.sendEmails(rel, mod, rel.getUsuarioSolucao().getUsuarioConfiguracoes().getServidorEmail(), opcoes);
            }
            ((DaoRelacionamentoPessoaImpl)this.service.getGenericDao()).saveOrUpdate(rel);
            return;
        }
        if (TMethods.isAffirmative((Number)opcoes.getEnviarEmailAgend()) && this.relacionamentoEstaAgendado(rel).booleanValue()) {
            boolean tmp = false;
            if (!TMethods.isAffirmative((Number)rel.getEnviadoEmailAgendamento())) {
                tmp = true;
                rel.setEnviadoEmailAgendamento(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            }
            if (tmp) {
                mod = opcoes.getModeloAgendamentoRel();
                this.sendEmails(rel, mod, this.getServidorEmailUltAgendamento(rel), opcoes);
            }
            ((DaoRelacionamentoPessoaImpl)this.service.getGenericDao()).saveOrUpdate(rel);
            return;
        }
        if (TMethods.isAffirmative((Number)opcoes.getEnviarEmailCad())) {
            boolean tmp = false;
            if (!TMethods.isAffirmative((Number)rel.getEnviadoEmailCadastro())) {
                tmp = true;
                rel.setEnviadoEmailCadastro(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            }
            if (tmp) {
                mod = opcoes.getModeloCadastroRel();
                this.sendEmails(rel, mod, rel.getUsuario().getUsuarioConfiguracoes().getServidorEmail(), opcoes);
            }
            ((DaoRelacionamentoPessoaImpl)this.service.getGenericDao()).saveOrUpdate(rel);
        }
    }

    private void sendEmails(RelacionamentoPessoa rel, ModeloEmail mod, ServidorEmail server, OpcoesRelacionamento opcoes) {
        Email em = CompEmailBuilderRelPessoa.get().criarEmail(rel, mod, opcoes);
        if (TMethods.isNotNull((Object)server).booleanValue()) {
            em.setServidor(new Email.ServidorEmail(server.getServidor(), server.getServidorImap(), server.getServidorPop(), server.getEmail(), server.getSenha(), server.getPortaEmail(), server.getNaoAutenticarEmail(), server.getLogin(), server.getServerProperties(), server.getGerarArquivoExtensaoEml(), server.getDebugServer()));
            em.addDestinatarios(new String[]{server.getEmail()});
        }
        this.sendEmail(em);
    }

    private void sendEmail(Email email) {
        if (!TMethods.isWithData((Collection)email.getDestinatarios())) {
            return;
        }
        ToolSendEmail.sendEmailWhitoutException((Email)email);
    }

    private Boolean relacionamentoEstaAgendado(RelacionamentoPessoa rel) {
        if (TMethods.isWithData((Collection)rel.getAgendamentos())) {
            for (RelacionamentoPessoaLog rl : rel.getAgendamentos()) {
                if (TMethods.isAffirmative((Number)rl.getFinalizado())) continue;
                return true;
            }
        }
        return false;
    }

    private ServidorEmail getServidorEmailUltAgendamento(RelacionamentoPessoa rel) {
        if (TMethods.isWithData((Collection)rel.getAgendamentos())) {
            for (RelacionamentoPessoaLog rl : rel.getAgendamentos()) {
                if (TMethods.isAffirmative((Number)rl.getFinalizado())) continue;
                return rl.getUsuario().getUsuarioConfiguracoes().getServidorEmail();
            }
        }
        return null;
    }
}

