/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.relacionamentopessoa;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.ClassificacaoMarketing;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemInfAdicionalItemRelPes;
import com.touchcomp.basementor.model.vo.ItemModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PessoasInteressadasRelPessoa;
import com.touchcomp.basementor.model.vo.PrioridadeMarketing;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoa;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaAgEmail;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaGC;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaLog;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoRelacionamentoPessoaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.classificacaomarketing.ServiceClassificacaoMarketingImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.opcoesrelacionamento.ServiceOpcoesRelacionamentoImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementorservice.service.impl.prioridademarketing.ServicePrioridadeMarketingImpl;
import com.touchcomp.basementorservice.service.impl.relacionamentopessoa.CompRelacionamentoPessoa;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import com.touchcomp.touchvomodel.vo.iteminfadicionalitemrelpes.web.DTOItemInfAdicionalItemRelPes;
import com.touchcomp.touchvomodel.vo.relacionamentopessoa.web.DTORelacionamentoPessoa;
import com.touchcomp.touchvomodel.vo.relacionamentopessoaagemail.web.DTORelacionamentoPessoaAgEmail;
import com.touchcomp.touchvomodel.vo.relacionamentopessoagc.web.DTORelacionamentoPessoaGC;
import com.touchcomp.touchvomodel.vo.relacionamentopessoalog.web.DTORelacionamentoPessoaLog;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceRelacionamentoPessoaImpl
extends ServiceGenericEntityImpl<RelacionamentoPessoa, Long, DaoRelacionamentoPessoaImpl> {
    @Autowired
    private ServicePessoaImpl servicePessoa;
    @Autowired
    private ServiceUsuarioImpl serviceUsuario;
    @Autowired
    private ServiceGradeCorImpl serviceGradeCor;
    @Autowired
    private ServiceClassificacaoMarketingImpl serviceClassificacaoMarketing;
    @Autowired
    private ServicePrioridadeMarketingImpl servicePrioridadeMarketing;
    @Autowired
    private ServiceOpcoesRelacionamentoImpl serviceOpcoesRelacionamento;

    @Autowired
    public ServiceRelacionamentoPessoaImpl(DaoRelacionamentoPessoaImpl genericDao) {
        super(genericDao);
    }

    @Override
    public RelacionamentoPessoa beforeSaveEntity(RelacionamentoPessoa vo) {
        if (this.isNotNull(vo.getAgendamentos()).booleanValue()) {
            vo.getAgendamentos().forEach(i -> i.setRelacionamentoPessoa(vo));
        }
        if (this.isNotNull(vo.getEmailsEnviados()).booleanValue()) {
            vo.getEmailsEnviados().forEach(i -> i.setRelacionamentoPessoa(vo));
        }
        if (this.isNotNull(vo.getItensInfAdicional()).booleanValue()) {
            vo.getItensInfAdicional().forEach(i -> i.setRelacionamentoPessoa(vo));
        }
        if (this.isNotNull(vo.getProdutos()).booleanValue()) {
            vo.getProdutos().forEach(i -> i.setRelacionamentoPessoa(vo));
        }
        if (this.isNotNull(vo.getItensNotaPropria()).booleanValue()) {
            vo.getItensNotaPropria().forEach(i -> i.setRelacionamentoPessoa(vo));
        }
        if (this.isNotNull(vo.getItensNotaTerceiros()).booleanValue()) {
            vo.getItensNotaTerceiros().forEach(i -> i.setRelacionamentoPessoa(vo));
        }
        if (this.isNotNull(vo.getPessoasInteressadas()).booleanValue()) {
            vo.getPessoasInteressadas().forEach(i -> i.setRelacionamentoPessoa(vo));
        }
        if (this.isNull(vo.getNrProtocolo()).booleanValue() || vo.getNrProtocolo() <= 0L) {
            vo.setNrProtocolo(this.findNrProtocolo());
        }
        if (this.isAffimative(vo.getSolucionado())) {
            if (this.isNull(vo.getUsuarioSolucao()).booleanValue()) {
                vo.setUsuarioSolucao(vo.getUsuario());
            }
            if (this.isNull(vo.getDataSolucao()).booleanValue()) {
                vo.setDataSolucao(new Date());
            }
        }
        return vo;
    }

    @Override
    public RelacionamentoPessoa afterSaveEntity(RelacionamentoPessoa entity) {
        new CompRelacionamentoPessoa(this).sendEmail(entity, this.serviceOpcoesRelacionamento.get(entity.getEmpresa()));
        return entity;
    }

    @Transactional(readOnly=true)
    public Long findNrProtocolo() {
        return ((DaoRelacionamentoPessoaImpl)this.getGenericDao()).findNrProtocolo();
    }

    public List<DTORelacionamentoPessoa.DTOPessoasInteressadasRelPessoa> relacionarPessoasInteressadas(Long[] identificadores) {
        ArrayList<PessoasInteressadasRelPessoa> result = new ArrayList<PessoasInteressadasRelPessoa>();
        List pessoas = this.servicePessoa.gets(identificadores);
        if (ServiceRelacionamentoPessoaImpl.isWithData(pessoas)) {
            for (Pessoa p : pessoas) {
                result.add(new PessoasInteressadasRelPessoa(p));
            }
        }
        return this.buildToDTOGeneric(result, DTORelacionamentoPessoa.DTOPessoasInteressadasRelPessoa.class);
    }

    public String carregarInformacoesPessoaCrm(Long idPessoa) throws ExceptionObjNotFound {
        Pessoa pessoa = (Pessoa)this.servicePessoa.getOrThrow(idPessoa);
        if (this.isStrWithData(pessoa.getNomeFantasia())) {
            return ToolBaseMethodsVO.toString((String)"{0}, {1} - {2}", (Object[])new Object[]{pessoa.getNomeFantasia(), pessoa.getEndereco().getCidade().getDescricao(), pessoa.getEndereco().getCidade().getUf().getSigla()});
        }
        return ToolBaseMethodsVO.toString((String)"{0}, {1} - {2}", (Object[])new Object[]{pessoa.getNome(), pessoa.getEndereco().getCidade().getDescricao(), pessoa.getEndereco().getCidade().getUf().getSigla()});
    }

    public DTORelacionamentoPessoaLog criarRelacionamento(Usuario usuario, Long idUsuario) throws ExceptionObjNotFound {
        RelacionamentoPessoaLog vo = new RelacionamentoPessoaLog();
        vo.setDataAgendamento(new Date());
        vo.setFinalizado(EnumConstantsMentorSimNao.NAO.getEnumId());
        vo.setUsuario(usuario);
        vo.setUsuarioAgendamento((Usuario)this.serviceUsuario.getOrThrow(idUsuario));
        vo.setTempoDispendiado(Double.valueOf(0.0));
        vo.setDataInclusao(new Date());
        return this.buildToDTOGeneric(vo, DTORelacionamentoPessoaLog.class);
    }

    public List<DTORelacionamentoPessoaGC> criarProdutosAt(Long[] identificadores) {
        ArrayList<RelacionamentoPessoaGC> result = new ArrayList<RelacionamentoPessoaGC>();
        List grades = this.serviceGradeCor.gets(identificadores);
        if (ServiceRelacionamentoPessoaImpl.isWithData(grades)) {
            for (GradeCor gc : grades) {
                if (!this.isAffimative(gc.getProdutoGrade().getProduto().getAtivo())) continue;
                RelacionamentoPessoaGC vo = new RelacionamentoPessoaGC();
                vo.setGradeCor(gc);
                vo.setQuantidade(Double.valueOf(1.0));
                result.add(vo);
            }
        }
        return this.buildToDTOGeneric(result, DTORelacionamentoPessoaGC.class);
    }

    public List<DTOItemInfAdicionalItemRelPes> criarDadosTecnicosCrm(Long idClassificacaoMarketing) throws ExceptionObjNotFound {
        ArrayList<DTOItemInfAdicionalItemRelPes> result = new ArrayList<DTOItemInfAdicionalItemRelPes>();
        ClassificacaoMarketing classificacaoMkt = (ClassificacaoMarketing)this.serviceClassificacaoMarketing.getOrThrow(idClassificacaoMarketing);
        if (this.isNotNull(classificacaoMkt.getModeloFichaTecnica()).booleanValue()) {
            for (ItemModeloFichaTecnica item : classificacaoMkt.getModeloFichaTecnica().getItensModeloFichaTecnica()) {
                ItemInfAdicionalItemRelPes vo = new ItemInfAdicionalItemRelPes();
                vo.setItensModeloFichaTecnica(item);
                vo.setValorObrigatorio(item.getCampoObrigatorio());
                result.add(this.buildToDTOGeneric(vo, DTOItemInfAdicionalItemRelPes.class));
            }
            return result;
        }
        return null;
    }

    public DTORelacionamentoPessoaAgEmail criarAgendamentoEmail() {
        RelacionamentoPessoaAgEmail vo = new RelacionamentoPessoaAgEmail();
        vo.setAtivo(EnumConstStatusObjeto.ATIVO.getEnumId());
        vo.setNumeroCicloEnvio(EnumConstantsMentorSimNao.NAO.getEnumId());
        return this.buildToDTOGeneric(vo, DTORelacionamentoPessoaAgEmail.class);
    }

    public Date getDataPrevistaFinalizacao(Long dataRelacionamento, Long idPrioridade) throws ExceptionObjNotFound {
        if (this.isNull(dataRelacionamento).booleanValue() || this.isNull(idPrioridade).booleanValue()) {
            return null;
        }
        PrioridadeMarketing prioridade = (PrioridadeMarketing)this.servicePrioridadeMarketing.getOrThrow(idPrioridade);
        if (this.isNotNull(prioridade.getPrevisaoHoras()).booleanValue() && prioridade.getPrevisaoHoras() > 0.0) {
            return ToolDate.nextDays((Date)new Date(dataRelacionamento), (double)prioridade.getPrevisaoHoras());
        }
        return null;
    }
}

