/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.relpessoacontato;

import com.touchcomp.basementor.constants.enums.procedenciasolicitacao.EnumProcedenciaSolicitacao;
import com.touchcomp.basementor.model.vo.ClienteContSistemas;
import com.touchcomp.basementor.model.vo.LogConsultaAtendimentos;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.RelPessoaContato;
import com.touchcomp.basementor.model.vo.RelPessoaContatoLog;
import com.touchcomp.basementor.model.vo.RelPessoaContatoNota;
import com.touchcomp.basementor.model.vo.RelPessoaContatoReabert;
import com.touchcomp.basementor.model.vo.RelPessoaContatoVenda;
import com.touchcomp.basementor.model.vo.SetorUsuario;
import com.touchcomp.basementor.model.vo.StatusRelPessoaContato;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementor.model.vo.UsuarioClienteContSistemas;
import com.touchcomp.basementor.model.vo.VersaoMentor;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.components.relpessoacontato.CompRelPessoaContato;
import com.touchcomp.basementorservice.dao.impl.DaoRelPessoaContatoImpl;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapMuralAtend;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapMuralAtendDetail;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceRelPessoaContato;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.temp.centralticketstouch.DTORelPessoaTouchRes;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceRelPessoaContatoImpl
extends ServiceGenericEntityImpl<RelPessoaContato, Long, DaoRelPessoaContatoImpl>
implements ServiceRelPessoaContato {
    CompRelPessoaContato compRelPessoaContato;

    @Autowired
    public ServiceRelPessoaContatoImpl(DaoRelPessoaContatoImpl genericDao, CompRelPessoaContato compRelPessoaContato) {
        super(genericDao);
        this.compRelPessoaContato = compRelPessoaContato;
    }

    @Override
    public DaoRelPessoaContatoImpl getGenericDao() {
        return (DaoRelPessoaContatoImpl)super.getGenericDao();
    }

    @Override
    public RelPessoaContato getByNrProtocolo(Long nrProtocolo) {
        return this.getGenericDao().getByNrProtocolo(nrProtocolo);
    }

    @Override
    public List<Map<String, Object>> getAtendimentos(UsuarioClienteContSistemas user, LogConsultaAtendimentos log) {
        return this.getGenericDao().getAtendimentos(user, log);
    }

    @Override
    public Long findProximoNrProtocolo() {
        return this.getGenericDao().findProximoNrProtocolo();
    }

    @Override
    public List<Map<String, Object>> getLogAtendimentos(Long idAtendimento) {
        return this.getGenericDao().getLogAtendimentos(idAtendimento);
    }

    @Override
    public List<Map<String, Object>> getReagendamentos(Long nrProtocolo) {
        return ((DaoRelPessoaContatoImpl)this.getDao()).getReagendamentos(nrProtocolo);
    }

    public List<GenericMapValues<GenMapMuralAtend>> getAtendimentosMural(StatusAtendimento stat, SetorUsuario setor, Usuario user, Short tipoData, Date dataPrevIn, Date dataPrevFim, ClienteContSistemas cliente, Pessoa pessoaUsuarioCliente, StatusRelPessoaContato statusRelPessoaContato) {
        List<GenericMapValues<GenMapMuralAtendDetail>> values = this.isEquals((Object)stat, (Object)StatusAtendimento.EM_ATRASO) ? ((DaoRelPessoaContatoImpl)this.getDao()).getAtendimentosMuralEmAtraso(setor, user, cliente, pessoaUsuarioCliente, statusRelPessoaContato) : ((DaoRelPessoaContatoImpl)this.getDao()).getAtendimentosMural(setor, user, tipoData, dataPrevIn, dataPrevFim, cliente, pessoaUsuarioCliente, statusRelPessoaContato);
        LinkedList<GenericMapValues<GenMapMuralAtend>> dados = new LinkedList<GenericMapValues<GenMapMuralAtend>>();
        for (GenericMapValues<GenMapMuralAtendDetail> genericMapValues : values) {
            Long idProcedencia = genericMapValues.getLong(GenMapMuralAtendDetail.ID_PROCEDENCIA);
            Optional<GenericMapValues> found = dados.stream().filter(i -> ToolMethods.isEquals((Object)i.getLong(GenMapMuralAtend.ID_PROCEDENCIA), (Object)idProcedencia)).findFirst();
            GenericMapValues sel = null;
            if (!found.isPresent()) {
                sel = new GenericMapValues();
                sel.addValue(GenMapMuralAtend.ID_PROCEDENCIA, genericMapValues.getLong(GenMapMuralAtendDetail.ID_PROCEDENCIA));
                sel.addValue(GenMapMuralAtend.PROCEDENCIA, genericMapValues.getString(GenMapMuralAtendDetail.PROCEDENCIA));
                sel.addValue(GenMapMuralAtend.ATENDIMENTOS_DETALHADOS, new LinkedList());
                dados.add(sel);
            } else {
                sel = found.get();
            }
            sel.getList(GenMapMuralAtend.ATENDIMENTOS_DETALHADOS).add(genericMapValues);
        }
        for (GenericMapValues<GenMapMuralAtendDetail> genericMapValues : dados) {
            List atendimentos = genericMapValues.getList((GenMapMuralAtendDetail)((Object)GenMapMuralAtend.ATENDIMENTOS_DETALHADOS));
            Date minDateAbertura = null;
            Date minDateAgendamento = null;
            Date minDatePrevisao = null;
            Integer maxTempoUltInteracao = null;
            Long nrReagendamentos = 0L;
            for (GenericMapValues atend : atendimentos) {
                if (minDateAbertura == null || atend.getDate(GenMapMuralAtendDetail.DATA_ABERTURA) != null && atend.getDate(GenMapMuralAtendDetail.DATA_ABERTURA).before(minDateAbertura)) {
                    minDateAbertura = atend.getDate(GenMapMuralAtendDetail.DATA_ABERTURA);
                }
                if (minDateAgendamento == null || atend.getDate(GenMapMuralAtendDetail.DATA_AGENDAMENTO) != null && atend.getDate(GenMapMuralAtendDetail.DATA_AGENDAMENTO).before(minDateAgendamento)) {
                    minDateAgendamento = atend.getDate(GenMapMuralAtendDetail.DATA_AGENDAMENTO);
                }
                if (minDatePrevisao == null || atend.getDate(GenMapMuralAtendDetail.DATA_PREVISAO) != null && atend.getDate(GenMapMuralAtendDetail.DATA_PREVISAO).before(minDateAgendamento)) {
                    minDatePrevisao = atend.getDate(GenMapMuralAtendDetail.DATA_PREVISAO);
                }
                if (nrReagendamentos == null || atend.getLong(GenMapMuralAtendDetail.NR_REAGENDAMENTOS) != null && atend.getLong(GenMapMuralAtendDetail.NR_REAGENDAMENTOS) > nrReagendamentos) {
                    nrReagendamentos = atend.getLong(GenMapMuralAtendDetail.NR_REAGENDAMENTOS);
                }
                if (maxTempoUltInteracao == null || atend.getInteger(GenMapMuralAtendDetail.TEMPO_DESDE_ULT_INTERACAO) != null && atend.getInteger(GenMapMuralAtendDetail.TEMPO_DESDE_ULT_INTERACAO) > maxTempoUltInteracao) {
                    maxTempoUltInteracao = atend.getInteger(GenMapMuralAtendDetail.TEMPO_DESDE_ULT_INTERACAO);
                }
                atend.addValue(GenMapMuralAtendDetail.TEMPO_ATRASO, ToolDate.difBetweenDatesInDays((Date)atend.getDate(GenMapMuralAtendDetail.DATA_PREVISAO), (Date)new Date()));
                atend.addValue(GenMapMuralAtendDetail.TEMPO_ABERTURA, ToolDate.difBetweenDatesInDays((Date)atend.getDate(GenMapMuralAtendDetail.DATA_ABERTURA), (Date)new Date()));
                atend.addValue(GenMapMuralAtendDetail.TEMPO_AGENDAMENTO, ToolDate.difBetweenDatesInDays((Date)atend.getDate(GenMapMuralAtendDetail.DATA_AGENDAMENTO), (Date)new Date()));
            }
            genericMapValues.addValue((GenMapMuralAtendDetail)((Object)GenMapMuralAtend.NR_ATENDIMENTOS), genericMapValues.getList((GenMapMuralAtendDetail)((Object)GenMapMuralAtend.ATENDIMENTOS_DETALHADOS)).size());
            genericMapValues.addValue((GenMapMuralAtendDetail)((Object)GenMapMuralAtend.MAIOR_TEMPO_ABERTURA), ToolDate.difBetweenDatesInDays((Date)minDateAbertura, (Date)new Date()));
            genericMapValues.addValue((GenMapMuralAtendDetail)((Object)GenMapMuralAtend.MAIOR_TEMPO_AGENDAMENTO), ToolDate.difBetweenDatesInDays((Date)minDateAgendamento, (Date)new Date()));
            genericMapValues.addValue((GenMapMuralAtendDetail)((Object)GenMapMuralAtend.MAIOR_TEMPO_ATRASO), ToolDate.difBetweenDatesInDays((Date)minDatePrevisao, (Date)new Date()));
            genericMapValues.addValue((GenMapMuralAtendDetail)((Object)GenMapMuralAtend.NR_REAGENDAMENTOS), nrReagendamentos);
            genericMapValues.addValue((GenMapMuralAtendDetail)((Object)GenMapMuralAtend.TEMPO_DESDE_ULT_INTERACAO), maxTempoUltInteracao);
            Collections.sort(atendimentos, (a1, a2) -> a2.getLong(GenMapMuralAtendDetail.TEMPO_ATRASO).compareTo(a1.getLong(GenMapMuralAtendDetail.TEMPO_ATRASO)));
        }
        Collections.sort(dados, (a1, a2) -> a2.getLong(GenMapMuralAtend.MAIOR_TEMPO_ATRASO).compareTo(a1.getLong(GenMapMuralAtend.MAIOR_TEMPO_ATRASO)));
        return dados;
    }

    public List getAtendimentos(VersaoMentor versao, EnumProcedenciaSolicitacao ... tipo) {
        return ((DaoRelPessoaContatoImpl)this.getDao()).getAtendimentos(versao, tipo);
    }

    public List<RelPessoaContato> getAtendimentosAbertoTicket() {
        return ((DaoRelPessoaContatoImpl)this.getDao()).getAtendimentosAbertoTicket();
    }

    public List<RelPessoaContatoLog> getAtendimentosAgendados(Usuario user, Date dataAgend) {
        return ((DaoRelPessoaContatoImpl)this.getDao()).getAtendimentosAgendados(user, dataAgend);
    }

    public RelPessoaContato avaliarAtendimento(Long identificadorProtocolo, Double notaAtend, String observacao) throws ExceptionObjNotFound {
        RelPessoaContato rel = (RelPessoaContato)this.getOrThrow(identificadorProtocolo);
        RelPessoaContatoNota nota = rel.getNotaAtendimento();
        if (nota == null) {
            nota = new RelPessoaContatoNota();
            nota.setDataNota(new Date());
        }
        nota.setNotaAtendimento(notaAtend);
        nota.setObservacao(observacao);
        nota.setFlagTratativaNota(Short.valueOf((short)0));
        this.compRelPessoaContato.avaliaDefineStatus(rel);
        rel.setNotaAtendimento(nota);
        return this.saveOrUpdate(rel);
    }

    public void reabrirAtendimento(Long identificadorProtocolo, String motivoReabertura, UsuarioBasico user) throws ExceptionObjNotFound, ExceptionInvalidState {
        RelPessoaContato r = (RelPessoaContato)this.getOrThrow(identificadorProtocolo);
        if (r.getNotaAtendimento() != null) {
            throw new ExceptionInvalidState("E.ERP.0694.001", new Object[]{r.getNrProtocolo()});
        }
        if (!this.isAffimative(r.getFinalizado())) {
            throw new ExceptionInvalidState("E.ERP.0694.004", new Object[]{r.getNrProtocolo()});
        }
        Optional<RelPessoaContatoVenda> found = r.getVendasVinculadas().stream().filter(i -> i.getItemOutrosServicosApuracao() != null).findFirst();
        if (found.isPresent()) {
            throw new ExceptionInvalidState("E.ERP.0694.002", new Object[]{r.getNrProtocolo()});
        }
        if (r.getDataFinalizacao() != null && TDate.difBetweenDatesInDays((Date)r.getDataFinalizacao(), (Date)new Date()) > 30L) {
            throw new ExceptionInvalidState("E.ERP.0694.003", new Object[]{r.getNrProtocolo()});
        }
        RelPessoaContatoReabert reab = new RelPessoaContatoReabert();
        reab.setDataReabertura(new Date());
        reab.setInfoAdicional(motivoReabertura);
        reab.setPessoaReabertura(user.getPessoa());
        reab.setRelPessoaContato(r);
        r.getReaberturas().add(reab);
        if (!r.getAgendamentos().isEmpty()) {
            RelPessoaContatoLog last = (RelPessoaContatoLog)r.getAgendamentos().get(r.getAgendamentos().size() - 1);
            last.setFinalizado(Short.valueOf((short)0));
        }
        r.setFinalizado(Short.valueOf((short)0));
        r.setDataFinalizacao(null);
        this.compRelPessoaContato.avaliaDefineStatus(r);
        this.saveOrUpdate(r);
    }

    public List<DTORelPessoaTouchRes> getAtendimentosRes(UsuarioBasico user, String codigoCliente, String texto, Long page, Long regsPerPage) {
        return ((DaoRelPessoaContatoImpl)this.getDao()).getAtendimentosRes(user, codigoCliente, texto, page, regsPerPage);
    }

    public List<DTORelPessoaTouchRes> getAtendimentosRes(UsuarioBasico user, String codigoCliente, Short filtrarDataAbertura, Date dataAbertIn, Date dataAbertFim, Short filtrarPrevisao, Date dataPrevIn, Date dataPrevFim, Short filtrarSolucao, Date dataSolucaoIn, Date dataSolucaoFim, Short filtrarProtocolo, Long nrProtocolo, Short filtrarStatus, Short status, Long page, Long regsPerPage) {
        return ((DaoRelPessoaContatoImpl)this.getDao()).getAtendimentosRes(codigoCliente, user, filtrarDataAbertura, dataAbertIn, dataAbertFim, filtrarPrevisao, dataPrevIn, dataPrevFim, filtrarSolucao, dataSolucaoIn, dataSolucaoFim, filtrarProtocolo, nrProtocolo, filtrarStatus, status, page, regsPerPage);
    }

    public double getHorasApontadas(Usuario usuario, Date date) {
        return ((DaoRelPessoaContatoImpl)this.getDao()).getHorasApontadas(usuario, date);
    }

    public void salvaLogs(RelPessoaContatoLog logAntigo, RelPessoaContatoLog logNovo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static enum StatusAtendimento {
        EM_ATRASO,
        TODOS_ABERTO;

    }
}

