/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.representante;

import com.touchcomp.basementor.model.vo.ClassificacaoProdutoRepresentante;
import com.touchcomp.basementor.model.vo.ClassificacaoProdutos;
import com.touchcomp.basementor.model.vo.ItemRepresentanteRegiao;
import com.touchcomp.basementor.model.vo.OpcoesVendas;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.RepresentanteEmpresa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoRepresentanteImpl;
import com.touchcomp.basementorservice.helpers.impl.representante.HelperRepresentante;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.classificacaoprodutos.ServiceClassificacaoProdutosImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.regiao.ServiceRegiaoImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceRepresentante;
import com.touchcomp.touchvomodel.vo.representante.web.DTORepresentante;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceRepresentanteImpl
extends ServiceGenericEntityImpl<Representante, Long, DaoRepresentanteImpl>
implements ServiceRepresentante {
    ServiceRegiaoImpl serviceRegiao;
    ServiceEmpresaImpl serviceEmpresa;
    ServiceClassificacaoProdutosImpl serviceClassificacaoProdutos;
    HelperRepresentante helperRepresentante;

    @Autowired
    public ServiceRepresentanteImpl(DaoRepresentanteImpl genericDao, ServiceRegiaoImpl serviceRegiao, ServiceEmpresaImpl serviceEmpresa, ServiceClassificacaoProdutosImpl serviceClassificacaoProdutos, HelperRepresentante helperRepresentante) {
        super(genericDao);
        this.serviceRegiao = serviceRegiao;
        this.serviceEmpresa = serviceEmpresa;
        this.serviceClassificacaoProdutos = serviceClassificacaoProdutos;
        this.helperRepresentante = helperRepresentante;
    }

    @Override
    public Representante beforeSave(Representante vo) {
        if (this.isNotNull(vo.getItemRepresentanteRegiao()).booleanValue()) {
            vo.getItemRepresentanteRegiao().forEach(i -> i.setRepresentante(vo));
        }
        if (this.isNotNull(vo.getRepresentanteEmpresa()).booleanValue()) {
            vo.getRepresentanteEmpresa().forEach(i -> i.setRepresentante(vo));
        }
        if (this.isNotNull(vo.getGrupoRepresentantesRel()).booleanValue()) {
            vo.getGrupoRepresentantesRel().forEach(i -> i.setRepresentante(vo));
        }
        if (this.isNotNull(vo.getClassificacoes()).booleanValue()) {
            vo.getClassificacoes().forEach(i -> i.setRepresentante(vo));
        }
        return vo;
    }

    @Override
    public Representante findByIdPessoa(Long idPessoa) {
        return ((DaoRepresentanteImpl)this.getGenericDao()).findByPessoa(idPessoa);
    }

    public Representante getRepresentanteCpfCpnj(String cnpj) {
        return ((DaoRepresentanteImpl)this.getGenericDao()).getRepresentanteCpfCpnj(cnpj);
    }

    public Representante findRepresentantePorPessoa(Pessoa pessoa) {
        return ((DaoRepresentanteImpl)this.getGenericDao()).findRepresentantePorPessoa(pessoa);
    }

    public List<Representante> get(Pessoa pessoa, Short ativo) {
        return ((DaoRepresentanteImpl)this.getGenericDao()).get(pessoa, ativo);
    }

    public Representante findByUsuario(Usuario usuario) throws ExceptionObjNotFound {
        if (usuario == null || usuario.getUsuarioBasico() == null) {
            return null;
        }
        return this.findByUsuarioOrThrow(usuario.getIdentificador());
    }

    public Representante findByUsuarioOrThrow(Usuario usuario) throws ExceptionObjNotFound {
        Representante rep = this.findByUsuario(usuario);
        if (rep == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0072.002", new Object[]{usuario}));
        }
        return rep;
    }

    public Representante findByUsuarioOrThrow(Long idUsuario) throws ExceptionObjNotFound {
        Representante rep = ((DaoRepresentanteImpl)this.getDao()).findByIdUsuario(idUsuario);
        this.throwIfNull(rep, idUsuario);
        return rep;
    }

    public List<DTORepresentante.DTOItemRepresentanteRegiao> getRegiao(Long[] identificadores) throws ExceptionObjNotFound {
        List regioes = this.serviceRegiao.gets(identificadores);
        LinkedList<DTORepresentante.DTOItemRepresentanteRegiao> ret = new LinkedList<DTORepresentante.DTOItemRepresentanteRegiao>();
        if (ServiceRepresentanteImpl.isWithData(regioes)) {
            regioes.forEach(i -> ret.add(this.buildToDTOGeneric(new ItemRepresentanteRegiao(i), DTORepresentante.DTOItemRepresentanteRegiao.class)));
        }
        return ret;
    }

    public WebDTOResult<List<DTORepresentante.DTOClassificacaoProdutoRepresentante>> getClassificacaoProdutos(Long[] identificadores, OpcoesVendas opcoes) throws ExceptionObjNotFound {
        WebDTOResult result = new WebDTOResult();
        List classificacoes = this.serviceClassificacaoProdutos.gets(identificadores);
        List<ClassificacaoProdutos> filter = this.helperRepresentante.validarClassificacaoProdutos(classificacoes, opcoes);
        if (ServiceRepresentanteImpl.isWithData(filter)) {
            LinkedList ret = new LinkedList();
            filter.forEach(i -> ret.add(this.buildToDTOGeneric(new ClassificacaoProdutoRepresentante(i), DTORepresentante.DTOClassificacaoProdutoRepresentante.class)));
            result.setResult(ret);
        }
        if (!this.isEquals(filter.size(), classificacoes.size())) {
            result.addWarning("M.ERP.0072.001");
        }
        return result;
    }

    public List<DTORepresentante.DTORepresentanteEmpresa> getEmpresa(Long[] identificadores) throws ExceptionObjNotFound {
        List empresas = this.serviceEmpresa.gets(identificadores);
        LinkedList<DTORepresentante.DTORepresentanteEmpresa> ret = new LinkedList<DTORepresentante.DTORepresentanteEmpresa>();
        if (ServiceRepresentanteImpl.isWithData(empresas)) {
            empresas.forEach(i -> ret.add(this.buildToDTOGeneric(new RepresentanteEmpresa(i), DTORepresentante.DTORepresentanteEmpresa.class)));
        }
        return ret;
    }

    public Representante findByEmpresa(Long idEmpresa) throws ExceptionObjNotFound {
        Representante rep = ((DaoRepresentanteImpl)this.getDao()).findByEmpresa(idEmpresa);
        this.throwIfNull(rep, idEmpresa);
        return rep;
    }
}

