/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.requisicao;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.model.vo.BloqueioRequisicao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoEspecie;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoNaturezaRequisicao;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoSubespecie;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoRequisicaoImpl;
import com.touchcomp.basementorservice.helpers.impl.requisicao.HelperRequisicao;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.bloqueiorequisicao.ServiceBloqueioRequisicaoImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.naturezarequisicao.ServiceNaturezaRequisicaoImpl;
import com.touchcomp.touchvomodel.res.DTOEntidadeRes;
import com.touchcomp.touchvomodel.vo.lotefabricacao.web.DTORastreioLoteFabricacao;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceRequisicaoImpl
extends ServiceGenericEntityImpl<Requisicao, Long, DaoRequisicaoImpl> {
    HelperRequisicao helperRequisicao;
    ServiceEmpresaImpl serviceEmpresaImpl;
    ServiceNaturezaRequisicaoImpl serviceNaturezaRequisicaoImpl;
    ServiceBloqueioRequisicaoImpl serviceBloqueioRequisicaoImpl;

    @Autowired
    public ServiceRequisicaoImpl(DaoRequisicaoImpl dao, HelperRequisicao helperRequisicao, ServiceEmpresaImpl serviceEmpresaImpl, ServiceNaturezaRequisicaoImpl serviceNaturezaRequisicaoImpl, ServiceBloqueioRequisicaoImpl serviceBloqueioRequisicaoImpl) {
        super(dao);
        this.helperRequisicao = helperRequisicao;
        this.serviceEmpresaImpl = serviceEmpresaImpl;
        this.serviceNaturezaRequisicaoImpl = serviceNaturezaRequisicaoImpl;
        this.serviceBloqueioRequisicaoImpl = serviceBloqueioRequisicaoImpl;
    }

    public List<Requisicao> getRequisicosPorPeriodo(Date dataInicial, Date dataFinal, List<IntegracaoRequisicaoEspecie> especies, List<IntegracaoRequisicaoSubespecie> subespecies, Empresa empresa, List<IntegracaoRequisicaoNaturezaRequisicao> naturezasRequisicao) {
        return ((DaoRequisicaoImpl)this.getDao()).getRequisicosPorPeriodo(dataInicial, dataFinal, especies, subespecies, empresa, naturezasRequisicao);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void atualizarPrecoMedioReq(Empresa empresa, Date dataInicial, Date dataFinal) {
        ((DaoRequisicaoImpl)this.getDao()).atualizarCustoMedio(empresa, dataInicial, dataFinal);
    }

    @Override
    public Requisicao beforeSave(Requisicao aux) {
        List<BloqueioRequisicao> bloqueioRequisicaoList = this.serviceBloqueioRequisicaoImpl.buscaBloqueios(aux.getDataRequisicao(), aux.getEmpresa());
        if (ServiceRequisicaoImpl.isWithData(bloqueioRequisicaoList)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.289.013"));
        }
        return this.helperRequisicao.beforeSave(aux);
    }

    public List<DTORastreioLoteFabricacao> rastreioLotesRequisicao(Date dataInicial, Date dataFinal, List loteFabricacao, Long produtoInicial, Long produtoFinal) {
        return ((DaoRequisicaoImpl)this.getGenericDao()).rastreioLotesRequisicao(dataInicial, dataFinal, loteFabricacao, produtoInicial, produtoFinal);
    }

    public List<DTOEntidadeRes> findNaturezaRequisicao(Long idProduto, CapsEmpresa capsEmpresa) throws ExceptionObjNotFound, ExceptionParamCtbRequisicao {
        Empresa empresa = (Empresa)this.serviceEmpresaImpl.getOrThrow(capsEmpresa.get());
        List<NaturezaRequisicao> listNaturezaRequisicao = this.serviceNaturezaRequisicaoImpl.getOrThrow(idProduto, empresa);
        return this.buildToDTOGeneric(listNaturezaRequisicao, DTOEntidadeRes.class);
    }
}

