/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.roteiroproducao;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProd;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCelEnc;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCelMatEnc;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementor.model.vo.RoteiroProducaoGrCor;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.analiseprecovenda.ServiceAnalisePrVendaProdImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SCompRoteiroProducao
extends ServiceGenericImpl {
    private final ServiceAnalisePrVendaProdImpl serviceAnalisePrVendaProd;

    public RoteiroProducao criarRoteiroProducao(AnalisePrVendaProd analisePrecoVenda, GradeCor grade, Empresa empresa) {
        ArrayList<RoteiroProducao> listRoteiroProducao = new ArrayList<RoteiroProducao>();
        for (AnalisePrVendaProdCelEnc al : analisePrecoVenda.getAnalisePrVendaPCPEnc().getItensCelulaAnalPreco()) {
            GradeCor gradecor;
            if (!this.isNull(al.getFormulacaoProduto()).booleanValue() || !this.isNull(al.getRoteiroProducao()).booleanValue()) continue;
            GradeCor gradeCor = gradecor = this.isNotNull(al.getProdutoIntermediario()) != false ? al.getProdutoIntermediario() : grade;
            if (this.verificarExisteGradeCorRoteiroProducao(listRoteiroProducao, gradecor)) {
                this.criarRoteiroProducao(listRoteiroProducao, al, gradecor, empresa);
                continue;
            }
            this.atualizarFaseProdutiva(listRoteiroProducao, al, gradecor);
        }
        AnalisePrVendaProd analisePrVendaProd = this.serviceAnalisePrVendaProd.saveOrUpdate(analisePrecoVenda);
        return this.setarRoteiroProducao(analisePrVendaProd, grade);
    }

    private void criarRoteiroProducao(List<RoteiroProducao> listRoteiroProducao, AnalisePrVendaProdCelEnc al, GradeCor gradeCor, Empresa empresa) {
        RoteiroProducao roteiroProducao = new RoteiroProducao();
        roteiroProducao.setAtivo(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        roteiroProducao.setDataCadastro(new Date());
        roteiroProducao.setEmpresa(empresa);
        roteiroProducao.setDividirTempoNrGrades(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        RoteiroProducaoGrCor roteiroProducaoGrCor = new RoteiroProducaoGrCor();
        roteiroProducaoGrCor.setRoteiroProducao(roteiroProducao);
        roteiroProducaoGrCor.setGradeCor(this.isNotNull(al.getProdutoIntermediario()) != false ? al.getProdutoIntermediario() : gradeCor);
        roteiroProducao.setRoteiroProducaoGrCor(Collections.singletonList(roteiroProducaoGrCor));
        roteiroProducao.setDescricao(roteiroProducaoGrCor.getGradeCor().getProdutoGrade().getProduto().getNome());
        roteiroProducao.getFasesProdutivas().addAll(this.criarFaseProdutiva(al, roteiroProducao));
        al.setRoteiroProducao(roteiroProducao);
        listRoteiroProducao.add(roteiroProducao);
    }

    private List<FaseProdutiva> criarFaseProdutiva(AnalisePrVendaProdCelEnc al, RoteiroProducao roteiroProducao) {
        Integer numeroOrdem = roteiroProducao.getFasesProdutivas().size() + 1;
        ArrayList<FaseProdutiva> listFaseProdutiva = new ArrayList<FaseProdutiva>();
        for (AnalisePrVendaProdCelMatEnc mat : al.getItemMatCelulas()) {
            FaseProdutiva faseProdutiva = new FaseProdutiva();
            faseProdutiva.setRoteiroProducao(roteiroProducao);
            faseProdutiva.setCelulaProdutiva(al.getCelulaProdutiva());
            faseProdutiva.setDescricaoAuxiliar(mat.getGradeCor().getProdutoGrade().getProduto().getNome());
            faseProdutiva.setNumeroOrdem(Short.valueOf(numeroOrdem.shortValue()));
            faseProdutiva.setQtdePorHora(Double.valueOf(0.0));
            listFaseProdutiva.add(faseProdutiva);
            Integer n = numeroOrdem;
            numeroOrdem = numeroOrdem + 1;
        }
        return listFaseProdutiva;
    }

    private boolean verificarExisteGradeCorRoteiroProducao(List<RoteiroProducao> listRoteiroProducao, GradeCor gradecor) {
        return listRoteiroProducao.stream().flatMap(roteiroProducao -> roteiroProducao.getRoteiroProducaoGrCor().stream()).anyMatch(roteiroProducaoGrCor -> this.isEquals(roteiroProducaoGrCor.getGradeCor(), gradecor));
    }

    private void atualizarFaseProdutiva(List<RoteiroProducao> listRoteiroProducao, AnalisePrVendaProdCelEnc al, GradeCor gradeCor) {
        listRoteiroProducao.stream().flatMap(roteiroProducao -> roteiroProducao.getRoteiroProducaoGrCor().stream()).filter(roteiroProducaoGrCor -> this.isEquals(roteiroProducaoGrCor.getGradeCor(), gradeCor)).findFirst().ifPresent(roteiroProducao -> {
            roteiroProducao.getRoteiroProducao().getFasesProdutivas().addAll(this.criarFaseProdutiva(al, roteiroProducao.getRoteiroProducao()));
            al.setRoteiroProducao(roteiroProducao.getRoteiroProducao());
        });
    }

    private RoteiroProducao setarRoteiroProducao(AnalisePrVendaProd analisePrVendaProd, GradeCor grade) {
        return analisePrVendaProd.getAnalisePrVendaPCPEnc().getItensCelulaAnalPreco().stream().flatMap(al -> al.getRoteiroProducao().getRoteiroProducaoGrCor().stream()).filter(r -> this.isEquals(r.getGradeCor(), grade)).map(RoteiroProducaoGrCor::getRoteiroProducao).findFirst().orElse(null);
    }

    @Generated
    public SCompRoteiroProducao(ServiceAnalisePrVendaProdImpl serviceAnalisePrVendaProd) {
        this.serviceAnalisePrVendaProd = serviceAnalisePrVendaProd;
    }
}

