/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.roteiroproducao;

import com.touchcomp.basementor.constants.enums.eventoosproducao.EnumTipoEventoOSProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementorservice.dao.impl.DaoRoteiroProducaoEstatisticasImpl;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.roteiroproducao.ServiceRoteiroProducaoImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.touchvomodel.vo.estatisticasroteiroproducao.DTOEstatisticasRoteiroProducao;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceRoteiroProducaoEstatisticasImpl
extends ServiceGenericImpl {
    @Autowired
    DaoRoteiroProducaoEstatisticasImpl daoRoteiro;
    @Autowired
    ServiceRoteiroProducaoImpl serviceRoteiroProd;

    public List<DTOEstatisticasRoteiroProducao> getResumoTemposProd(Empresa loggedEmpresa, EnumTipoEventoOSProducao tipoevento, Date dataIn, Date dataFim) {
        List<Map<String, Object>> found = this.isEquals(EnumTipoEventoOSProducao.LINHA_PRODUCAO, tipoevento) ? this.daoRoteiro.getResumoTemposProdLinProd(loggedEmpresa, dataIn, dataFim) : this.daoRoteiro.getResumoTemposProdSobEnc(loggedEmpresa, dataIn, dataFim);
        LinkedList<DTOEstatisticasRoteiroProducao> ret = new LinkedList<DTOEstatisticasRoteiroProducao>();
        for (Map<String, Object> genFases : found) {
            Long idFaseProd = (Long)genFases.get("F_ID_FASE_PRODUTIVA");
            String faseProd = (String)genFases.get("F_FASE_PRODUTIVA");
            Short nrOrdem = (Short)genFases.get("F_NR_RODEM");
            Long idRotProd = (Long)genFases.get("F_ID_ROTEIRO_PRODUCAO");
            String roteiroProd = (String)genFases.get("F_ROTEIRO_PRODUCAO");
            Double quantidadeHoraEst = (Double)genFases.get("F_QTD_ESTIMADO_HORA");
            Double quantidadeTotalProd = (Double)genFases.get("F_QUANTIDADE_TOTAL");
            Double tempoTotalProd = (Double)genFases.get("F_TEMPO_TOTAL");
            Double qtdEstimadoHora = (Double)genFases.get("F_QTD_ESTIMADO_HORA");
            Double qtdHora = 0.0;
            if (tempoTotalProd > 0.0) {
                qtdHora = quantidadeTotalProd / tempoTotalProd;
            }
            DTOEstatisticasRoteiroProducao.FaseProdutiva dtoF = new DTOEstatisticasRoteiroProducao.FaseProdutiva();
            dtoF.setFaseProdutivaDescricao(faseProd);
            dtoF.setNumeroOrdem(nrOrdem);
            dtoF.setFaseProdutivaIdentificador(idFaseProd);
            dtoF.setQuantidadePorHoraEstimadaRoteiro(ToolFormatter.arrredondarNumero((Double)quantidadeHoraEst, (int)6));
            dtoF.setQuantidadePorHoraProducao(qtdHora);
            dtoF.setQuantidadeTotalEstimada(Double.valueOf(qtdEstimadoHora * tempoTotalProd));
            dtoF.setQuantidadeTotalProduzida(ToolFormatter.arrredondarNumero((Double)quantidadeTotalProd, (int)6));
            dtoF.setTempoTotalProducao(tempoTotalProd);
            dtoF.setTempoTotalProducaoEstimado(ToolFormatter.arrredondarNumero((Double)(quantidadeTotalProd * (1.0 / qtdEstimadoHora)), (int)2));
            dtoF.setPercentualVariacao(ToolFormatter.arrredondarNumero((Double)ToolNumber.calcDifPercentual((Double)dtoF.getQuantidadeTotalEstimada(), (Double)dtoF.getQuantidadeTotalProduzida()), (int)2));
            Optional<DTOEstatisticasRoteiroProducao> f = ret.stream().filter(i -> ToolMethods.isEquals((Object)i.getRoteiroProducaoIdentificador(), (Object)idRotProd)).findFirst();
            DTOEstatisticasRoteiroProducao value = null;
            if (!f.isPresent()) {
                value = new DTOEstatisticasRoteiroProducao();
                value.setRoteiroProducaoIdentificador(idRotProd);
                value.setRoteiroProducaoDescricao(roteiroProd);
                ret.add(value);
            } else {
                value = f.get();
            }
            value.getFasesProdutivas().add(dtoF);
        }
        Collections.sort(ret, (c1, c2) -> c1.getRoteiroProducaoDescricao().compareTo(c2.getRoteiroProducaoDescricao()));
        for (DTOEstatisticasRoteiroProducao dto : ret) {
            Collections.sort(dto.getFasesProdutivas(), (c1, c2) -> {
                if (c1.getNumeroOrdem() == null) {
                    return -1;
                }
                return c1.getNumeroOrdem().compareTo(c2.getNumeroOrdem());
            });
        }
        return ret;
    }

    public void salvarTemposProd(List<DTOEstatisticasRoteiroProducao> input) {
        if (input == null) {
            return;
        }
        for (DTOEstatisticasRoteiroProducao dto : input) {
            if (!this.isEquals(dto.getAceitarSugestao(), (short)1)) continue;
            this.salvar(dto);
        }
    }

    private void salvar(DTOEstatisticasRoteiroProducao dto) {
        RoteiroProducao rot = (RoteiroProducao)this.serviceRoteiroProd.get(dto.getRoteiroProducaoIdentificador());
        if (rot == null) {
            return;
        }
        for (DTOEstatisticasRoteiroProducao.FaseProdutiva fase : dto.getFasesProdutivas()) {
            Optional<FaseProdutiva> found = rot.getFasesProdutivas().stream().filter(i -> this.isEquals(i.getIdentificador(), fase.getFaseProdutivaIdentificador())).findFirst();
            if (!found.isPresent()) continue;
            FaseProdutiva f = found.get();
            f.setQtdePorHora(fase.getQuantidadePorHoraProducao());
        }
        this.serviceRoteiroProd.saveOrUpdate(rot);
    }
}

