/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.roteiroproducao;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.opcoespcp.EnumConstOpcoesPCPOP;
import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProd;
import com.touchcomp.basementor.model.vo.CelulaProdutiva;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.FichaTecRoteiroProducao;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GrupoFuncoesProdutivas;
import com.touchcomp.basementor.model.vo.GrupoProdutos;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementor.model.vo.RoteiroProducaoTpProdSped;
import com.touchcomp.basementor.model.vo.TipoProducaoSped;
import com.touchcomp.basementor.model.vo.TipoRecursoPCP;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.dao.impl.DaoRoteiroProducaoImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoespcp.HelperOpcoesPCP;
import com.touchcomp.basementorservice.helpers.impl.roteiroproducao.HelperRoteiroProducao;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.celulaprodutiva.ServiceCelulaProdutivaImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.grupofuncoesprodutivas.ServiceGrupoFuncoesProdutivasImpl;
import com.touchcomp.basementorservice.service.impl.grupoprodutos.ServiceGrupoProdutosImpl;
import com.touchcomp.basementorservice.service.impl.modelofichatecnica.ServiceModeloFichaTecnicaImpl;
import com.touchcomp.basementorservice.service.impl.opcoespcp.ServiceOpcoesPCPImpl;
import com.touchcomp.basementorservice.service.impl.roteiroproducao.SCompRoteiroProducao;
import com.touchcomp.basementorservice.service.impl.tipoproducaosped.ServiceTipoProducaoSpedImpl;
import com.touchcomp.basementorservice.service.impl.tiporecursopcp.ServiceTipoRecursoPCPImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceRoteiroProducao;
import com.touchcomp.touchvomodel.res.DTOEntidadeRes;
import com.touchcomp.touchvomodel.vo.roteiroproducao.web.DTORoteiroProducao;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceRoteiroProducaoImpl
extends ServiceGenericEntityImpl<RoteiroProducao, Long, DaoRoteiroProducaoImpl>
implements ServiceRoteiroProducao {
    @Autowired
    ServiceGradeCorImpl serviceGradeCor;
    @Autowired
    ServiceModeloFichaTecnicaImpl serviceModeloFichaTecnica;
    @Autowired
    ServiceTipoProducaoSpedImpl serviceTipoProducaoSped;
    @Autowired
    ServiceCelulaProdutivaImpl serviceCelulaProdutiva;
    @Autowired
    ServiceGrupoFuncoesProdutivasImpl serviceGrupoFuncoesProdutivas;
    @Autowired
    ServiceTipoRecursoPCPImpl serviceTipoRecursoPcp;
    @Autowired
    ServiceGrupoProdutosImpl serviceGrupoProdutos;
    @Autowired
    SCompRoteiroProducao sCompRoteiroProducao;
    @Autowired
    ServiceOpcoesPCPImpl serviceOpcoesPCP;
    @Autowired
    ServiceEmpresaImpl serviceEmpresa;
    @Autowired
    HelperOpcoesPCP helperOpcoesPCP;

    @Autowired
    public ServiceRoteiroProducaoImpl(DaoRoteiroProducaoImpl genericDao) {
        super(genericDao);
    }

    @Override
    public RoteiroProducao beforeSave(RoteiroProducao vo) {
        if (vo.getFasesProdutivas() != null) {
            for (FaseProdutiva fase : vo.getFasesProdutivas()) {
                fase.setRoteiroProducao(vo);
                if (fase.getEquipamentos() != null) {
                    fase.getEquipamentos().forEach(i -> i.setFaseProdutiva(fase));
                }
                if (fase.getRecursos() != null) {
                    fase.getRecursos().forEach(i -> i.setFaseProdutiva(fase));
                }
                if (fase.getGrupoFuncoes() == null) continue;
                fase.getGrupoFuncoes().forEach(i -> i.setFaseProdutiva(fase));
            }
        }
        if (vo.getFichasTecnicas() != null) {
            for (FichaTecRoteiroProducao ficha : vo.getFichasTecnicas()) {
                ficha.setRoteiroProducao(vo);
                if (ficha.getValoresFichaTec() == null) continue;
                ficha.getValoresFichaTec().forEach(i -> i.setFichaTecRotProducao(ficha));
            }
        }
        if (vo.getRoteiroProducaoGrCor() != null) {
            vo.getRoteiroProducaoGrCor().forEach(i -> i.setRoteiroProducao(vo));
        }
        if (vo.getTiposProducaoSped() != null) {
            vo.getTiposProducaoSped().forEach(i -> i.setRoteiroProducao(vo));
        }
        if (vo.getGrupoProdutos() != null) {
            vo.getGrupoProdutos().forEach(i -> i.setRoteiroProducao(vo));
        }
        return vo;
    }

    @Override
    public RoteiroProducao getByIdGradeAtivo(Long idGradeCor) {
        return ((DaoRoteiroProducaoImpl)this.getGenericDao()).getByIdGradeAtivo(idGradeCor);
    }

    @Override
    public Long getIDRoteiroByIdGradeAtivo(Long idGradeCor) {
        return ((DaoRoteiroProducaoImpl)this.getGenericDao()).getIDRoteiroByIdGradeAtivo(idGradeCor);
    }

    @Override
    public List<Map<String, Object>> getFasesProdRoteiroMap(Long idRoteiro) {
        return ((DaoRoteiroProducaoImpl)this.getGenericDao()).getFasesProdRoteiroMap(idRoteiro);
    }

    @Override
    public RoteiroProducao get(TipoProducaoSped tipoProducaoSped, GradeCor gradeCor) {
        return ((DaoRoteiroProducaoImpl)this.getGenericDao()).get(tipoProducaoSped, gradeCor);
    }

    public RoteiroProducao getByCodProdRevisao(Long idProduto, String revisao) {
        return ((DaoRoteiroProducaoImpl)this.getDao()).getByCodProdRevisao(idProduto, revisao);
    }

    public RoteiroProducao getByCodProdRevisao(String codigoAuxiliar, String revisao) {
        return ((DaoRoteiroProducaoImpl)this.getDao()).getByCodProdRevisao(codigoAuxiliar, revisao);
    }

    public List<DTORoteiroProducao.DTORoteiroProducaoGrCor> buildRoteiroProducaoGrCor(Long idProduto) throws ExceptionValidacaoDados {
        List<GradeCor> grades = this.serviceGradeCor.getByIdProduto(idProduto);
        if (grades == null || grades.isEmpty()) {
            throw new ExceptionValidacaoDados("E.ERP.0129.005", new Object[0]);
        }
        if (!this.isAffimative(grades.get(0).getProdutoGrade().getProduto().getAtivo())) {
            throw new ExceptionValidacaoDados("E.ERP.0129.006", new Object[0]);
        }
        return new HelperRoteiroProducao().build((RoteiroProducao)null).buildGradesRoteiro(grades);
    }

    public WebDTOResult<List<DTORoteiroProducao.DTORoteiroProducaoGrCor>> buildRoteiroProducaoGrCorByGrade(Long[] identificadores) {
        WebDTOResult result = new WebDTOResult();
        List grades = this.serviceGradeCor.gets(identificadores);
        LinkedList<DTORoteiroProducao.DTORoteiroProducaoGrCor> ret = new LinkedList<DTORoteiroProducao.DTORoteiroProducaoGrCor>();
        if (ServiceRoteiroProducaoImpl.isWithData(grades)) {
            for (GradeCor grade : grades) {
                if (!this.isAffimative(grade.getProdutoGrade().getProduto().getAtivo())) {
                    result.addWarning("E.ERP.0129.006", new Object[]{String.valueOf(grade)});
                    continue;
                }
                ret.add(new HelperRoteiroProducao().build((RoteiroProducao)null).buildGradeRoteiro(grade));
            }
        }
        result.setResult(ret);
        return result;
    }

    public List<DTORoteiroProducao.DTOFichaTecRoteiroProducao> buildFichaTecRotProducao(Long[] identificadores) throws ExceptionValidacaoDados {
        List modelos = this.serviceModeloFichaTecnica.gets(identificadores);
        LinkedList<DTORoteiroProducao.DTOFichaTecRoteiroProducao> ret = new LinkedList<DTORoteiroProducao.DTOFichaTecRoteiroProducao>();
        if (ServiceRoteiroProducaoImpl.isWithData(modelos)) {
            for (ModeloFichaTecnica vo : modelos) {
                ret.add(new HelperRoteiroProducao().build((RoteiroProducao)null).buildFichaTecRotProducao(vo));
            }
        }
        return ret;
    }

    public List<DTORoteiroProducao.DTOGrupoFuncoesProdutivasFormulacoes> buildGrupoFuncoesProdutivasFormulacoes(Long[] identificadores) {
        List grupos = this.serviceGrupoFuncoesProdutivas.gets(identificadores);
        LinkedList<DTORoteiroProducao.DTOGrupoFuncoesProdutivasFormulacoes> ret = new LinkedList<DTORoteiroProducao.DTOGrupoFuncoesProdutivasFormulacoes>();
        if (ServiceRoteiroProducaoImpl.isWithData(grupos)) {
            for (GrupoFuncoesProdutivas vo : grupos) {
                ret.add(new HelperRoteiroProducao().build((RoteiroProducao)null).buildGrupoFuncoesProdutivasFormulacoes(vo));
            }
        }
        return ret;
    }

    public List<DTORoteiroProducao.DTORoteiroProducaoGrCor> buildRoteiroProducaoGrCor(String codigoAuxiliar) throws ExceptionValidacaoDados {
        List<GradeCor> grades = this.serviceGradeCor.getByCodAuxProduto(codigoAuxiliar);
        if (grades == null || grades.isEmpty()) {
            throw new ExceptionValidacaoDados("E.ERP.0129.005", new Object[0]);
        }
        if (!this.isAffimative(grades.get(0).getProdutoGrade().getProduto().getAtivo())) {
            throw new ExceptionValidacaoDados("E.ERP.0129.006", new Object[0]);
        }
        return new HelperRoteiroProducao().build((RoteiroProducao)null).buildGradesRoteiro(grades);
    }

    public String verificarProdutosEmOutrosRoteiros(DTORoteiroProducao roteiro) {
        List grades = roteiro.getRoteiroProducaoGrCor();
        if (grades == null || grades.isEmpty()) {
            return null;
        }
        HelperRoteiroProducao helper = new HelperRoteiroProducao().build((RoteiroProducao)null);
        Object produtosOutrosRot = "";
        for (DTORoteiroProducao.DTORoteiroProducaoGrCor gc : roteiro.getRoteiroProducaoGrCor()) {
            List<RoteiroProducao> roteiros = ((DaoRoteiroProducaoImpl)this.getDao()).getRoteiroByIdGradeAtivo(gc.getGradeCorIdentificador());
            produtosOutrosRot = (String)produtosOutrosRot + helper.verificarProdutosEmOutrosRoteiros(roteiro, gc, roteiros);
        }
        String produtosRepetidos = helper.verificarProdutosRepetidos(roteiro.getRoteiroProducaoGrCor());
        if ((produtosOutrosRot == null || ((String)produtosOutrosRot).isEmpty()) && (produtosRepetidos == null || produtosRepetidos.isEmpty())) {
            return "Produtos N\u00e3o Encontrados em Outros Roteiros e N\u00e3o h\u00e1 produtos repretidos neste Roteiro!";
        }
        if (produtosRepetidos == null || produtosRepetidos.isEmpty()) {
            return produtosOutrosRot;
        }
        if (produtosOutrosRot == null || ((String)produtosOutrosRot).isEmpty()) {
            return produtosRepetidos;
        }
        return (String)produtosOutrosRot + produtosRepetidos;
    }

    public RoteiroProducaoTpProdSped getRoteiroTpProducaoPadrao(Empresa empresa) {
        OpcoesPCP opcoesPCP = this.getSharedData().getOpcoesPCP(empresa);
        if (opcoesPCP != null && opcoesPCP.getTipoProducaoSpedPadrao() != null) {
            RoteiroProducaoTpProdSped vo = new RoteiroProducaoTpProdSped();
            vo.setTipoProducaoSped(opcoesPCP.getTipoProducaoSpedPadrao());
            return vo;
        }
        return null;
    }

    public List<DTORoteiroProducao.DTORoteiroProducaoTpProdSped> getRoteiroTpProducao(Long[] identificadores) {
        List roteiros = this.serviceTipoProducaoSped.gets(identificadores);
        LinkedList<DTORoteiroProducao.DTORoteiroProducaoTpProdSped> ret = new LinkedList<DTORoteiroProducao.DTORoteiroProducaoTpProdSped>();
        if (ServiceRoteiroProducaoImpl.isWithData(roteiros)) {
            for (TipoProducaoSped vo : roteiros) {
                ret.add(new HelperRoteiroProducao().build((RoteiroProducao)null).buildRoteiroProducaoTp(vo));
            }
        }
        return ret;
    }

    public DTORoteiroProducao.DTOFaseProdutiva buildFaseProdutiva(Long idCelulaProdutiva) {
        CelulaProdutiva vo = (CelulaProdutiva)this.serviceCelulaProdutiva.get(idCelulaProdutiva);
        if (vo != null) {
            return new HelperRoteiroProducao().build((RoteiroProducao)null).buildFaseProdutivaRoteiro(vo);
        }
        return null;
    }

    public WebDTOResult<List<DTORoteiroProducao.DTOFaseProdutivaTpRecurso>> getTipoRecursoPcp(Long[] identificadores) {
        WebDTOResult result = new WebDTOResult();
        List tipos = this.serviceTipoRecursoPcp.gets(identificadores);
        LinkedList<DTORoteiroProducao.DTOFaseProdutivaTpRecurso> ret = new LinkedList<DTORoteiroProducao.DTOFaseProdutivaTpRecurso>();
        if (ServiceRoteiroProducaoImpl.isWithData(tipos)) {
            for (TipoRecursoPCP vo : tipos) {
                if (!this.isEquals(vo.getAtivo(), EnumConstStatusObjeto.ATIVO.getValue())) {
                    result.addWarning("E.ERP.0129.009", new Object[]{vo.getDescricao()});
                    continue;
                }
                ret.add(new HelperRoteiroProducao().build((RoteiroProducao)null).buildFaseProdutivaTpRecurso(vo));
            }
        }
        result.setResult(ret);
        return result;
    }

    public List<DTORoteiroProducao.DTOGrupoProdutoRoteiroProducao> getGrupoProdutosRoteiro(Long[] identificadores) {
        List grupos = this.serviceGrupoProdutos.gets(identificadores);
        LinkedList<DTORoteiroProducao.DTOGrupoProdutoRoteiroProducao> ret = new LinkedList<DTORoteiroProducao.DTOGrupoProdutoRoteiroProducao>();
        if (ServiceRoteiroProducaoImpl.isWithData(grupos)) {
            for (GrupoProdutos vo : grupos) {
                ret.add(new HelperRoteiroProducao().build((RoteiroProducao)null).buildGrupoProdutosRoteiro(vo));
            }
        }
        return ret;
    }

    public RoteiroProducao criarRoteiroProducao(AnalisePrVendaProd analisePrecoVenda, GradeCor grade, Short expMelhorRotForm, CapsEmpresa capsEmpresa) {
        OpcoesPCP opcoesPCP = this.serviceOpcoesPCP.getByIdEmpresa(capsEmpresa.get());
        Empresa empresa = (Empresa)this.serviceEmpresa.get(capsEmpresa.get());
        Short rotProducaoFormProdutosPlanProd = (Short)CompOpcoes.getOption(this.helperOpcoesPCP.build(opcoesPCP).getItens(), (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.ROT_PRODUCAO_FORM_PRODUTOS_PLAN_PROD, Short.class);
        if (this.isEquals(rotProducaoFormProdutosPlanProd, EnumConstantsMentorSimNao.SIM.getValue()) && this.isNotNull(analisePrecoVenda).booleanValue()) {
            return this.sCompRoteiroProducao.criarRoteiroProducao(analisePrecoVenda, grade, empresa);
        }
        if (this.isEquals(expMelhorRotForm, EnumConstantsMentorSimNao.SIM.getValue())) {
            return this.getByIdGradeAtivo(grade.getIdentificador());
        }
        return null;
    }

    public List<DTOEntidadeRes> findRoteirosProdAtivos(Long idGradeCor, Empresa empresa) throws ExceptionObjNotFound {
        GradeCor gradeCor = (GradeCor)this.serviceGradeCor.getOrThrow(idGradeCor);
        return this.buildToDTO(((DaoRoteiroProducaoImpl)this.getGenericDao()).findRoteirosProdAtivos(gradeCor, empresa), DTOEntidadeRes.class);
    }
}

