/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.rps;

import com.touchcomp.basementor.constants.enums.modelorps.EnumConstStatusRPS;
import com.touchcomp.basementor.constants.enums.situacaodocumento.EnumConstSituacaoDocumento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EnderecoWebServNFSe;
import com.touchcomp.basementor.model.vo.ModeloRPS;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoNFSe;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.ServicoRPS;
import com.touchcomp.basementor.model.vo.UnidadeFatTomPrestRPS;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.opcoesfaturamentonfse.ServiceOpcoesFaturamentoNFSeImpl;
import com.touchcomp.basementorservice.service.impl.situacaodocumento.ServiceSituacaoDocumentoImpl;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCompCriacaoRpsPorPedido
extends ServiceGenericImpl {
    @Autowired
    ServiceSituacaoDocumentoImpl serviceSituacaoDocumento;
    @Autowired
    ServiceOpcoesFaturamentoNFSeImpl serviceOpcoesFaturamentoNFSe;

    public Rps criarRps(UnidadeFatTomPrestRPS unidadeFatTomPrestRPS, ServicoRPS servicoRps, ModeloRPS modeloRps, Empresa empresa, Pedido pedido) {
        OpcoesFaturamentoNFSe opcoesFaturamentoNFSe = this.serviceOpcoesFaturamentoNFSe.getByIdEmpresa(empresa.getIdentificador());
        Rps rps = new Rps();
        rps.setDataEmissao(new Date());
        rps.setHoraEmissao(new Date());
        rps.setDataCadastro(new Date());
        rps.setSerie(modeloRps.getSerie());
        rps.setEmpresa(empresa);
        rps.setNaturezaOperacaoRps(modeloRps.getNaturezaOperacaoRps());
        rps.setCidade(rps.getEmpresa().getPessoa().getEndereco().getCidade());
        rps.setEnderecoWebServ((EnderecoWebServNFSe)opcoesFaturamentoNFSe.getEnderecosWebServNFSe().get(0));
        rps.setUnidadeTomPrestRPS(unidadeFatTomPrestRPS);
        rps.setCompetencia(new Date());
        rps.setDataExecucaoServico(new Date());
        rps.setStatus(Short.valueOf(EnumConstStatusRPS.RPS_NORMAL.getValue()));
        rps.setSituacaoDocumento(this.serviceSituacaoDocumento.get(EnumConstSituacaoDocumento.REGULAR));
        rps.setCondicoesPagamento(pedido.getCondicoesPagamento());
        rps.setParcelas(pedido.getCondPagMut());
        rps.setMeioPagamento(pedido.getMeioPagamento());
        this.setServicoRps(rps, servicoRps, modeloRps);
        return rps;
    }

    private void setServicoRps(Rps rps, ServicoRPS servicoRps, ModeloRPS modeloRps) {
        rps.setServicoRPS(servicoRps);
        rps.setDiscriminacao(servicoRps.getDiscriminacao());
        rps.setTaxaTributacaoFederal(servicoRps.getGrupoServicoRPS().getTaxaFederal());
        rps.setTaxaTributacaoMunicipal(servicoRps.getGrupoServicoRPS().getTaxaMunicipal());
        if (this.isNotNull(modeloRps).booleanValue()) {
            rps.setModeloRps(modeloRps);
            if (this.isNotNull(rps.getModeloRps()).booleanValue()) {
                rps.setCnae(rps.getModeloRps().getCnae());
            }
            rps.setTipoServico(rps.getModeloRps().getReinfTipoServico());
            rps.setEntradaSaida(rps.getModeloRps().getEntradaSaida());
            rps.setIncidenciaPisCofins(rps.getModeloRps().getIncidenciaPisCofins());
            rps.setTipoPis(rps.getModeloRps().getTipoPis());
            rps.setAliquotaPis(ToolNumber.asZeroIfNull((Double)rps.getModeloRps().getAliquotaPis()));
            rps.setTipoCofins(rps.getModeloRps().getTipoCofins());
            rps.setAliquotaCofins(ToolNumber.asZeroIfNull((Double)rps.getModeloRps().getAliquotaCofins()));
            rps.setAliquotaInss(ToolNumber.asZeroIfNull((Double)rps.getModeloRps().getAliquotaINSS()));
            rps.setTipoIss(rps.getModeloRps().getTipoIss());
            rps.setAliquotaIss(ToolNumber.asZeroIfNull((Double)rps.getModeloRps().getAliquotaISS()));
            rps.setAliquotaIr(ToolNumber.asZeroIfNull((Double)rps.getModeloRps().getAliquotaIRRF()));
            rps.setAliquotaContSoc(ToolNumber.asZeroIfNull((Double)rps.getModeloRps().getAliquotaCSLL()));
            rps.setAliquotaOutros(ToolNumber.asZeroIfNull((Double)rps.getModeloRps().getAliquotaOutros()));
        }
    }
}

