/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.rps;

import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.components.notafiscal.CompNotaFiscal;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.zip.ToolZipUtils;
import com.touchcomp.basementorxml.model.XMLNfseRPS;
import com.touchcomp.basementorxml.service.impl.xmlnfserps.ServiceXMLNFseRPSImpl;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceRPSXMLImpl
extends ServiceGenericImpl {
    @Autowired
    ServiceXMLNFseRPSImpl serviceXML;

    public File getXMLsZipFile(String ... chaves) throws ExceptionIO, ExceptionInvalidData {
        return this.getXMLsZipFile(ToolMethods.toList((Object[])chaves));
    }

    public File getXMLsZipFile(List<Long> ids) throws ExceptionIO, ExceptionInvalidData {
        File tmpDir = ToolFile.getFileTMPDir();
        File zip = new File(tmpDir.getAbsolutePath() + File.separator + "arquivo_xml_documentos.zip");
        ToolZipUtils.compress((File)zip, this.getXMLsFile(ids));
        return zip;
    }

    public List<File> getXMLsFile(List<Long> ids) throws ExceptionIO, ExceptionInvalidData {
        LinkedList<File> files = new LinkedList<File>();
        LinkedList<Long> aux = new LinkedList<Long>();
        for (Long id : ids) {
            if (aux.contains(id)) continue;
            files.add(this.getXMLFile(id));
            aux.add(id);
        }
        return files;
    }

    public File getXMLFile(Long idNota) throws ExceptionIO, ExceptionInvalidData {
        return this.getXMLFile(idNota, false);
    }

    public File getXMLFile(Long idNota, boolean removeInvalidUTF) throws ExceptionIO, ExceptionInvalidData {
        File tmpDir = ToolFile.getFileTMPDir();
        XMLNfseRPS aux = this.serviceXML.getOrCreateXMLNfseRPS(idNota);
        if (aux == null) {
            throw new ExceptionInvalidData("E.ERP.1910.001", new Object[]{idNota});
        }
        File temp = new File(tmpDir.getAbsolutePath() + File.separator + CompNotaFiscal.getFileNameNFSe(String.valueOf(idNota)));
        Object xml = aux.getConteudoXML();
        if (removeInvalidUTF) {
            xml = ToolString.removeIllegalXMLChar((String)xml);
        }
        if (xml != null && !((String)xml).startsWith("<?xml version=")) {
            xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + (String)xml;
        }
        ToolFile.writeStringInFile((File)temp, (String)xml);
        return temp;
    }
}

