/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.rps;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.configservicosterceiros.EnumConstConfigServicosTerceiros;
import com.touchcomp.basementor.constants.enums.nfse.EnumConstConfigServicoNFSe;
import com.touchcomp.basementor.model.impl.DadosEstatisticosFaturamento;
import com.touchcomp.basementor.model.vo.ConfigServicosTercItem;
import com.touchcomp.basementor.model.vo.ConfigServicosTerceiros;
import com.touchcomp.basementor.model.vo.EnderecoWebServNFSe;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoNFSe;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TomadorPrestadorRps;
import com.touchcomp.basementor.model.vo.VersaoServidorNFSe;
import com.touchcomp.basementorclientwebservices.nfse.constants.ConstStatusApiNFSe;
import com.touchcomp.basementorclientwebservices.nfse.impl.cancelarnota.UtilCancelaNFSe;
import com.touchcomp.basementorclientwebservices.nfse.impl.consultanota.UtilConsultaNFSe;
import com.touchcomp.basementorclientwebservices.nfse.impl.downloadxml.UtilDownloadNFSe;
import com.touchcomp.basementorclientwebservices.nfse.impl.envialote.UtilEnviaNFSe;
import com.touchcomp.basementorclientwebservices.nfse.model.ret.NFSeResultCancelamento;
import com.touchcomp.basementorclientwebservices.nfse.model.ret.NFSeResultConsulta;
import com.touchcomp.basementorclientwebservices.nfse.model.ret.NFSeResultEnv;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorservice.dao.impl.DaoRpsImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.configservicosterceiros.ServiceConfigServicosTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.contabilizacaorps.ServiceContabilizacaoRps;
import com.touchcomp.basementorservice.service.impl.titulo.ServiceTituloImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceRps;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.basementorxml.model.XMLNfseRPS;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFseRPS;
import com.touchcomp.touchvomodel.vo.centraldocsproprios.DTOCentralDocsPropriosNFSe;
import com.touchcomp.touchvomodel.vo.rps.web.DTORps;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ServiceRpsImpl
extends ServiceGenericEntityImpl<Rps, Long, DaoRpsImpl>
implements ServiceRps {
    @Autowired
    ServiceContabilizacaoRps serviceContabilizacaoRps;
    @Autowired
    ServiceXMLNFseRPS serviceXMLNFseRPS;
    @Autowired
    ServiceConfigServicosTerceirosImpl serviceConfigServTerceiros;
    @Autowired
    ServiceTituloImpl serviceTitulo;

    @Autowired
    public ServiceRpsImpl(DaoRpsImpl genericDao) {
        super(genericDao);
    }

    @Override
    public Rps beforeSaveEntity(Rps rps) {
        if (ServiceRpsImpl.isWithData(rps.getItensRps())) {
            rps.getItensRps().forEach(i -> i.setRps(rps));
        }
        if (ServiceRpsImpl.isWithData(rps.getPedidos())) {
            rps.getPedidos().forEach(i -> i.setRps(rps));
        }
        if (ServiceRpsImpl.isWithData(rps.getPreRpsTransporte())) {
            rps.getPreRpsTransporte().forEach(i -> i.setRps(rps));
        }
        if (ServiceRpsImpl.isWithData(rps.getRepresentantes())) {
            rps.getRepresentantes().forEach(i -> i.setRPS(rps));
        }
        if (ServiceRpsImpl.isWithData(rps.getTitulos())) {
            rps.getTitulos().forEach(i -> {
                i.setRps(rps);
                this.serviceTitulo.beforeSave((Titulo)i);
            });
        }
        return rps;
    }

    @Override
    public DaoRpsImpl getGenericDao() {
        return (DaoRpsImpl)super.getGenericDao();
    }

    @Override
    public DadosEstatisticosFaturamento getMaiorFaturamentoRps(TomadorPrestadorRps toma) {
        return this.getGenericDao().getMaiorFaturamentoRps(toma);
    }

    @Override
    public DadosEstatisticosFaturamento getUltimoFaturamentoRps(TomadorPrestadorRps toma) {
        return this.getGenericDao().getUltimoFaturamentoRps(toma);
    }

    @Override
    public DadosEstatisticosFaturamento getPrimeiroFaturamentoRps(TomadorPrestadorRps toma) {
        return this.getGenericDao().getPrimeiroFaturamentoRps(toma);
    }

    @Override
    public List<Rps> buscarRpsNoPeriodo(Date dataInicial, Date dataFinal) {
        return this.getGenericDao().buscarRpsNoPeriodo(dataInicial, dataFinal);
    }

    @Async
    public CompletableFuture buscaEReprocessaMovimentos(Long dataInicial, Long dataFinal, OpcoesContabeis opcoesContabeis, Short atualizarPlanoConta) throws ExceptionParametrizacao, ExceptionInvalidData {
        List<Rps> rps = this.buscarRpsNoPeriodo(new Date(dataInicial), new Date(dataFinal));
        for (Rps r : rps) {
            r = this.serviceContabilizacaoRps.contabilizar(r, opcoesContabeis, atualizarPlanoConta);
            this.saveOrUpdate(r);
        }
        return CompletableFuture.completedFuture(EnumConstantsMentorStatus.SUCESSO);
    }

    public List<DTOCentralDocsPropriosNFSe> getNotasPropriasServico(Integer regsPerPage, Integer page, GrupoEmpresa loggedGrupoEmpresa, Pessoa pessoa, Short filtrarData, Date dataIn, Date dataFim, Short filtrarNr, Long numero) {
        return ((DaoRpsImpl)this.getDao()).getNotasPropriasServico(regsPerPage, page, loggedGrupoEmpresa, pessoa, filtrarData, dataIn, dataFim, filtrarNr, numero);
    }

    public NFSeResultConsulta consultarRps(Rps rps) throws ExceptionBase, IOException, JDOMException {
        if (this.isNotNull(rps).booleanValue() && this.isNotNull(rps.getIdentificador()).booleanValue()) {
            ConfigServicosTerceiros config = null;
            List<ConfigServicosTerceiros> configuracoes = this.serviceConfigServTerceiros.getList(EnumConstConfigServicosTerceiros.FOCUS_NFE);
            if (!ServiceRpsImpl.isWithData(configuracoes)) {
                throw new ExceptionInvalidData("E.ERP.0658.003", new Object[0]);
            }
            if (configuracoes.size() == 1) {
                config = configuracoes.get(0);
            } else {
                for (ConfigServicosTerceiros c : configuracoes) {
                    Long idEmpresa;
                    String idEmpresaStr = this.getValue(c, EnumConstConfigServicoNFSe.ID_EMPRESA.getChave());
                    if (!this.isNotNull(idEmpresaStr).booleanValue() || !this.isStrWithData(idEmpresaStr) || !this.isEquals(idEmpresa = Long.valueOf(idEmpresaStr), rps.getEmpresa().getIdentificador())) continue;
                    config = c;
                    break;
                }
            }
            OpcoesFaturamentoNFSe opcoesFatNFSe = this.getSharedData().getOpcoesFaturamentoNFSe(rps.getEmpresa());
            if (this.isNull(config).booleanValue()) {
                throw new ExceptionInvalidData("E.ERP.0658.003", new Object[0]);
            }
            NFSeResultConsulta dadosRps = new UtilConsultaNFSe().consultar(config, opcoesFatNFSe, (rps = (Rps)this.getOrThrow(rps.getIdentificador())).getIdentificador());
            if (this.isNotNull(dadosRps).booleanValue() && (this.isEquals(ConstStatusApiNFSe.get((String)dadosRps.getStatus()), ConstStatusApiNFSe.AUTORIZADO) || this.isEquals(ConstStatusApiNFSe.get((String)dadosRps.getStatus()), ConstStatusApiNFSe.CANCELADA))) {
                rps.setNumeroNFse(Long.valueOf(dadosRps.getNumero()));
                if (this.isStrWithData(dadosRps.getCodigoVerificacao())) {
                    rps.setCodigoControle(dadosRps.getCodigoVerificacao());
                }
                if (this.isStrWithData(dadosRps.getDataEmissao()) && dadosRps.getDataEmissao().length() >= 19) {
                    rps.setCompetencia(ToolDate.strToDate((String)dadosRps.getDataEmissao().substring(0, 19), (String)"yyyy-MM-dd'T'HH:mm:ss"));
                }
                if (this.isEquals(ConstStatusApiNFSe.get((String)dadosRps.getStatus()), ConstStatusApiNFSe.CANCELADA)) {
                    rps.setStatus(Short.valueOf((short)2));
                }
                rps = this.saveOrUpdateFlush(rps);
                String xml = new UtilDownloadNFSe().downloadXmlNFSe(dadosRps.getCaminhoXmlNotaFiscal());
                if (this.isStrWithData(xml = this.converterXML(xml))) {
                    XMLNfseRPS x = this.serviceXMLNFseRPS.getOrCreateXMLNfseRPS(rps.getIdentificador());
                    x.setConteudoXML(xml);
                    this.serviceXMLNFseRPS.saveOrUpdate((Object)x);
                }
            }
            return dadosRps;
        }
        return null;
    }

    public NFSeResultEnv enviarRps(Rps rps) throws ExceptionBase {
        if (this.isNotNull(rps).booleanValue()) {
            ConfigServicosTerceiros config = null;
            List<ConfigServicosTerceiros> configuracoes = this.serviceConfigServTerceiros.getList(EnumConstConfigServicosTerceiros.FOCUS_NFE);
            if (!ServiceRpsImpl.isWithData(configuracoes)) {
                throw new ExceptionInvalidData("E.ERP.0658.003", new Object[0]);
            }
            if (configuracoes.size() == 1) {
                config = configuracoes.get(0);
            } else {
                for (ConfigServicosTerceiros c : configuracoes) {
                    Long idEmpresa;
                    String idEmpresaStr = this.getValue(c, EnumConstConfigServicoNFSe.ID_EMPRESA.getChave());
                    if (!this.isNotNull(idEmpresaStr).booleanValue() || !this.isStrWithData(idEmpresaStr) || !this.isEquals(idEmpresa = Long.valueOf(idEmpresaStr), rps.getEmpresa().getIdentificador())) continue;
                    config = c;
                    break;
                }
            }
            OpcoesFaturamentoNFSe opcoesFatNFSe = this.getSharedData().getOpcoesFaturamentoNFSe(rps.getEmpresa());
            if (this.isNull(config).booleanValue()) {
                throw new ExceptionInvalidData("E.ERP.0658.003", new Object[0]);
            }
            NFSeResultEnv result = new UtilEnviaNFSe().send(config, opcoesFatNFSe, rps);
            if (this.isNotNull(result).booleanValue()) {
                if (this.isStrWithData(result.getNumeroRps())) {
                    rps.setNumero(Long.valueOf(result.getNumeroRps()));
                }
                if (this.isStrWithData(result.getSerieRps())) {
                    rps.setSerie(result.getSerieRps());
                }
                rps = this.saveOrUpdateFlush(rps);
            }
            return result;
        }
        return null;
    }

    public NFSeResultCancelamento cancelarRps(Rps rps, String motivoCancelamento) throws ExceptionBase {
        if (this.isNotNull(rps).booleanValue()) {
            VersaoServidorNFSe provedorNFSe;
            OpcoesFaturamentoNFSe opcoesFatNFSe = this.getSharedData().getOpcoesFaturamentoNFSe(rps.getEmpresa());
            if (this.isNotNull(opcoesFatNFSe).booleanValue() && ServiceRpsImpl.isWithData(opcoesFatNFSe.getEnderecosWebServNFSe()) && !this.isEquals((provedorNFSe = ((EnderecoWebServNFSe)opcoesFatNFSe.getEnderecosWebServNFSe().getFirst()).getVersaoServidorNFSe()).getVersao(), (short)14)) {
                throw new ExceptionInvalidData("E.ERP.0657.003", new Object[0]);
            }
            ConfigServicosTerceiros config = null;
            List<ConfigServicosTerceiros> configuracoes = this.serviceConfigServTerceiros.getList(EnumConstConfigServicosTerceiros.FOCUS_NFE);
            if (!ServiceRpsImpl.isWithData(configuracoes)) {
                throw new ExceptionInvalidData("E.ERP.0658.003", new Object[0]);
            }
            if (configuracoes.size() == 1) {
                config = configuracoes.get(0);
            } else {
                for (ConfigServicosTerceiros c : configuracoes) {
                    Long idEmpresa;
                    String idEmpresaStr = this.getValue(c, EnumConstConfigServicoNFSe.ID_EMPRESA.getChave());
                    if (!this.isNotNull(idEmpresaStr).booleanValue() || !this.isStrWithData(idEmpresaStr) || !this.isEquals(idEmpresa = Long.valueOf(idEmpresaStr), rps.getEmpresa().getIdentificador())) continue;
                    config = c;
                    break;
                }
            }
            if (this.isNull(config).booleanValue()) {
                throw new ExceptionInvalidData("E.ERP.0658.003", new Object[0]);
            }
            NFSeResultCancelamento result = new UtilCancelaNFSe().cancelar(config, opcoesFatNFSe, rps = (Rps)this.getOrThrow(rps.getIdentificador()), motivoCancelamento);
            if (this.isNotNull(result).booleanValue() && this.isEquals(result.getStatus(), ConstStatusApiNFSe.CANCELADA.getStatus())) {
                rps.setStatus(Short.valueOf((short)2));
                rps.setMotivoCancelamento(motivoCancelamento);
                rps = this.saveOrUpdateFlush(rps);
            }
            return result;
        }
        return null;
    }

    private String converterXML(String xml) {
        String xml1 = "";
        try {
            xml1 = xml.replace("DescricaoCodigoTributacaoMunic\u00edpio", "DescricaoCodigoTributacaoMunicipio");
            Document document = ToolJdom.getDocument((String)xml1, (ToolJdom.EnumToolJdomEncoding)ToolJdom.EnumToolJdomEncoding.ISO_8889_1);
            Element e = document.getRootElement();
            List listaNfse = e.getChildren();
            for (Element ee : listaNfse) {
                List compNfse = ee.getChildren();
                for (Element eee : compNfse) {
                    xml1 = ToolJdom.toXml((Element)eee);
                }
            }
        }
        catch (ExceptionJDom ex) {
            Logger.getLogger(ServiceRpsImpl.class.getName()).log(Level.SEVERE, null, ex);
            return xml1;
        }
        return xml1;
    }

    public Rps findByNumeroAndSerie(Long numero, String serie) {
        return this.getGenericDao().findByNumeroAndSerie(numero, serie);
    }

    public Rps findByNumeroNFSe(Long numero) {
        return this.getGenericDao().findByNumeroNFSe(numero);
    }

    private String getValue(ConfigServicosTerceiros config, String key) {
        if (config == null) {
            return null;
        }
        for (ConfigServicosTercItem configServicosTercItem : config.getItensConfig()) {
            if (!configServicosTercItem.getItem().equals(key)) continue;
            return configServicosTercItem.getValor();
        }
        return null;
    }

    public List<Rps> findNotasNaoApuradasReinf2020(GrupoEmpresa grupo, Date periodo, Boolean filtrarNotasRetidas) {
        return this.getGenericDao().findNotasNaoApuradasReinf2020(grupo, periodo, filtrarNotasRetidas);
    }

    public List<DTORps> find(Long[] ids) {
        List rps = this.gets(ids);
        return this.buildToDTOGeneric(rps, DTORps.class);
    }
}

