/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.saldoestoque;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralDetBasico;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ClassificacaoAnaliseEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.Fabricante;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GrupoProdutos;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SubEspecie;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidDataRuntime;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoSaldoEstoqueImpl;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.SaldoEstoqueParams;
import com.touchcomp.basementorservice.service.interfaces.ServiceSaldoEstoque;
import com.touchcomp.touchvomodel.vo.saldoestoque.DTOSaldoEstoqueGeralBasico;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceSaldoEstoqueImpl
extends ServiceGenericImpl
implements ServiceSaldoEstoque {
    private DaoSaldoEstoqueImpl daoSaldoEstoque;
    private ServiceGradeCorImpl serviceGradeCorImpl;
    private ServiceProdutoImpl serviceProdutoImpl;
    private ServiceEmpresaImpl serviceEmpresaImpl;

    @Autowired
    public ServiceSaldoEstoqueImpl(DaoSaldoEstoqueImpl daoSaldoEstoque, ServiceGradeCorImpl serviceGradeCorImpl, ServiceProdutoImpl serviceProdutoImpl, ServiceEmpresaImpl serviceEmpresaImpl) {
        this.daoSaldoEstoque = daoSaldoEstoque;
        this.serviceGradeCorImpl = serviceGradeCorImpl;
        this.serviceProdutoImpl = serviceProdutoImpl;
        this.serviceEmpresaImpl = serviceEmpresaImpl;
    }

    @Override
    public List<LoteFabricacao> findLotesAbertos(Produto produto, GradeCor gradeCor, Empresa empresa, EnumConstCentroEstTipoPropTerc tipoCentroEstPropTerc) {
        return this.daoSaldoEstoque.findLotesAbertos(produto, gradeCor, empresa, tipoCentroEstPropTerc);
    }

    @Override
    public LoteFabricacao findMelhorLoteFabricacao(Date dataSaldo, GradeCor gradeCor, Empresa empresa, EnumConstCentroEstTipoPropTerc tipoCentroEstPropTerc) {
        return this.daoSaldoEstoque.findMelhorLote(gradeCor, dataSaldo, empresa, tipoCentroEstPropTerc);
    }

    @Override
    public List<LoteFabricacao> findLotesFabricacaoPorCentroEstoque(Produto produto, GradeCor gradeCor, Empresa empresa, CentroEstoque centroEstoque, EnumConstCentroEstTipoPropTerc tipoCentroEstoquePropTerc) {
        return this.daoSaldoEstoque.findLotesPorCentroEstoque(produto, gradeCor, empresa, centroEstoque, tipoCentroEstoquePropTerc);
    }

    @Override
    public LoteFabricacao findMelhorLoteFabricacaoPorCentroEstoque(GradeCor gradeCor, Empresa empresa, Date data, CentroEstoque centroEstoque, EnumConstCentroEstTipoPropTerc tipoCentroEstPropTerc) {
        return this.daoSaldoEstoque.findMelhorLotePorCentroEstoque(gradeCor, data, empresa, centroEstoque, tipoCentroEstPropTerc);
    }

    @Override
    public List<LoteFabricacao> findLotesFabricacao(Produto produto, GradeCor gradeCor, Empresa empresa, EnumConstCentroEstTipoPropTerc tipoCentroEstoquePropTerc) {
        return this.daoSaldoEstoque.findLotes(produto, gradeCor, empresa, tipoCentroEstoquePropTerc);
    }

    @Override
    public void reprocessarEstoque(Date dataInicial, Long idProdutoInicial, Long idProdutoFinal) {
        this.daoSaldoEstoque.reprocessarEstoque(dataInicial, idProdutoInicial, idProdutoFinal);
    }

    @Override
    public Double findPrecoMedioProduto(Produto produto, Empresa empresa, Date dataSaldo, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        SaldoEstoqueGeralBasico saldo = this.daoSaldoEstoque.findSaldoProdutoUnicoBasico(produto.getIdentificador(), dataSaldo, empresa.getIdentificador(), EnumConstSaldoEstTipoSaldo.TIPO_SALDO_PRODUTO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_VALOR, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, tipoEstoqueCentroEstoque, idParceiro);
        if (saldo != null) {
            return saldo.getValorMedio();
        }
        return 0.0;
    }

    @Override
    public Double findPrecoMedioProduto(Long idProduto, Long idEmpresa, Date dataSaldo, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        SaldoEstoqueGeralBasico saldo = this.daoSaldoEstoque.findSaldoProdutoUnicoBasico(idProduto, dataSaldo, idEmpresa, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_PRODUTO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_VALOR, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, tipoEstoqueCentroEstoque, idParceiro);
        if (saldo != null) {
            return saldo.getValorMedio();
        }
        return 0.0;
    }

    @Override
    public Double findPrecoMedioIdProduto(Long idProduto, Long idEmpresa, Date dataSaldo, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        SaldoEstoqueGeralBasico saldo = this.daoSaldoEstoque.findSaldoProdutoUnicoBasico(idProduto, dataSaldo, idEmpresa, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
        if (saldo != null) {
            return saldo.getValorMedio();
        }
        return 0.0;
    }

    @Override
    public Double findPrecoMedioIdProduto(Produto produto, Empresa empresa, Date dataSaldo, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        SaldoEstoqueGeralBasico saldo = this.daoSaldoEstoque.findSaldoProdutoUnicoBasico(produto.getIdentificador(), dataSaldo, empresa.getIdentificador(), tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
        if (saldo != null) {
            return saldo.getValorMedio();
        }
        return 0.0;
    }

    @Override
    public SaldoEstoqueGeralBasico findSaldoGradeCor(Produto produto, GradeCor gradeCor, Date dataSaldo, Empresa empresa, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        return this.findSaldoGradeCor(produto.getIdentificador(), gradeCor.getIdentificador(), dataSaldo, empresa.getIdentificador(), tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public SaldoEstoqueGeralBasico findSaldoGradeCor(Long produto, Long gradeCor, Date dataSaldo, Long empresa, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        return this.daoSaldoEstoque.findSaldoProdutoPorGradeUnicoBasico(produto, dataSaldo, empresa, gradeCor, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public SaldoEstoqueGeralBasico findSaldoGradeCorProprio(Long idProduto, Long idGrade, Date dataSaldo, Long idEmpresa, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade) {
        return this.findSaldoGradeCor(idProduto, idGrade, dataSaldo, idEmpresa, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
    }

    @Override
    public SaldoEstoqueGeralBasico findSaldoGradeCorProprio(Long idProduto, Long idGrade, Date dataSaldo, Long idEmpresa, Long idCentroEstoque, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade) {
        return this.daoSaldoEstoque.findSaldoProdutoPorGradeUnicoBasico(idProduto, dataSaldo, idEmpresa, idGrade, idCentroEstoque, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
    }

    @Override
    public List<SaldoEstoqueGeral> findSaldoIdGradeCorLista(Long idProdutoInicial, Long idProdutoFinal, Long idGradeCorInicial, Long idGradeCorFinal, Date dataSaldo, Long empresaInicial, Long empresaFinal, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        return this.daoSaldoEstoque.findSaldoProdutoPorGrade(idProdutoInicial, idProdutoFinal, dataSaldo, empresaInicial, empresaFinal, idGradeCorInicial, idGradeCorFinal, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    public List<SaldoEstoqueGeral> findSaldoIdGradeCorListaProprio(Long idProdutoInicial, Long idProdutoFinal, Date dataSaldo, Long empresaInicial, Long empresaFinal, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade) {
        return this.daoSaldoEstoque.findSaldoProdutoPorGrade(idProdutoInicial, idProdutoFinal, dataSaldo, empresaInicial, empresaFinal, null, null, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
    }

    public SaldoEstoqueGeralBasico findSaldoGradeCorCentroEstoqueProprio(Long idProduto, Date dataSaldo, Long idEmpresa, Long idCentroEstoque, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade) {
        return this.daoSaldoEstoque.findSaldoProdutoPorGradeCentroEstoqueUnicoBasico(idProduto, dataSaldo, idEmpresa, null, idCentroEstoque, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
    }

    @Override
    public List<SaldoEstoqueGeralBasico> findSaldoIdGradeCorListaBasico(Long idProdutoInicial, Long idProdutoFinal, Long idGradeCorInicial, Long idGradeCorFinal, Date dataSaldo, Long empresaInicial, Long empresaFinal, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        return this.daoSaldoEstoque.findSaldoProdutoPorGradeBasico(idProdutoInicial, idProdutoFinal, dataSaldo, empresaInicial, empresaFinal, idGradeCorInicial, idGradeCorFinal, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public SaldoEstoqueGeralBasico findSaldoProdutoBasico(Produto produto, Empresa empresa, Date dataSaldo, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        Long idProduto = produto != null ? produto.getIdentificador() : null;
        Long idEmpresa = empresa != null ? empresa.getIdentificador() : null;
        return this.daoSaldoEstoque.findSaldoProdutoUnicoBasico(idProduto, dataSaldo, idEmpresa, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public List<SaldoEstoqueGeral> findSaldoProdutoLista(Produto produtoInicial, Produto produtoFinal, Empresa empresaInicial, Empresa empresaFinal, Date dataSaldo, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        Long idProdutoInicial = produtoInicial != null ? produtoInicial.getIdentificador() : null;
        Long idProdutoFinal = produtoFinal != null ? produtoFinal.getIdentificador() : null;
        Long idEmpresaInicial = empresaInicial != null ? empresaInicial.getIdentificador() : null;
        Long idEmpresaFinal = empresaFinal != null ? empresaFinal.getIdentificador() : null;
        return this.findSaldoProdutoLista(idProdutoInicial, idProdutoFinal, idEmpresaInicial, idEmpresaFinal, dataSaldo, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public List<SaldoEstoqueGeral> findSaldoProdutoLista(Long idProdutoInicial, Long idProdutoFinal, Long idEmpresaInicial, Long idEmpresaFinal, Date dataSaldo, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        return this.daoSaldoEstoque.findSaldoProduto(idProdutoInicial, idProdutoFinal, dataSaldo, idEmpresaInicial, idEmpresaFinal, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public List<SaldoEstoqueGeralBasico> findSaldoProdutoListaBasico(Produto produtoInicial, Produto produtoFinal, Date dataSaldo, Empresa empresaInicial, Empresa empresaFinal, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        Long idProdutoInicial = produtoInicial != null ? produtoInicial.getIdentificador() : null;
        Long idProdutoFinal = produtoFinal != null ? produtoFinal.getIdentificador() : null;
        Long idEmpresaInicial = empresaInicial != null ? empresaInicial.getIdentificador() : null;
        Long idEmpresaFinal = empresaFinal != null ? empresaFinal.getIdentificador() : null;
        return this.daoSaldoEstoque.findSaldoProdutoBasico(idProdutoInicial, idProdutoFinal, dataSaldo, idEmpresaInicial, idEmpresaFinal, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public SaldoEstoqueGeralBasico findSaldoGradeCorCentroEstoque(Produto produto, GradeCor gradeCor, Date dataSaldo, Empresa empresa, CentroEstoque centroEstoque, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        Long idProduto = produto != null ? produto.getIdentificador() : null;
        Long idCentroEstoque = centroEstoque != null ? centroEstoque.getIdentificador() : null;
        Long idGradeCor = gradeCor != null ? gradeCor.getIdentificador() : null;
        Long idEmpresa = empresa != null ? empresa.getIdentificador() : null;
        return this.daoSaldoEstoque.findSaldoProdutoPorGradeCentroEstoqueUnicoBasico(idProduto, dataSaldo, idEmpresa, idGradeCor, idCentroEstoque, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public List<SaldoEstoqueGeralBasico> findSaldoGradeCorCentroEstoqueLista(Produto produtoInicial, Produto produtoFinal, GradeCor gradeInicial, GradeCor gradeFinal, Date dataSaldo, Empresa empresaInicial, Empresa empresaFinal, CentroEstoque centroInicial, CentroEstoque centroFinal, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        Long idProdutoInicial = produtoInicial != null ? produtoInicial.getIdentificador() : null;
        Long idProdutoFinal = produtoFinal != null ? produtoFinal.getIdentificador() : null;
        Long idCentroEstoqueInicial = centroInicial != null ? centroInicial.getIdentificador() : null;
        Long idCentroEstoqueFinal = centroFinal != null ? centroFinal.getIdentificador() : null;
        Long idGradeCorInicial = gradeInicial != null ? gradeInicial.getIdentificador() : 0L;
        Long idGradeCorFinal = gradeFinal != null ? gradeFinal.getIdentificador() : 999999999L;
        Long idEmpresaInicial = empresaInicial != null ? empresaInicial.getIdentificador() : null;
        Long idEmpresaFinal = empresaFinal != null ? empresaFinal.getIdentificador() : null;
        return this.daoSaldoEstoque.findSaldoProdutoPorGradeCentroEstoqueBasico(idProdutoInicial, idProdutoFinal, dataSaldo, idEmpresaInicial, idEmpresaFinal, idGradeCorInicial, idGradeCorFinal, idCentroEstoqueInicial, idCentroEstoqueFinal, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public List<SaldoEstoqueGeralBasico> findSaldoIdGradeCorCentroEstoqueLista(Long idProdutoInicial, Long idProdutoFinal, Long idGradeCorInicial, Long idGradeCorFinal, Date dataSaldo, Long idEmpresaInicial, Long idEmpresaFinal, Long idCentroEstoqueInicial, Long idCentroEstoqueFinal, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        return this.daoSaldoEstoque.findSaldoProdutoPorGradeCentroEstoqueBasico(idProdutoInicial, idProdutoFinal, dataSaldo, idEmpresaInicial, idEmpresaFinal, idGradeCorInicial, idGradeCorFinal, idCentroEstoqueInicial, idCentroEstoqueFinal, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public SaldoEstoqueGeralBasico findSaldoIdProdutoIdCentroEstoque(Long idProduto, Long idEmpresa, Long idCentroEstoque, Date dataSaldo, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        return this.daoSaldoEstoque.findSaldoProdutoPorGradeCentroEstoqueUnicoBasico(idProduto, dataSaldo, idEmpresa, null, idCentroEstoque, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public SaldoEstoqueGeral findSaldoGradeCentroEstoqueLote(Produto produto, GradeCor grade, Date data, Empresa empresa, LoteFabricacao lote, CentroEstoque centro, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        Long idProduto = produto != null ? produto.getIdentificador() : null;
        Long idCentroEstoque = centro != null ? centro.getIdentificador() : null;
        Long idGradeCor = grade != null ? grade.getIdentificador() : null;
        Long idLote = lote != null ? lote.getIdentificador() : null;
        return this.findSaldoGradeCentroEstoqueLote(idProduto, idGradeCor, data, empresa.getIdentificador(), idLote, idCentroEstoque, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public SaldoEstoqueGeral findSaldoGradeCentroEstoqueLote(Long idProduto, Long idGradeCor, Date data, Long idEmpresa, Long idLote, Long idCentroEstoque, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        return this.daoSaldoEstoque.findSaldoProdutoPorGradeCentroEstoqueLoteUnico(idProduto, idProduto, data, idEmpresa, idEmpresa, idCentroEstoque, idCentroEstoque, idGradeCor, idGradeCor, idLote, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public List<SaldoEstoqueGeral> findSaldoGradeCentroEstoqueLoteLista(Produto produtoInicial, Produto produtoFinal, GradeCor gradeInicial, GradeCor gradeFinal, Date data, Empresa empresaInicial, Empresa empresaFinal, LoteFabricacao lote, CentroEstoque centroInicial, CentroEstoque centroFinal, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento) {
        Long idProdutoInicial = produtoInicial != null ? produtoInicial.getIdentificador() : null;
        Long idProdutoFinal = produtoFinal != null ? produtoFinal.getIdentificador() : null;
        Long idCentroEstoqueInicial = centroInicial != null ? centroInicial.getIdentificador() : null;
        Long idCentroEstoqueFinal = centroFinal != null ? centroFinal.getIdentificador() : null;
        Long idGradeCorInicial = gradeInicial != null ? gradeInicial.getIdentificador() : null;
        Long idGradeCorFinal = gradeFinal != null ? gradeFinal.getIdentificador() : null;
        Long idEmpresaInicial = empresaInicial != null ? empresaInicial.getIdentificador() : null;
        Long idEmpresaFinal = empresaFinal != null ? empresaFinal.getIdentificador() : null;
        Long idLote = lote != null ? lote.getIdentificador() : null;
        return this.daoSaldoEstoque.findSaldoProdutoPorGradeCentroEstoqueLoteLista(idProdutoInicial, idProdutoFinal, data, idEmpresaInicial, idEmpresaFinal, idCentroEstoqueInicial, idCentroEstoqueFinal, idGradeCorInicial, idGradeCorFinal, idLote, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public List<SaldoEstoqueGeral> findSaldoGradeCentroEstoqueLoteLista(Long idProdutoInicial, Long idProdutoFinal, Long idGradeCorInicial, Long idGradeCorFinal, Date data, Long idEmpresaInicial, Long idEmpresaFinal, Long idLote, Long idCentroEstoqueInicial, Long idCentroEstoqueFinal, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento) {
        return this.daoSaldoEstoque.findSaldoProdutoPorGradeCentroEstoqueLoteLista(idProdutoInicial, idProdutoFinal, data, idEmpresaInicial, idEmpresaFinal, idCentroEstoqueInicial, idCentroEstoqueFinal, idGradeCorInicial, idGradeCorFinal, idLote, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public List<SaldoEstoqueGeralBasico> findSaldoGradeCentroEstoqueLoteListaBasico(Produto produtoInicial, Produto produtoFinal, GradeCor gradeInicial, GradeCor gradeFinal, Date data, Empresa empresaInicial, Empresa empresaFinal, LoteFabricacao lote, CentroEstoque centroInicial, CentroEstoque centroFinal, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento) {
        Long idProdutoInicial = produtoInicial != null ? produtoInicial.getIdentificador() : null;
        Long idProdutoFinal = produtoFinal != null ? produtoFinal.getIdentificador() : null;
        Long idCentroEstoqueInicial = centroInicial != null ? centroInicial.getIdentificador() : null;
        Long idCentroEstoqueFinal = centroFinal != null ? centroFinal.getIdentificador() : null;
        Long idGradeCorInicial = gradeInicial != null ? gradeInicial.getIdentificador() : null;
        Long idGradeCorFinal = gradeFinal != null ? gradeFinal.getIdentificador() : null;
        Long idEmpresaInicial = empresaInicial != null ? empresaInicial.getIdentificador() : null;
        Long idEmpresaFinal = empresaFinal != null ? empresaFinal.getIdentificador() : null;
        Long idLote = lote != null ? lote.getIdentificador() : null;
        return this.daoSaldoEstoque.findSaldoGradeCentroEstoqueLoteListaBasico(idProdutoInicial, idProdutoFinal, data, idEmpresaInicial, idEmpresaFinal, idCentroEstoqueInicial, idCentroEstoqueFinal, idGradeCorInicial, idGradeCorFinal, idLote, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public List<SaldoEstoqueGeralBasico> findSaldoGradeCentroEstoqueLoteListaBasico(Long idProdutoInicial, Long idProdutoFinal, Long idGradeInicial, Long idGradeFinal, Date data, Long idEmpresaInicial, Long idEmpresaFinal, Long idLote, Long idCentroInicial, Long idCentroFinal, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento) {
        return this.daoSaldoEstoque.findSaldoGradeCentroEstoqueLoteListaBasico(idProdutoInicial, idProdutoFinal, data, idEmpresaInicial, idEmpresaFinal, idCentroInicial, idCentroFinal, idGradeInicial, idGradeFinal, idLote, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    public List<DTOSaldoEstoqueGeralBasico> findSaldoGradeCentroEstoqueLoteListaBasicoDTO(Long idProdutoInicial, Long idProdutoFinal, Long idGradeInicial, Long idGradeFinal, Date data, Long idEmpresaInicial, Long idEmpresaFinal, Long idLote, Long idCentroInicial, Long idCentroFinal, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento) {
        List<SaldoEstoqueGeralBasico> ret = this.findSaldoGradeCentroEstoqueLoteListaBasico(idProdutoInicial, idProdutoFinal, idGradeInicial, idGradeFinal, data, idEmpresaInicial, idEmpresaFinal, idLote, idCentroInicial, idCentroFinal, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro, tipoSaldo, tipoQtde, tipoCarregamento);
        return this.buildToDTOGeneric(ret, DTOSaldoEstoqueGeralBasico.class);
    }

    @Override
    public List<SaldoEstoqueGeral> findSaldoGradeCentroEstoqueLoteParamAdicLista(Date dataSaldo, Long idProdutoInicial, Long idProdutoFinal, Long idCentroEstoqueInicial, Long idCentroEstoqueFinal, Long idGradeCorInicial, Long idGradeCorFinal, Long idEmpresaInicial, Long idEmpresaFinal, Long idLote, Long idEspecieInicial, Long idEspecieFinal, Long idSubEspecieInicial, Long idSubEspecieFinal, Long idLocalizacaoInicial, Long idlocalizacaoFinal, Long idFabricanteInicial, Long idFabricanteFinal, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        return this.daoSaldoEstoque.findSaldoProdutoPorGradeCentroEstoqueLoteParamAdicionaisLista(idProdutoInicial, idProdutoFinal, dataSaldo, idEmpresaInicial, idEmpresaFinal, idCentroEstoqueInicial, idCentroEstoqueFinal, idGradeCorInicial, idGradeCorFinal, idLote, tipoSaldo, tipoQtde, tipoCarregamento, idEspecieInicial, idEspecieFinal, idSubEspecieInicial, idSubEspecieFinal, idLocalizacaoInicial, idlocalizacaoFinal, idFabricanteInicial, idFabricanteFinal, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public List<SaldoEstoqueGeral> findSaldoGradeCentroEstoqueLoteParamAdicLista(Date dataSaldo, Long idProdutoInicial, Long idProdutoFinal, Long idCentroEstoqueInicial, Long idCentroEstoqueFinal, Long idGradeCorInicial, Long idGradeCorFinal, Long idEmpresaInicial, Long idEmpresaFinal, Long idLote, Long idEspecieInicial, Long idEspecieFinal, Long idSubEspecieInicial, Long idSubEspecieFinal, Long idLocalizacaoInicial, Long idlocalizacaoFinal, Long idFabricanteInicial, Long idFabricanteFinal, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro, Integer firstResult, Integer maxResult) {
        return this.daoSaldoEstoque.findSaldoProdutoPorGradeCentroEstoqueLoteParamAdicionaisLista(idProdutoInicial, idProdutoFinal, dataSaldo, idEmpresaInicial, idEmpresaFinal, idCentroEstoqueInicial, idCentroEstoqueFinal, idGradeCorInicial, idGradeCorFinal, idLote, tipoSaldo, tipoQtde, tipoCarregamento, idEspecieInicial, idEspecieFinal, idSubEspecieInicial, idSubEspecieFinal, idLocalizacaoInicial, idlocalizacaoFinal, idFabricanteInicial, idFabricanteFinal, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro, firstResult, maxResult);
    }

    @Override
    public List<Map> getSaldoEstProprioDisponivelBasico(Date dataSaldo, Long produtoInicial, Long produtoFinal, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long centroEstInicial, Long centroEstFinal, Long fabricanteInicial, Long fabricanteFinal, Long localizacaoInicial, Long localizacaoFinal, Long gradeInicial, Long gradeFinal, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Short tipoPesquisa, Long idEmpresa, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        return this.daoSaldoEstoque.getSaldoProdutoEstoqueDisponivelOrNaoDisponivielProprioOrTerceirosBasico(dataSaldo, produtoInicial, produtoFinal, especieInicial, especieFinal, subEspecieInicial, subEspecieFinal, centroEstInicial, centroEstFinal, fabricanteInicial, fabricanteFinal, localizacaoInicial, localizacaoFinal, gradeInicial, gradeFinal, tipoProdutoInicial, tipoProdutoFinal, tipoPesquisa, idEmpresa, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public Double findPrecoMedioIdProduto(Long idProduto, Long idEmpresa, Date dataSaldo) {
        return this.findPrecoMedioIdProduto(idProduto, idEmpresa, dataSaldo, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_PRODUTO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_VALOR, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
    }

    @Override
    public SaldoEstoqueGeralBasico findSaldoProdutoBasico(Long idProduto, Long idEmpresa, Date dataSaldo, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        return this.daoSaldoEstoque.findSaldoProdutoUnicoBasico(idProduto, dataSaldo, idEmpresa, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    @Override
    public List<SaldoEstoqueGeralBasico> findSaldoProdutoListaBasico(Long idProdutoInicial, Long idProdutoFinal, Date dataSaldo, Long idEmpresaInicial, Long idEmpresaFinal, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        return this.daoSaldoEstoque.findSaldoProdutoBasico(idProdutoInicial, idProdutoFinal, dataSaldo, idEmpresaInicial, idEmpresaFinal, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
    }

    public List<DTOSaldoEstoqueGeralBasico> findSaldoProdutoListaBasicoDTO(Long idProdutoInicial, Long idProdutoFinal, Date dataSaldo, Long idEmpresaInicial, Long idEmpresaFinal, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        List<SaldoEstoqueGeralBasico> res = this.findSaldoProdutoListaBasico(idProdutoInicial, idProdutoFinal, dataSaldo, idEmpresaInicial, idEmpresaFinal, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
        return this.buildToDTOGeneric(res, DTOSaldoEstoqueGeralBasico.class);
    }

    public Double findPrecoMedioProduto(Produto produto, Empresa empresa, Date dataSaldo, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque, Long idParceiro) {
        if (produto == null || empresa == null) {
            return 0.0;
        }
        SaldoEstoqueGeralBasico saldo = this.daoSaldoEstoque.findSaldoProdutoUnicoBasico(produto.getIdentificador(), dataSaldo, empresa.getIdentificador(), tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoque, idParceiro);
        if (saldo != null) {
            return saldo.getValorMedio();
        }
        return 0.0;
    }

    public List<SaldoEstoqueGeralBasico> findSaldosProdAltTab(Date dataSaldo, Date lastSinc, Long idCentroEstoque, Long idEmpresa, Long idTabPrecoBase) {
        return this.daoSaldoEstoque.findSaldosProdAltTab(dataSaldo, lastSinc, idCentroEstoque, idEmpresa, idTabPrecoBase);
    }

    public List<HashMap> findSaldosEstoqueTerceiros(Long idPessoaInicial, Long idPessoaFinal, Short tipoEstoque, Date dataSaldo, Long idEmpresa, Long idProduto, Long idTipoMovimento) {
        return this.daoSaldoEstoque.findSaldosEstoqueTerceiros(idPessoaInicial, idPessoaFinal, tipoEstoque, dataSaldo, idEmpresa, idProduto, idTipoMovimento);
    }

    public List<HashMap> getNotasByFornecedorTipoEstoque(Long idPessoa, Short tipoEstoque, Date dataInicial, Date dataFinal, Long idEmpresa, Long idProduto, Long idTipoMovimento) {
        return this.daoSaldoEstoque.getNotasByFornecedorTipoEstoque(idPessoa, tipoEstoque, dataInicial, dataFinal, idEmpresa, idProduto, idTipoMovimento);
    }

    public LoteFabricacao findMelhorLoteFabricacaoByGradePrincipal(Date dataSaldo, Produto produto, Empresa empresa, EnumConstCentroEstTipoPropTerc tipoCentroEstPropTerc) {
        GradeCor gradePrincipal = this.serviceGradeCorImpl.getGradePrincipalbyProduto(produto);
        return this.daoSaldoEstoque.findMelhorLote(gradePrincipal, dataSaldo, empresa, tipoCentroEstPropTerc);
    }

    public List<LoteFabricacao> findLotesAbertosPorCentroEstoque(Produto p, GradeCor g, Empresa e, CentroEstoque c) {
        if (p == null && g != null) {
            p = g.getProdutoGrade().getProduto();
        }
        EnumConstCentroEstTipoPropTerc tipoCentroEstPropTerc = EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO;
        if (!this.isNull(c).booleanValue()) {
            tipoCentroEstPropTerc = EnumConstCentroEstTipoPropTerc.get((Object)c.getTipoEstProprioTerceiros());
        }
        Long idProduto = p != null ? p.getIdentificador() : null;
        Long idGrade = g != null ? g.getIdentificador() : null;
        Long idEmpresa = e != null ? e.getIdentificador() : null;
        Long idCentroEstoque = c != null ? c.getIdentificador() : null;
        List<SaldoEstoqueGeral> saldos = this.daoSaldoEstoque.findSaldoProdutoPorGradeCentroEstoqueLoteLista(idProduto, idProduto, new Date(), idEmpresa, idEmpresa, idCentroEstoque, idCentroEstoque, idGrade, idGrade, null, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_MAIOR_0, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, tipoCentroEstPropTerc, null);
        ArrayList<LoteFabricacao> lotes = new ArrayList<LoteFabricacao>();
        if (saldos != null) {
            saldos.forEach(i -> {
                if (!this.isNull(i.getLoteFabricacao()).booleanValue()) {
                    lotes.add(i.getLoteFabricacao());
                }
            });
        }
        return lotes;
    }

    public List<LoteFabricacao> getLotesByGradeCentroEstoqueEmpresa(GradeCor gradeCor, CentroEstoque centroEstoque, Empresa emp) {
        List<LoteFabricacao> list = null;
        list = this.isNull(centroEstoque) != false ? this.findLotesAbertos(gradeCor.getProdutoGrade().getProduto(), gradeCor, emp, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO) : this.findLotesAbertosPorCentroEstoque(gradeCor.getProdutoGrade().getProduto(), gradeCor, emp, centroEstoque);
        if (this.isNull(list).booleanValue() || list.isEmpty()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.289.001", new Object[]{gradeCor.getProdutoGrade().getProduto(), emp}));
        }
        return list;
    }

    public List<HashMap> getMovimentacoes(Date dataIn, Date dataFim, Long idEmpresa, Short filtrarProduto, Long idProdutoInicial, Long idProdutoFinal, Short tipoCentroEstPropTerc, Long idCentroEstoqueInicial, Long idCentroEstoqueFinal) {
        Date dataSaldoProd;
        Long idProduto;
        List<HashMap> lista = this.daoSaldoEstoque.getMovimentacoesEntradaSaidaPorPeriodoAndGradeQuantitativo(dataIn, dataFim, idEmpresa, filtrarProduto, idProdutoInicial, idProdutoFinal, tipoCentroEstPropTerc, idCentroEstoqueInicial, idCentroEstoqueFinal);
        HashMap<String, Double> precosMediosCache = new HashMap<String, Double>();
        HashSet<CallSite> chavesPreco = new HashSet<CallSite>();
        for (HashMap hashMap : lista) {
            Long idProduto2 = ((Number)hashMap.get("ID_PRODUTO")).longValue();
            Date dataSaldoProd2 = (Date)hashMap.get("DATA_SALDO");
            String chave = idProduto2 + "|" + dataSaldoProd2.getTime();
            chavesPreco.add((CallSite)((Object)chave));
        }
        for (String string : chavesPreco) {
            String[] partes = string.split("\\|");
            idProduto = Long.valueOf(partes[0]);
            dataSaldoProd = new Date(Long.parseLong(partes[1]));
            Double precoMedio = this.findPrecoMedioProduto(idProduto, idEmpresa, dataSaldoProd, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
            precosMediosCache.put(string, precoMedio);
        }
        ArrayList<HashMap> retorno = new ArrayList<HashMap>();
        for (HashMap h : lista) {
            idProduto = ((Number)h.get("ID_PRODUTO")).longValue();
            dataSaldoProd = (Date)h.get("DATA_SALDO");
            String chavePreco = idProduto + "|" + dataSaldoProd.getTime();
            Double precoMedio = precosMediosCache.getOrDefault(chavePreco, 0.0);
            BigDecimal entrada = (BigDecimal)h.get("QUANTIDADE_ENTRADA");
            BigDecimal saida = (BigDecimal)h.get("QUANTIDADE_SAIDA");
            double qtdEntrada = entrada.doubleValue();
            double qtdSaida = saida.doubleValue();
            h.put("VALOR_ENTRADA", precoMedio * qtdEntrada);
            h.put("VALOR_SAIDA", precoMedio * qtdSaida);
            h.put("QUANTIDADE_ENTRADA", qtdEntrada);
            h.put("QUANTIDADE_SAIDA", qtdSaida);
            retorno.add(h);
        }
        return retorno;
    }

    public List<HashMap> dadosRelatorioConfEstoque(Long idProdInicial, Long idProdFinal, Date dataSaldo, Long idLocalizacaoInicial, Long idLocalizacaoFinal, Long idCentroEstoqueInicial, Long idCentroEstoqueFinal, Long idFabricanteInicial, Long idFabricanteFinal, Long idEspecieInicial, Long idEspecieFinal, Long idSubEspecieInicial, Long idSubEspecieFinal, Long idGradeCorInicial, Long idGradeCorFinal, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Long idEmpresa, EnumConstCentroEstTipoPropTerc tipoEstoqueCentroEstoque) {
        return this.daoSaldoEstoque.dadosRelatorioConfEstoque(idProdInicial, idProdFinal, dataSaldo, idLocalizacaoInicial, idLocalizacaoFinal, idCentroEstoqueInicial, idCentroEstoqueFinal, idFabricanteInicial, idFabricanteFinal, idEspecieInicial, idEspecieFinal, idSubEspecieInicial, idSubEspecieFinal, idGradeCorInicial, idGradeCorFinal, tipoProdutoInicial, tipoProdutoFinal, idEmpresa, tipoEstoqueCentroEstoque);
    }

    public List<HashMap> getProdutosSemMovimentacoes(Short filtrarProduto, Long idProdutoInicial, Long idProdutoFinal, Date dataInicial) {
        return this.daoSaldoEstoque.getProdutosSemMovimentacoes(filtrarProduto, idProdutoInicial, idProdutoFinal, dataInicial);
    }

    public List<HashMap> getProdutosMovimentosDataInicialFinalEmpresas(GradeCor gradeCor, Date dataInicial, Date dataFinal, List<Empresa> empresas) {
        return this.daoSaldoEstoque.getProdutosMovimentosDataInicialFinalEmpresas(gradeCor, dataInicial, dataFinal, empresas);
    }

    public List<SaldoEstoqueGeralDetBasico> findSaldoTodosProdutosProprioNCMInicialFinal(Date dataConsultaEstoque, List<Map> ncms, Empresa emp, long idProdInicial, long idProdFinal, EnumConstCentroEstTipoPropTerc tipoCentroEstoque) {
        return this.daoSaldoEstoque.findSaldoTodosProdutosProprioNCMInicialFinal(dataConsultaEstoque, ncms, emp, idProdInicial, idProdFinal, tipoCentroEstoque);
    }

    public List<SaldoEstoqueGeralBasico> findSaldoEstoqueBasico(SaldoEstoqueParams params) {
        return this.daoSaldoEstoque.findSaldoEstoqueGeralBasico(params);
    }

    public List<SaldoEstoqueGeral> findSaldoEstoque(SaldoEstoqueParams params) {
        return this.daoSaldoEstoque.findSaldoEstoqueGeral(params);
    }

    public List<SaldoEstoqueGeralDetBasico> findSaldoEstoqueDetBasico(SaldoEstoqueParams params) {
        return this.daoSaldoEstoque.findSaldoEstoqueDetBasico(params);
    }

    public List<HashMap> findProdutosRessuprimentoEstoque(Date dataRessuprimento, Fabricante fabricante, Especie especie, SubEspecie subEspecie, GrupoProdutos grupoProdutos, ClassificacaoAnaliseEstoque classificacao, Empresa empresa, Short tipoProduto, Short tipoCentroEstoquePropTerc) {
        return this.daoSaldoEstoque.findProdutosRessuprimentoEstoque(dataRessuprimento, fabricante, especie, subEspecie, grupoProdutos, classificacao, empresa, tipoProduto, tipoCentroEstoquePropTerc);
    }

    public List getSaldoProdutoNecessidadeCompraProduto(Date data, Long produtoInicial, Long produtoFinal, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long centroEstInicial, Long centroEstFinal, Long fabricanteInicial, Long fabricanteFinal, Long gradeInicial, Long gradeFinal, Long idGrupoProdutos, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Short tipoPesquisa, Long idEmpresa, Short produtosSemMovimentacao, EnumConstSaldoEstTipoSaldo tipoSaldo, EnumConstSaldoEstTipoSaldoQtde tipoQtde, EnumConstSaldoEstTipoCarregQtdeVlr tipoCarregamento, EnumConstCentroEstDisponibilidade tipoDisponibilidade, EnumConstCentroEstTipoPropTerc tipoCentroEstPropTerc) {
        return this.daoSaldoEstoque.getSaldoProdutoNecessidadeCompraProduto(data, produtoInicial, produtoFinal, especieInicial, especieFinal, subEspecieInicial, subEspecieFinal, centroEstInicial, centroEstFinal, fabricanteInicial, fabricanteFinal, gradeInicial, gradeFinal, idGrupoProdutos, tipoProdutoInicial, tipoProdutoFinal, tipoPesquisa, idEmpresa, produtosSemMovimentacao, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoCentroEstPropTerc);
    }

    public Double getSaldoEstoqueItem(Long produto, Long dataPedido, CapsEmpresa capsEmpresa) throws ExceptionValidacaoDados, ExceptionObjNotFound {
        Empresa empresa = (Empresa)this.serviceEmpresaImpl.getOrThrow(capsEmpresa.get());
        Produto prod = (Produto)this.serviceProdutoImpl.get(produto);
        if (this.isNull(prod).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.0065.003", new Object[0]);
        }
        if (this.isNull(dataPedido).booleanValue() || dataPedido <= 0L) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("V.ERP.0287.001"));
        }
        SaldoEstoqueGeralBasico saldo = this.findSaldoProdutoBasico(prod, empresa, new Date(dataPedido), EnumConstSaldoEstTipoSaldo.TIPO_SALDO_PRODUTO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_TUDO, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_DISPONIVEL, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
        if (saldo != null) {
            return saldo.getQuantidade();
        }
        return 0.0;
    }
}

